/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.core.util.Guid;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteDirectoryCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.DetermineServerReachCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.GetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IDeleteDirectoryCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IDeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IDetermineServerReachCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IFileServerCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IFileServerCommandFactory;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IGetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IListContentCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IModifyPermissionCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IQueryServerStatusCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IValidateDirectoryExistenceCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.InvalidFileServerCommandException;
import org.eclipse.hyades.internal.execution.core.file.dynamic.ListContentCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.ModifyPermissionCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.PutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.QueryServerStatusCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.ValidateDirectoryExistenceCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannelFactory;
import org.eclipse.hyades.internal.execution.core.file.socket.SocketChannelFactory;

public class FileServerCommandFactory
implements IFileServerCommandFactory {
    private static final float DEFAULT_CONNECT_RETRY_CALCULATION_FACTOR = 0.9f;
    private static final int DEFAULT_CONNECT_RETRY_CUTOFF = 2000;
    private static final int DEFAULT_CONNECT_RETRY_INITIAL_TIMEOUT = 3000;
    private static final int DEFAULT_CONNECT_RETRY_OFFSET = 200;
    private static final HashMap factories = new HashMap();
    private static IFileServerCommandFactory factory;
    private InetSocketAddress address;
    private String identity;
    private ISocketChannelFactory socketFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static String deriveLookupKey(InetSocketAddress fileServerAddress, ISocketChannelFactory socketFactory) {
        return fileServerAddress + "~" + socketFactory;
    }

    public static synchronized IFileServerCommandFactory getInstance() {
        return FileServerCommandFactory.getInstance(SocketChannelFactory.getInstance());
    }

    public static synchronized IFileServerCommandFactory getInstance(IFileLocation fileServerLocation, ISocketChannelFactory socketFactory) {
        InetAddress address = fileServerLocation.getInetAddress();
        int port = fileServerLocation.getPort();
        InetSocketAddress fileServerAddress = new InetSocketAddress(address, port);
        return FileServerCommandFactory.getInstance(fileServerAddress, socketFactory);
    }

    public static synchronized IFileServerCommandFactory getInstance(InetSocketAddress fileServerAddress, ISocketChannelFactory socketFactory) {
        IFileServerCommandFactory factory = (IFileServerCommandFactory)factories.get(FileServerCommandFactory.deriveLookupKey(fileServerAddress, socketFactory));
        if (factory == null) {
            factory = new FileServerCommandFactory(fileServerAddress, socketFactory);
            factories.put(FileServerCommandFactory.deriveLookupKey(fileServerAddress, socketFactory), factory);
        }
        return factory;
    }

    public static synchronized IFileServerCommandFactory getInstance(ISocketChannelFactory socketFactory) {
        if (factory == null) {
            factory = new FileServerCommandFactory(socketFactory);
        }
        return factory;
    }

    private FileServerCommandFactory(InetSocketAddress address, ISocketChannelFactory socketFactory) {
        this(socketFactory);
        this.address = address;
    }

    private FileServerCommandFactory(ISocketChannelFactory socketFactory) {
        this.socketFactory = socketFactory;
        this.identity = this.generateIdentity();
    }

    private synchronized ISocketChannel connectSocketChannel() throws ServerNotAvailableException {
        return this.connectSocketChannel(3200);
    }

    private synchronized ISocketChannel connectSocketChannel(int timeout) throws ServerNotAvailableException {
        try {
            return this.socketFactory.create(this.address);
        }
        catch (SocketException e1) {
            if (e1 instanceof BindException || e1 instanceof ConnectException) {
                e1.printStackTrace();
                if (e1.getMessage().indexOf("refuse") != -1) {
                    throw new ServerNotAvailableException(e1);
                }
                try {
                    if (timeout < 2000) {
                        throw new ServerNotAvailableException(e1);
                    }
                    System.err.println("About to wait for " + timeout + " seconds!");
                    this.wait(timeout);
                    return this.connectSocketChannel(this.recalculateTimeout(timeout));
                }
                catch (InterruptedException e2) {
                    throw new ServerNotAvailableException(e2);
                }
            }
            throw new ServerNotAvailableException(e1);
        }
        catch (Throwable t) {
            throw new ServerNotAvailableException(t);
        }
    }

    public IDeleteDirectoryCommand createDeleteDirectoryCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new DeleteDirectoryCommand(this.identity, this.connectSocketChannel(), remoteIdentifiers, monitor);
    }

    public IDeleteFileCommand createDeleteFileCommand(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) {
        return new DeleteFileCommand(this.identity, cookie, monitor);
    }

    public IDeleteFileCommand createDeleteFileCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new DeleteFileCommand(this.identity, this.connectSocketChannel(), remoteIdentifiers, monitor);
    }

    public IDetermineServerReachCommand createDetermineServerReachCommand(String host, int port) throws ServerNotAvailableException {
        return new DetermineServerReachCommand(this.identity, this.connectSocketChannel(), host, port);
    }

    public IFileServerCommand createFileServerCommand(String identity, ISocketChannel clientChannel) throws InvalidFileServerCommandException {
        try {
            FileSystemServices.println("Attempting dynamic class loading of command class " + identity, this);
            Class<?> classObject = Thread.currentThread().getContextClassLoader().loadClass(identity);
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Constructor<?> constructor = classObject.getConstructor(classArray);
            IFileServerCommand command = (IFileServerCommand)constructor.newInstance(this.identity, clientChannel);
            FileSystemServices.println("New instance of command class constructed from the command class " + identity, this);
            return command;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InvalidFileServerCommandException();
        }
    }

    public IGetFileCommand createGetFileCommand(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new GetFileCommand(this.identity, this.connectSocketChannel(), localIdentifiers, remoteIdentifiers, options, monitor);
    }

    public IListContentCommand createListContentCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        return new ListContentCommand(this.identity, remoteIdentifiers, monitor);
    }

    public IModifyPermissionCommand createModifyPermissionCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) {
        return new ModifyPermissionCommand(this.identity, remoteIdentifiers, permissionDirective, monitor);
    }

    public IPutFileCommand createPutFileCommand(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new PutFileCommand(this.identity, this.connectSocketChannel(), cookie, localIdentifiers, remoteIdentifiers, options, monitor);
    }

    public IQueryServerStatusCommand createQueryServerStatusCommand() throws ServerNotAvailableException {
        return new QueryServerStatusCommand(this.identity, IFileManagerExtended.Cookie.NONE, this.connectSocketChannel());
    }

    public IValidateDirectoryExistenceCommand createValidateDirectoryExistenceCommand(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws ServerNotAvailableException {
        return new ValidateDirectoryExistenceCommand(this.identity, this.connectSocketChannel(), remoteIdentifiers, monitor);
    }

    private String generateIdentity() {
        return new Guid().toString();
    }

    private int recalculateTimeout(int timeout) {
        float recalculatedTimeout = (float)timeout * 0.9f + 200.0f;
        return Math.round(recalculatedTimeout);
    }

    public void reset() {
        this.identity = this.generateIdentity();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [identity=" + this.identity + (this.address != null && this.address.toString().trim().length() > 0 ? ", address=" + this.address.toString() : "") + "]";
    }
}

