/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.communicator.IChannelCommunicator;
import org.eclipse.hyades.internal.execution.core.file.dynamic.AbstractFileInspectionCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IValidateDirectoryExistenceCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class ValidateDirectoryExistenceCommand
extends AbstractFileInspectionCommand
implements IValidateDirectoryExistenceCommand {
    private boolean[] isDirectoryExistent;
    static /* synthetic */ Class class$0;

    ValidateDirectoryExistenceCommand(String context, ISocketChannel channel, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.ValidateDirectoryExistenceCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, (Class)clazz, remoteIdentifiers, monitor);
        this.setState(new Client(channel));
    }

    public ValidateDirectoryExistenceCommand(String context, ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.ValidateDirectoryExistenceCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.setState(new Server(channel));
    }

    public boolean[] isDirectoryExistent() {
        return this.isDirectoryExistent;
    }

    public boolean[] receiveBooleans(IChannelCommunicator communicator) throws IOException {
        int length = communicator.receiveInt();
        boolean[] booleans = new boolean[length];
        if (length >= 0) {
            byte[] bytes = communicator.receiveBytes(length);
            int i = 0;
            while (i < booleans.length) {
                booleans[i] = bytes[i] == 127;
                ++i;
            }
        } else {
            throw new IOException();
        }
        return booleans;
    }

    public void send(IChannelCommunicator communicator, boolean[] data) throws IOException {
        communicator.send(data.length);
        byte[] bytes = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            bytes[i] = data[i] ? 127 : -128;
            ++i;
        }
        communicator.send(bytes);
    }

    private class Client
    extends AbstractFileInspectionCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = ValidateDirectoryExistenceCommand.this.remoteIdentifiers;
            this.communicator.send(remoteIdentifiers.size());
            this.communicator.send(remoteIdentifiers.getArray());
            ValidateDirectoryExistenceCommand.this.isDirectoryExistent = ValidateDirectoryExistenceCommand.this.receiveBooleans(this.communicator);
        }
    }

    private class Server
    extends AbstractFileInspectionCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            int count = this.communicator.receiveInt();
            ValidateDirectoryExistenceCommand.this.isDirectoryExistent = new boolean[count];
            ValidateDirectoryExistenceCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.communicator.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteDir = new File(fileName);
                if (remoteDir.exists() && !remoteDir.isFile()) {
                    ((ValidateDirectoryExistenceCommand)ValidateDirectoryExistenceCommand.this).isDirectoryExistent[count - 1] = true;
                    FileSystemServices.println("Absolute file identifier " + remoteDir.getAbsolutePath() + " verified to be valid and existent on server", this);
                } else {
                    FileSystemServices.println("Absolute file identifier " + remoteDir.getAbsolutePath() + " not identified and therefore ignoring inspection request", this);
                }
                --count;
            }
            ValidateDirectoryExistenceCommand.this.send(this.communicator, ValidateDirectoryExistenceCommand.this.isDirectoryExistent);
        }
    }
}

