/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.socket;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class SocketChannel
implements ISocketChannel {
    private final Channel channel;
    private final ReadableByteChannel readable;
    private final Socket socket;
    private final WritableByteChannel writable;

    SocketChannel(java.nio.channels.SocketChannel realChannel) {
        this.channel = realChannel;
        this.readable = realChannel;
        this.writable = realChannel;
        this.socket = realChannel.socket();
    }

    SocketChannel(Socket socket) throws IOException {
        this.channel = new ChannelInterfaceAdapter();
        FilterInputStream filteredInputStream = new FilterInputStream(socket.getInputStream()){};
        FilterOutputStream filteredOutputStream = new FilterOutputStream(socket.getOutputStream()){};
        this.readable = Channels.newChannel(filteredInputStream);
        this.writable = Channels.newChannel(filteredOutputStream);
        this.socket = socket;
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.readable != null) {
            this.readable.close();
        }
        if (this.writable != null) {
            this.writable.close();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.readable.read(buffer);
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.writable.write(buffer);
    }

    private class ChannelInterfaceAdapter
    implements Channel {
        private ChannelInterfaceAdapter() {
        }

        public void close() throws IOException {
            SocketChannel.this.socket.close();
        }

        public boolean isOpen() {
            return !SocketChannel.this.socket.isClosed();
        }
    }
}

