/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannelFactory;
import org.eclipse.hyades.internal.execution.core.file.socket.SocketChannel;

public class SocketChannelFactory
implements ISocketChannelFactory {
    private static final ISocketChannelFactory factory = new SocketChannelFactory();

    public static ISocketChannelFactory getInstance() {
        return factory;
    }

    protected SocketChannelFactory() {
    }

    public ISocketChannel create(InetSocketAddress address) throws IOException {
        return this.create(address, 60000);
    }

    public ISocketChannel create(InetSocketAddress address, int timeout) throws IOException {
        java.nio.channels.SocketChannel socketChannel = java.nio.channels.SocketChannel.open();
        socketChannel.configureBlocking(true);
        Socket socket = socketChannel.socket();
        socket.setSoTimeout(timeout);
        socket.setTcpNoDelay(true);
        socket.setReuseAddress(true);
        socketChannel.connect(address);
        return new SocketChannel(socketChannel);
    }

    public ISocketChannel create(java.nio.channels.SocketChannel realChannel) {
        return new SocketChannel(realChannel);
    }

    public ISocketChannel create(Socket socket) throws IOException {
        return new SocketChannel(socket);
    }
}

