/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.file;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.socket.SocketChannelFactory;
import org.eclipse.hyades.internal.execution.file.FileServer;
import org.eclipse.hyades.internal.execution.file.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.IFileServer;
import org.eclipse.hyades.internal.execution.file.IFileServerParameters;

class FileServerExtended
implements Runnable,
IFileServer {
    private static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    private int errorType = 0;
    private int initStatus = 0;
    private boolean isRunning = false;
    private IFileServerParameters parameters;
    private ServerSocketChannel serverSocket;
    private int serverStatus = 0;
    private boolean shutdown = false;

    FileServerExtended() {
    }

    private void cleanup() {
        try {
            this.serverSocket.close();
            this.serverSocket = null;
            this.parameters = null;
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {}
    }

    protected void finalize() {
        this.cleanup();
    }

    public int getErrorType() {
        return this.errorType;
    }

    public synchronized int getFileServerStatus() {
        if (this.initStatus != 1) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.serverStatus;
    }

    private int getPort() {
        return this.parameters.getPort();
    }

    public void init(IFileServerParameters parameters) {
        this.parameters = parameters;
    }

    public void quit() {
        this.shutdown = true;
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        FileServerExtended fileServerExtended = this;
        synchronized (fileServerExtended) {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
        }
        try {
            try {
                fileServerExtended = this;
                synchronized (fileServerExtended) {
                    this.serverSocket = ServerSocketChannel.open();
                    this.serverSocket.configureBlocking(true);
                    this.serverSocket.socket().setSoTimeout(5000);
                    this.serverSocket.socket().bind(new InetSocketAddress(this.getPort()));
                    FileServer.setServerPort(this.serverSocket.socket().getLocalPort());
                    this.initStatus = 1;
                    this.notifyAll();
                    FileSystemServices.println("Extended file server initialized", this);
                }
                while (!this.shutdown) {
                    FileSystemServices.println("Extended file server listening for connections on port " + this.getPort(), this);
                    SocketChannel clientChannel = this.serverSocket.accept();
                    clientChannel.socket().setSoTimeout(5000);
                    clientChannel.socket().setTcpNoDelay(true);
                    IConnectionHandler handler = (IConnectionHandler)this.parameters.getConnectionHandler();
                    handler.connectionAccepted(SocketChannelFactory.getInstance().create(clientChannel));
                }
            }
            catch (BindException e) {
                FileSystemServices.println(String.valueOf("An exception occurred while attempting to bind file server socket detailed as \"".concat(e.getMessage())) + "\"", this);
                System.out.println("\r\nThe agent controller file service cannot initialize due to a bind exception; port " + this.getPort() + " may already be in use by another instance\r\nof the agent controller or another non-TPTP application.");
                this.serverStatus = -1;
                this.errorType = -10;
                this.initStatus = 1;
            }
            catch (IOException iOException) {
                this.serverStatus = -1;
                this.errorType = -9;
                this.initStatus = 1;
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanup();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.cleanup();
            return;
        }
    }
}

