/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.ConsoleNotStartedException;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;

public class LaunchProcessCommand
extends CommandElement
implements Constants {
    private long _consoleIP = 0L;
    private long _consolePort = 0L;
    private RAString _exe = new RAString("");
    private RAString _args = new RAString("");
    private RAString _location = new RAString("");
    private Vector _environment = new Vector();
    private Vector _agents = new Vector();

    public LaunchProcessCommand() {
        this._tag = 16L;
    }

    public void addAgent(String name) {
        this._agents.addElement(new RAString(name));
    }

    public void addEnvironmentVariable(String name, String value) {
        this._environment.addElement(new RAString(String.valueOf(name) + "=" + value));
    }

    public String getArgs() {
        if (this._args != null) {
            return this._args.getData();
        }
        return null;
    }

    public long getConsoleIP() {
        return this._consoleIP;
    }

    public long getConsolePort() {
        return this._consolePort;
    }

    public String getExe() {
        if (this._exe != null) {
            return this._exe.getData();
        }
        return null;
    }

    public String getLocation() {
        if (this._location != null) {
            return this._location.getData();
        }
        return null;
    }

    public Vector getEnvironment() {
        if (this._environment != null) {
            return this._environment;
        }
        return null;
    }

    public Vector getAgents() {
        if (this._agents != null) {
            return this._agents;
        }
        return null;
    }

    public int getSize() {
        int size = super.getSize();
        size += 4;
        size += 4;
        size += this._exe.getSize();
        size += this._args.getSize();
        size += this._location.getSize();
        size += 4;
        int i = 0;
        while (i < this._environment.size()) {
            size += ((RAString)this._environment.elementAt(i)).getSize();
            ++i;
        }
        size += 4;
        i = 0;
        while (i < this._agents.size()) {
            size += ((RAString)this._agents.elementAt(i)).getSize();
            ++i;
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        RAString envVar;
        int current = offset;
        current = super.readFromBuffer(buffer, current);
        this._consoleIP = Message.readRALongFromBuffer(buffer, current);
        this._consolePort = Message.readRALongFromBuffer(buffer, current += 4);
        current += 4;
        current = Message.readRAStringFromBuffer(buffer, current, this._exe);
        current = Message.readRAStringFromBuffer(buffer, current, this._args);
        current = Message.readRAStringFromBuffer(buffer, current, this._location);
        long listLength = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        int i = 0;
        while ((long)i < listLength) {
            envVar = new RAString();
            current = Message.readRAStringFromBuffer(buffer, current, envVar);
            this._environment.addElement(envVar);
            ++i;
        }
        listLength = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        i = 0;
        while ((long)i < listLength) {
            envVar = new RAString();
            current = Message.readRAStringFromBuffer(buffer, current, envVar);
            this._agents.addElement(envVar);
            ++i;
        }
        return current;
    }

    public void setArgs(String args) {
        this._args = new RAString(args);
    }

    public void setConsole(Console console) throws ConsoleNotStartedException {
        this._consoleIP = console.getIP();
        this._consolePort = console.getPort();
    }

    public void setConsole(long id) {
        this._consoleIP = 0L;
        this._consolePort = id;
    }

    public void setExe(String exe) {
        this._exe = new RAString(exe);
    }

    public void setLocation(String location) {
        this._location = new RAString(location);
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.writeToBuffer(buffer, current);
        current = Message.writeRALongToBuffer(buffer, current, this._consoleIP);
        current = Message.writeRALongToBuffer(buffer, current, this._consolePort);
        current = Message.writeRAStringToBuffer(buffer, current, this._exe);
        current = Message.writeRAStringToBuffer(buffer, current, this._args);
        current = Message.writeRAStringToBuffer(buffer, current, this._location);
        current = Message.writeRALongToBuffer(buffer, current, this._environment.size());
        int i = 0;
        while (i < this._environment.size()) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this._environment.elementAt(i));
            ++i;
        }
        current = Message.writeRALongToBuffer(buffer, current, this._agents.size());
        i = 0;
        while (i < this._agents.size()) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this._agents.elementAt(i));
            ++i;
        }
        return current;
    }
}

