/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.DetailedProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;

public class ProcessLaunchedCommand
extends DetailedProcessCommand {
    RAString _exe = new RAString("");
    RAString _args = new RAString("");
    Vector _environment = new Vector();

    public ProcessLaunchedCommand() {
        this._tag = 32L;
    }

    public void addEnvironmentVariable(String name, String value) {
        this._environment.addElement(new RAString(String.valueOf(name) + "=" + value));
    }

    public String getArgs() {
        if (this._args != null) {
            return this._args.getData();
        }
        return null;
    }

    public String[] getEnvironment() {
        String[] result = new String[this._environment.size()];
        int i = 0;
        while (i < this._environment.size()) {
            result[i] = ((RAString)this._environment.elementAt(i)).getData();
            ++i;
        }
        return result;
    }

    public String getExe() {
        if (this._exe != null) {
            return this._exe.getData();
        }
        return null;
    }

    public int getSize() {
        int size = super.getSize();
        size += this._exe.getSize();
        size += this._args.getSize();
        size += 4;
        int i = 0;
        while (i < this._environment.size()) {
            size += ((RAString)this._environment.elementAt(i)).getSize();
            ++i;
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        current = Message.readRAStringFromBuffer(buffer, current, this._exe);
        current = Message.readRAStringFromBuffer(buffer, current, this._args);
        long listLength = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        int i = 0;
        while ((long)i < listLength) {
            RAString envVar = new RAString("");
            current = Message.readRAStringFromBuffer(buffer, current, envVar);
            this._environment.addElement(envVar);
            ++i;
        }
        return current;
    }

    public void setArgs(String args) {
        this._args = new RAString(args);
    }

    public void setExe(String exe) {
        this._exe = new RAString(exe);
    }

    public void setEnvironment(String[] env) {
        if (env != null) {
            int count = env.length;
            int i = 0;
            while (i < count) {
                RAString entry = new RAString(env[i]);
                this._environment.add(entry);
                ++i;
            }
        }
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = super.writeToBuffer(buffer, offset);
        current = Message.writeRAStringToBuffer(buffer, current, this._exe);
        current = Message.writeRAStringToBuffer(buffer, current, this._args);
        current = Message.writeRALongToBuffer(buffer, current, this._environment.size());
        int i = 0;
        while (i < this._environment.size()) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this._environment.elementAt(i));
            ++i;
        }
        return current;
    }
}

