/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;

public class RegisteredProcessListCommand
extends CommandElement
implements Constants {
    private int _processListLength = 0;
    private long[] _processList;

    public RegisteredProcessListCommand() {
        this._tag = 33L;
    }

    public RegisteredProcessListCommand(long[] p) {
        this._tag = 33L;
        this._processList = p;
        this._processListLength = p.length;
    }

    public long[] getProcessList() {
        return this._processList;
    }

    public int getSize() {
        int size = super.getSize();
        size += 4;
        return size += 4 * this._processListLength;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.readFromBuffer(buffer, current);
        this._processListLength = (int)Message.readRALongFromBuffer(buffer, current);
        current += 4;
        this._processList = new long[this._processListLength];
        int i = 0;
        while (i < this._processListLength) {
            this._processList[i] = Message.readRALongFromBuffer(buffer, current);
            current += 4;
            ++i;
        }
        return current;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.writeToBuffer(buffer, current);
        current = Message.writeRALongToBuffer(buffer, current, this._processListLength);
        int i = 0;
        while (i < this._processListLength) {
            current = Message.writeRALongToBuffer(buffer, current, this._processList[i]);
            ++i;
        }
        return current;
    }
}

