/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.ContextMapper;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.tptp.platform.agentcontroller.internal.DirectConnectionListener;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConnectionFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.DirectControlConnectionImpl;

public class LocalConnectionImpl
implements Connection,
DirectConnectionListener {
    private Node _node = null;
    private ContextMapper _contextMapper = new ContextMapper();
    private long _context = 0L;
    private Object _contextLock = new Object();
    private Vector _authenticationlisteners = new Vector();
    private Vector _connectionListeners = new Vector();
    private DirectControlConnectionImpl _control;
    private boolean _isActive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticationListener(AuthenticationListener listener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (!this._authenticationlisteners.contains(listener)) {
                this._authenticationlisteners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        Vector vector = this._connectionListeners;
        synchronized (vector) {
            if (!this._connectionListeners.contains(listener)) {
                this._connectionListeners.add(listener);
            }
        }
    }

    public void connect(Node node, int port) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._control = ConnectionFactoryImpl.createDirectControlConnection();
        this._control.setDirectConnectionListener(this);
        Enumeration listeners = this._authenticationlisteners.elements();
        while (listeners.hasMoreElements()) {
            ((AuthenticationListener)listeners.nextElement()).authenticationSuccessful(this);
        }
        this._isActive = true;
    }

    public void disconnect() {
        this._control.removeDirectConnectionListener();
        this._control = null;
        Enumeration listeners = this._connectionListeners.elements();
        while (listeners.hasMoreElements()) {
            ((ConnectionListener)listeners.nextElement()).connectionClosed(this);
        }
        this._isActive = false;
    }

    public Node getNode() {
        return this._node;
    }

    public int getPort() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incommingCommand(Node node, CommandElement command) {
        long context = command.getContext();
        switch ((int)command.getTag()) {
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Vector vector = this._authenticationlisteners;
                synchronized (vector) {
                    Enumeration listeners = this._authenticationlisteners.elements();
                    while (listeners.hasMoreElements()) {
                        ((AuthenticationListener)listeners.nextElement()).authenticationSuccessful(this);
                    }
                    break;
                }
            }
            default: {
                CommandHandler ch = this._contextMapper.getHandler(context);
                if (ch == null) break;
                ch.incommingCommand(node, command);
            }
        }
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void objectReceived(Object obj) {
        if (obj instanceof ControlMessage) {
            ControlMessage cmsg = (ControlMessage)obj;
            int count = cmsg.getCommandCount();
            int i = 0;
            while (i < count) {
                this.incommingCommand(this._node, cmsg.getCommand(i));
                ++i;
            }
        }
    }

    public void peerClosed() {
        this._isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationListener(AuthenticationListener listener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (this._authenticationlisteners.contains(listener)) {
                this._authenticationlisteners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        Vector vector = this._connectionListeners;
        synchronized (vector) {
            if (this._connectionListeners.contains(listener)) {
                this._connectionListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException {
        if (handler != null) {
            Object object = this._contextLock;
            synchronized (object) {
                int numCommands = msg.getCommandCount();
                int i = 0;
                while (i < numCommands) {
                    msg.getCommand(i).setContext(this._context);
                    this._contextMapper.addContext(this._context, handler);
                    ++this._context;
                    ++i;
                }
            }
        }
        this._control.sendToQueue(msg);
    }

    public void setNode(Node node) {
        this._node = node;
        this._contextMapper.addContext(0L, this._node);
        ++this._context;
    }
}

