/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.GetPropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.KillProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.PropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.common.SimpleProcessCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionFactory;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.LocalConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.NotImplementedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.AgentControllerFactoryImpl;

public class NodeImpl
implements Node,
Constants {
    private static int DEFAULT_TIMEOUT = 15000;
    private String _name;
    private InetAddress[] _addr;
    private Connection _connection;
    private Application _application;
    private Hashtable _processList = new Hashtable(256);
    private SetNVPairCommand[] props = null;
    private InnerProcessListener _processListener = new InnerProcessListener();
    private InnerConnectionListener _connectionListener = new InnerConnectionListener();
    private InnerCommandHandler _commandHandler = new InnerCommandHandler();
    private Object _processListLock = new Object();
    private Object _agentListLock = new Object();
    private Object _agentDetailsLock = new Object();
    private Object _propertyListLock = new Object();
    private boolean _isAuthenticated = false;
    private int _authenticationTimeout = 10000;
    private Object _authenticationLock = new Object();
    private User _user = null;
    private ISecureClientParameters _securityParms = null;

    public NodeImpl(String name, InetAddress addr) {
        this._name = name;
        try {
            this._addr = InetAddress.getAllByName(addr.getHostName());
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public NodeImpl(String name, InetAddress[] addr) {
        this._name = name;
        this._addr = addr;
    }

    public void killProcess(Process process) throws InactiveProcessException, NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        if (!process.isActive()) {
            throw new InactiveProcessException();
        }
        ControlMessage message = new ControlMessage();
        KillProcessCommand command = new KillProcessCommand();
        command.setProcessId(Long.parseLong(process.getProcessId()));
        message.appendCommand(command);
        try {
            this._connection.sendMessage(message, this._commandHandler);
        }
        catch (IOException iOException) {}
    }

    public void shutdown(long delay) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public void reboot(long delay) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public Enumeration listMonitors() throws NotConnectedException {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration listProcesses() throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        this._connection.addConnectionListener(this._connectionListener);
        ControlMessage message = new ControlMessage();
        QueryProcessListCommand qplCommand = new QueryProcessListCommand();
        message.appendCommand(qplCommand);
        Object object = this._processListLock;
        synchronized (object) {
            try {
                this._connection.sendMessage(message, this._commandHandler);
                this._processListLock.wait(DEFAULT_TIMEOUT);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Enumeration ePIDs = this._processList.keys();
        while (ePIDs.hasMoreElements()) {
            Long pid = (Long)ePIDs.nextElement();
            ProcessImpl p = (ProcessImpl)this._processList.get(pid);
            message = new ControlMessage();
            QueryAgentListCommand qalCommand = new QueryAgentListCommand();
            qalCommand.setProcessId(pid);
            message.appendCommand(qalCommand);
            Object object2 = this._agentListLock;
            synchronized (object2) {
                try {
                    this._connection.sendMessage(message, this._commandHandler);
                    this._agentListLock.wait(DEFAULT_TIMEOUT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Enumeration eAgents = p.listAgents();
            while (eAgents.hasMoreElements()) {
                Agent ag = (Agent)eAgents.nextElement();
                String agentName = ag.getName();
                message = new ControlMessage();
                QueryAgentDetailsCommand qadCommand = new QueryAgentDetailsCommand();
                qadCommand.setProcessId(pid);
                qadCommand.setAgentName(agentName);
                message.appendCommand(qadCommand);
                Object object3 = this._agentDetailsLock;
                synchronized (object3) {
                    try {
                        this._connection.sendMessage(message, this._commandHandler);
                        this._agentDetailsLock.wait(DEFAULT_TIMEOUT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }
        return this._processList.elements();
    }

    public synchronized Process getProcess(String processId) {
        return (Process)this._processList.get(new Long(processId));
    }

    public InetAddress getInetAddress() {
        if (this._addr != null) {
            return this._addr[0];
        }
        return null;
    }

    public InetAddress[] getAllInetAddresses() {
        return this._addr;
    }

    public String getName() {
        return this._name;
    }

    public boolean isConnected() {
        if (this._connection != null) {
            return this._connection.isActive();
        }
        return false;
    }

    public synchronized Connection connect(int port) throws AgentControllerUnavailableException, SecureConnectionRequiredException, UntrustedAgentControllerException, LoginFailedException {
        Connection testConnection = null;
        int who = AgentControllerFactoryImpl.whoIsRunning();
        if (this.isLocal() && (port <= 0 || port > 0 && who != 2)) {
            if (who == 2) {
                throw new AgentControllerUnavailableException();
            }
            if (!AgentControllerFactoryImpl.getAgentController().isEnabled()) {
                throw new AgentControllerUnavailableException();
            }
            AgentControllerFactoryImpl.getAgentController().start();
            if (this._connection == null || this._connection instanceof ConnectionImpl) {
                this._connection = ConnectionFactory.getLocalConnection(this);
            }
            if (!this._connection.isActive()) {
                try {
                    this._connection.connect(this, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this._connection == null || !this._connection.isActive() || port != this._connection.getPort()) {
            try {
                if (this._securityParms == null) {
                    testConnection = ConnectionFactory.getConnection(this);
                    testConnection.connect(this, port);
                } else {
                    testConnection = ConnectionFactory.getSecuredConnection(this);
                    if (testConnection != null) {
                        testConnection.connect(this, port);
                    }
                }
                this._connection = testConnection;
            }
            catch (IOException iOException) {
                this._connection = null;
                throw new AgentControllerUnavailableException();
            }
        }
        return this._connection;
    }

    public Connection getConnection() {
        if (this._connection == null) {
            return null;
        }
        if (!this._connection.isActive() && this._connection instanceof LocalConnectionImpl) {
            try {
                this._connection.connect(this, 0);
            }
            catch (Exception exception) {}
        }
        return this._connection;
    }

    public ProcessListener getProcessListener() {
        return this._processListener;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public User getUser() {
        return this._user;
    }

    public void setApplication(Application app) {
        this._application = app;
    }

    public Application getApplication() {
        return this._application;
    }

    public void setSecurityParameters(ISecureClientParameters manager) {
        this._securityParms = manager;
    }

    public ISecureClientParameters getSecurityParameters() {
        return this._securityParms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetNVPairCommand[] getPropertyValues(String name, String type) throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        ControlMessage message = new ControlMessage();
        GetPropertyListCommand command = new GetPropertyListCommand();
        command.setName(name);
        command.setType(type);
        message.appendCommand(command);
        Object object = this._propertyListLock;
        synchronized (object) {
            try {
                this._connection.sendMessage(message, this._commandHandler);
                this._propertyListLock.wait(DEFAULT_TIMEOUT);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.props;
    }

    public synchronized Process waitForProcess(String processIdentity, int timeout) throws NotConnectedException, InactiveProcessException {
        try {
            int i = 0;
            int j = timeout / 2000;
            while (i < j) {
                Enumeration processes = this.listProcesses();
                if (processes != null) {
                    while (processes.hasMoreElements()) {
                        Process process = (Process)processes.nextElement();
                        if (!process.getProcessId().equals(processIdentity)) continue;
                        return process;
                    }
                }
                this.wait(2000L);
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    public void removeProcess(long pid) {
        if (this._processList.containsKey(new Long(pid))) {
            this._processList.remove(new Long(pid));
        }
    }

    public void incommingCommand(Node node, CommandElement command) {
        this._commandHandler.incommingCommand(node, command);
    }

    private boolean isLocal() {
        boolean isLocal = false;
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            int i = 0;
            while (i < this._addr.length) {
                if (localAddr.equals(this._addr[i])) {
                    isLocal = true;
                }
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return isLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateUser() {
        if (this._user != null) {
            Object object = this._authenticationLock;
            synchronized (object) {
                try {
                    this._user.login(this._connection, this._commandHandler);
                    this._authenticationLock.wait(this._authenticationTimeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this._isAuthenticated;
    }

    public boolean isUserAuthenticated() {
        return this._isAuthenticated;
    }

    class InnerCommandHandler
    implements CommandHandler {
        InnerCommandHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incommingCommand(Node node, CommandElement command) {
            int tag = (int)command.getTag();
            switch (tag) {
                case 3: {
                    NodeImpl.this._isAuthenticated = true;
                    Object object = NodeImpl.this._authenticationLock;
                    synchronized (object) {
                        NodeImpl.this._authenticationLock.notifyAll();
                        break;
                    }
                }
                case 2: {
                    NodeImpl.this._isAuthenticated = false;
                    Object object = NodeImpl.this._authenticationLock;
                    synchronized (object) {
                        NodeImpl.this._authenticationLock.notifyAll();
                        break;
                    }
                }
                case 33: {
                    Object e_tmp;
                    RegisteredProcessListCommand rplCmd = (RegisteredProcessListCommand)command;
                    long[] pids = rplCmd.getProcessList();
                    if (pids == null || pids.length == 0) {
                        NodeImpl.this._processList.clear();
                    } else {
                        e_tmp = NodeImpl.this._processList.keys();
                        while (e_tmp.hasMoreElements()) {
                            Long pidstr_tmp = (Long)e_tmp.nextElement();
                            Process p_tmp = (Process)NodeImpl.this._processList.get(pidstr_tmp);
                            try {
                                long pid_tmp = Long.parseLong(p_tmp.getProcessId());
                                boolean exist = false;
                                int i = 0;
                                while (i < pids.length) {
                                    if (pids[i] == pid_tmp) {
                                        exist = true;
                                    }
                                    ++i;
                                }
                                if (exist) continue;
                                NodeImpl.this._processList.remove(pidstr_tmp);
                            }
                            catch (Exception exception) {}
                        }
                        int i = 0;
                        while (i < pids.length) {
                            if (!NodeImpl.this._processList.containsKey(new Long(pids[i]))) {
                                Process p = ProcessFactory.createProcess(node, pids[i]);
                                p.setActive(true);
                                NodeImpl.this._processList.put(new Long(pids[i]), p);
                            }
                            ++i;
                        }
                    }
                    e_tmp = NodeImpl.this._processListLock;
                    synchronized (e_tmp) {
                        NodeImpl.this._processListLock.notifyAll();
                        break;
                    }
                }
                case 34: {
                    ActiveAgentListCommand aalCmd = (ActiveAgentListCommand)command;
                    String[] agentNames = aalCmd.getAgents();
                    String processName = aalCmd.getProcessName();
                    long processId = aalCmd.getProcessId();
                    Process p = (Process)NodeImpl.this._processList.get(new Long(processId));
                    p.setName(processName);
                    if (agentNames != null) {
                        int i = 0;
                        while (i < agentNames.length) {
                            Agent newAgent = AgentFactory.createAgent(p, agentNames[i]);
                            newAgent.setActive(true);
                            ++i;
                        }
                    }
                    Object i = NodeImpl.this._agentListLock;
                    synchronized (i) {
                        NodeImpl.this._agentListLock.notifyAll();
                        break;
                    }
                }
                case 40: {
                    AgentDetailsCommand adCmd = (AgentDetailsCommand)command;
                    long processId = adCmd.getProcessId();
                    String processUUID = adCmd.getProcessUUID();
                    String agentName = adCmd.getAgentName();
                    String agentType = adCmd.getAgentType();
                    String agentUUID = adCmd.getAgentUUID();
                    Process p = (Process)NodeImpl.this._processList.get(new Long(processId));
                    if (p != null) {
                        p.setUUID(processUUID);
                        Agent ag = p.getAgent(agentName);
                        if (ag != null) {
                            ag.setType(agentType);
                            ag.setUUID(agentUUID);
                            ag.addAgentListener((ProcessImpl)p);
                        }
                    }
                    Object object = NodeImpl.this._agentDetailsLock;
                    synchronized (object) {
                        NodeImpl.this._agentDetailsLock.notifyAll();
                        break;
                    }
                }
                case 25: 
                case 26: 
                case 29: 
                case 32: 
                case 35: 
                case 36: 
                case 37: 
                case 41: 
                case 128: {
                    SimpleProcessCommand cmd = (SimpleProcessCommand)command;
                    long pid = cmd.getProcessId();
                    Process p = (Process)NodeImpl.this._processList.get(new Long(pid));
                    if (p != null && p instanceof ProcessImpl) {
                        ((ProcessImpl)p).handleCommand(command);
                    }
                    if ((long)tag != 41L) break;
                    NodeImpl.this._processList.remove(new Long(pid));
                    break;
                }
                case 42: {
                    PropertyListCommand qs = (PropertyListCommand)command;
                    NodeImpl.this.props = qs.getPropertyListValues();
                    Object pid = NodeImpl.this._propertyListLock;
                    synchronized (pid) {
                        NodeImpl.this._propertyListLock.notify();
                        break;
                    }
                }
                case 98: 
                case 102: {
                    MonitorPeerRequestCommand cmd = (MonitorPeerRequestCommand)command;
                    long pid = cmd.getProcessId();
                    Process p = (Process)NodeImpl.this._processList.get(new Long(pid));
                    if (p == null) break;
                    try {
                        ((ProcessImpl)p).handleCommand(command);
                        break;
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
    }

    class InnerConnectionListener
    implements ConnectionListener {
        InnerConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(Connection connection) {
            Object object = NodeImpl.this._processListLock;
            synchronized (object) {
                NodeImpl.this._processListLock.notifyAll();
            }
            object = NodeImpl.this._propertyListLock;
            synchronized (object) {
                NodeImpl.this._propertyListLock.notifyAll();
            }
        }
    }

    class InnerProcessListener
    implements ProcessListener {
        InnerProcessListener() {
        }

        public synchronized void processLaunched(Process process) {
            try {
                Long key = new Long(process.getProcessId());
                if (!NodeImpl.this._processList.containsKey(key)) {
                    NodeImpl.this._processList.put(key, process);
                }
            }
            catch (InactiveProcessException inactiveProcessException) {}
        }

        public synchronized void processExited(Process process) {
            try {
                Long key = new Long(process.getProcessId());
                NodeImpl.this._processList.remove(key);
            }
            catch (InactiveProcessException inactiveProcessException) {}
        }
    }
}

