/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.ConsoleInfoCommand;
import org.eclipse.hyades.internal.execution.local.common.ConsoleNotStartedException;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.DetailedAgentInfoCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.LaunchProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.LocalConsole;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.MultiplexedDataServer;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessLaunchedCommand;
import org.eclipse.hyades.internal.execution.local.common.SimpleAgentInfoCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.LocalConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;

public class ProcessImpl
implements Process,
AgentListener,
ConnectionListener {
    protected String _name = null;
    protected String _exe = null;
    protected String _params = null;
    protected String _location = null;
    protected String _processId = null;
    protected String _UUID = null;
    protected Node _node = null;
    protected Console _console = null;
    protected boolean _isActive = false;
    protected boolean _isComplete = false;
    protected Vector _agents = new Vector(10);
    protected Vector _variables = new Vector(20);
    protected Vector _listeners = new Vector(10);
    private Object _launcherLock = new Object();
    private static Object _eclipseLock = new Object();
    private Object _waitForAgentLock = new Object();
    private boolean _noSuchAliasExceptionThrown = false;

    public ProcessImpl(Node node) {
        this(node, 0L);
    }

    public ProcessImpl(Node node, long pid) {
        this(node, null, pid);
    }

    public ProcessImpl(Node node, String executable) {
        this(node, executable, null);
    }

    public ProcessImpl(Node node, String executable, String parameters) {
        this._node = node;
        this._exe = executable;
        this._params = parameters;
        this._console = this.getConsole();
    }

    public ProcessImpl(Node node, String executable, long pid) {
        this._node = node;
        this._exe = executable;
        this._processId = new Long(pid).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws ProcessActiveException, NotConnectedException, NoSuchApplicationException {
        Object object = _eclipseLock;
        synchronized (object) {
            if (this.isActive() || this._isComplete) {
                throw new ProcessActiveException();
            }
            ControlMessage message = new ControlMessage();
            LaunchProcessCommand command = new LaunchProcessCommand();
            command.setExe(this._exe);
            command.setArgs(this._params);
            command.setLocation(this._location);
            this._console = this.getConsole();
            this._console.start();
            try {
                command.setConsole(this._console);
            }
            catch (ConsoleNotStartedException consoleNotStartedException) {}
            Enumeration e1 = this._variables.elements();
            while (e1.hasMoreElements()) {
                Variable var = (Variable)e1.nextElement();
                command.addEnvironmentVariable(var.getName(), var.getValue());
            }
            Enumeration e2 = this._agents.elements();
            while (e2.hasMoreElements()) {
                Agent agent = (Agent)e2.nextElement();
                command.addAgent(agent.getName());
            }
            message.appendCommand(command);
            Connection connection = this._node.getConnection();
            try {
                connection.addConnectionListener(this);
                connection.sendMessage(message, new CommandHandler(){

                    public void incommingCommand(Node node, CommandElement command) {
                        ProcessImpl.this.handleCommand(command);
                    }
                });
            }
            catch (IOException iOException) {
                throw new NotConnectedException();
            }
            Object object2 = this._launcherLock;
            synchronized (object2) {
                try {
                    this._launcherLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._noSuchAliasExceptionThrown) {
                this._noSuchAliasExceptionThrown = false;
                throw new NoSuchApplicationException();
            }
        }
    }

    public void kill(long delay) throws InactiveProcessException, NotConnectedException {
        if (this._node == null) {
            throw new InactiveProcessException();
        }
        this._node.killProcess(this);
    }

    public void addAgent(Agent agent) {
        if (!this._agents.contains(agent)) {
            this._agents.addElement(agent);
        }
    }

    public void removeAgent(Agent agent) {
        if (this._agents.contains(agent)) {
            this._agents.remove(agent);
        }
    }

    public Enumeration listAgents() {
        return ((Vector)this._agents.clone()).elements();
    }

    public void removeInactiveAgents(String[] newList) {
        Enumeration agents = this.listAgents();
        while (agents.hasMoreElements()) {
            Agent a = (Agent)agents.nextElement();
            boolean active = false;
            int i = 0;
            while (i < newList.length) {
                if (a.getName().equals(newList[i])) {
                    active = true;
                }
                ++i;
            }
            if (active) continue;
            this._agents.remove(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAgentsByType(String type) {
        Vector<Agent> results = new Vector<Agent>();
        Vector vector = this._agents;
        synchronized (vector) {
            Enumeration agents = this.listAgents();
            while (agents.hasMoreElements()) {
                Agent agent = (Agent)agents.nextElement();
                String agentType = agent.getType();
                if (agentType == null || !agentType.equals(type)) continue;
                results.addElement(agent);
            }
        }
        return results.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent getAgent(String name) {
        Vector vector = this._agents;
        synchronized (vector) {
            Enumeration agents = this.listAgents();
            while (agents.hasMoreElements()) {
                Agent agent = (Agent)agents.nextElement();
                if (!agent.getName().equals(name)) continue;
                return agent;
            }
        }
        return null;
    }

    public Enumeration getEnvironment() {
        return this._variables.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getUUID() {
        int retryCount = 30;
        int delay = 1000;
        int i = 0;
        while (this._UUID == null && i < retryCount) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        return this._UUID;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
    }

    public Console getConsole() {
        if (this._console == null) {
            Connection conn = this.getNode().getConnection();
            this._console = conn instanceof LocalConnectionImpl ? new LocalConsole() : new Console(this._node);
        }
        return this._console;
    }

    public Console getLocalConsole() {
        if (this._console == null) {
            this._console = new LocalConsole();
        }
        return this._console;
    }

    public void addEnvironmentVariable(Variable variable) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._variables.add(variable);
    }

    public Variable getEnvironmentVariable(String name) {
        Enumeration e = this.getEnvironment();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    public void removeEnvironmentVariable(Variable variable) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._variables.remove(variable);
    }

    public void setExecutable(String exe) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._exe = exe;
    }

    public String getExecutable() {
        return this._exe;
    }

    public void setParameters(String params) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._params = params;
    }

    public String getParameters() {
        return this._params;
    }

    public void setLocation(String location) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._location = location;
    }

    public String getProcessId() throws InactiveProcessException {
        int retryCount = 30;
        int delay = 1000;
        int i = 0;
        while (this._processId == null && i < retryCount) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (this._processId == null) {
            throw new InactiveProcessException();
        }
        return this._processId;
    }

    public void setProcessId(String pid) {
        this._processId = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentActive(Agent agent) {
        if (!this._agents.contains(agent)) {
            this._agents.add(agent);
        }
        Object object = this._waitForAgentLock;
        synchronized (object) {
            this._waitForAgentLock.notifyAll();
        }
    }

    public void agentInactive(Agent agent) {
        if (agent instanceof AgentImpl) {
            AgentImpl _agent = (AgentImpl)agent;
            if (_agent._listeners != null && _agent._listeners.size() > 0) {
                int i = 0;
                while (i < _agent._listeners.size()) {
                    Object listener = _agent._listeners.get(i);
                    if (listener instanceof MultiplexedDataServer) {
                        return;
                    }
                    ++i;
                }
            }
        }
        if (this._agents.contains(agent)) {
            this._agents.remove(agent);
        }
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        Object object = this._launcherLock;
        synchronized (object) {
            this._launcherLock.notify();
        }
    }

    public String getlocation() {
        return this._location;
    }

    public void setUUID(String uuid) {
        this._UUID = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleCommand(CommandElement command) {
        agents = null;
        switch ((int)command.getTag()) {
            case 32: {
                if (this._isActive) {
                    return;
                }
                plc = (ProcessLaunchedCommand)command;
                this._processId = new Long(plc.getProcessId()).toString();
                this._UUID = plc.getProcessUUID();
                this._variables.removeAllElements();
                vars = plc.getEnvironment();
                i = 0;
                block36: while (true) {
                    if (i >= vars.length) {
                        this._isActive = true;
                        try {
                            i = this._listeners;
                            synchronized (i) {
                                e = this._listeners.elements();
                                while (true) {
                                    if (!e.hasMoreElements()) {
                                        break block36;
                                    }
                                    ((ProcessListener)e.nextElement()).processLaunched(this);
                                }
                            }
                        }
                        catch (Throwable value) {
                            name = null;
                            connection = this._node.getConnection();
                            connection.removeConnectionListener(this);
                            if (this.isActive() != false) throw value;
                            if (this._console == null) throw value;
                            this._console.close();
                            throw value;
                        }
                    }
                    equalsOffset = vars[i].indexOf(61);
                    if (equalsOffset > 0) {
                        name = vars[i].substring(0, equalsOffset);
                        value = vars[i].substring(equalsOffset + 1);
                        this._variables.addElement(new Variable(name, value));
                    }
                    ++i;
                }
            }
            {
                name = null;
                connection = this._node.getConnection();
                connection.removeConnectionListener(this);
                if (!this.isActive() && this._console != null) {
                    this._console.close();
                }
                i = this._launcherLock;
            }
            synchronized (i) {
                this._launcherLock.notify();
                return;
            }
            case 35: 
            case 36: {
                aac = (DetailedAgentInfoCommand)command;
                e = this._agents;
                synchronized (e) {
                    agent = null;
                    agents = this._agents.elements();
                    while (agents.hasMoreElements()) {
                        current = (Agent)agents.nextElement();
                        if (!current.getName().equals(aac.getAgentName())) continue;
                        agent = current;
                        break;
                    }
                    if (agent == null) {
                        agent = AgentFactory.createAgent(this, aac.getAgentName(), aac.getAgentType());
                        ((AgentImpl)agent).setUUID(aac.getAgentUUID());
                    }
                    try {
                        agentImpl = (AgentImpl)agent;
                        if (agent.getUUID() == null) {
                            agentImpl.setUUID(aac.getAgentUUID());
                        }
                        agentImpl.handleCommand(command);
                    }
                    catch (ClassCastException v2) {}
                    return;
                }
            }
            case 37: {
                ec = (ErrorCommand)command;
                if (ec.getErrorId().equals("RAC002")) {
                    this._noSuchAliasExceptionThrown = true;
                    agent = this._launcherLock;
                    synchronized (agent) {
                        this._launcherLock.notify();
                    }
                }
                agents = this._agents.elements();
                while (true) {
                    if (!agents.hasMoreElements()) {
                        return;
                    }
                    agent = (Agent)agents.nextElement();
                    if (!agent.getName().equals(ec.getAgentName())) continue;
                    try {
                        ((AgentImpl)agent).handleCommand(command);
                    }
                    catch (ClassCastException v5) {}
                }
            }
            case 41: {
                peCmd = (ProcessExitedCommand)command;
                if (this._console != null) {
                    this._console.close();
                }
                if (this._isComplete) ** GOTO lbl122
                this._isComplete = true;
                agentImpl = this._listeners;
                synchronized (agentImpl) {
                    e = this._listeners.elements();
                    while (true) {
                        if (e.hasMoreElements()) ** GOTO lbl115
                        break;
lbl115:
                        // 1 sources

                        ((ProcessListener)e.nextElement()).processExited(this);
                    }
                }
                this._listeners.clear();
                this._variables.clear();
                this._agents.clear();
lbl122:
                // 2 sources

                agents = this._agents.elements();
                while (true) {
                    if (!agents.hasMoreElements()) {
                        ((NodeImpl)this._node).removeProcess(peCmd.getProcessId());
                        return;
                    }
                    agent = (Agent)agents.nextElement();
                    try {
                        ((AgentImpl)agent).handleCommand(command);
                    }
                    catch (ClassCastException v7) {}
                }
            }
            case 128: {
                ciCmd = (ConsoleInfoCommand)command;
                if (this._console instanceof LocalConsole == false) return;
                ((LocalConsole)this._console).setStdOut(ciCmd.getStdOut());
                ((LocalConsole)this._console).setStdErr(ciCmd.getStdErr());
                ((LocalConsole)this._console).setStdIn(ciCmd.getStdIn());
                return;
            }
            case 98: 
            case 102: {
                cmd = (MonitorPeerRequestCommand)command;
                agentName = cmd.getAgentName();
                agents = this._agents.elements();
                while (true) {
                    if (!agents.hasMoreElements()) {
                        return;
                    }
                    agent = (Agent)agents.nextElement();
                    if (!agent.getName().equals(agentName)) continue;
                    try {
                        ((AgentImpl)agent).handleCommand(command);
                    }
                    catch (ClassCastException v8) {}
                }
            }
        }
        if (command instanceof SimpleAgentInfoCommand == false) return;
        agent = this.getAgent(((SimpleAgentInfoCommand)command).getAgentName());
        try {
            if (agent == null) return;
            ((AgentImpl)agent).handleCommand(command);
            return;
        }
        catch (ClassCastException v9) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent waitForAgent(String agentType, String agentName, int timeout) throws NotConnectedException, InactiveProcessException {
        Object object = this._waitForAgentLock;
        synchronized (object) {
            try {
                int i = 0;
                int j = timeout / 2000;
                while (i < j) {
                    this.getNode().listProcesses();
                    Enumeration agents = this.getAgentsByType(agentType);
                    while (agents.hasMoreElements()) {
                        Agent agent = (Agent)agents.nextElement();
                        if (agent.getName().indexOf(agentName) == -1) continue;
                        return agent;
                    }
                    this._waitForAgentLock.wait(2000L);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

