/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;

public final class Guid {
    private int timeLow = 0;
    private short timeMiddle = 0;
    private short timeHighWithVersion = 0;
    private byte clockSequenceHighWithReserved = 0;
    private byte clockSequenceLow = 0;
    private static long lastTimeStamp = 0L;
    private static long clockSequence = 0L;
    private static int clockSequenceAdjustment = 0;
    private static byte[] pseudoIEEE802MACAddress = null;
    private static Random randomNumberGenerator = null;
    private static boolean isInitialized = false;
    private static final char[] HEXADECIMAL_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Object LOCK = new Object();
    private static final String TEMPORARY_DIRECTORY = System.getProperty("java.io.tmpdir");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guid() {
        long adjustedTimestamp = 0L;
        Object object = LOCK;
        synchronized (object) {
            if (!isInitialized) {
                long uniqueTimeStamp = this.getUniqueTimeStamp();
                pseudoIEEE802MACAddress = this.getPseudoIEEE802MACAddress(uniqueTimeStamp);
                try {
                    randomNumberGenerator = SecureRandom.getInstance("MD5");
                    randomNumberGenerator.setSeed(uniqueTimeStamp);
                }
                catch (Throwable throwable) {
                    randomNumberGenerator = new Random(uniqueTimeStamp);
                }
                clockSequence = randomNumberGenerator.nextLong();
                isInitialized = true;
            }
            boolean timeIsValid = true;
            do {
                if ((adjustedTimestamp = this.getAdjustedTimestamp()) < lastTimeStamp) {
                    clockSequence = randomNumberGenerator.nextLong();
                    clockSequenceAdjustment = 0;
                }
                if (adjustedTimestamp > lastTimeStamp) {
                    clockSequenceAdjustment = 0;
                }
                if (adjustedTimestamp != lastTimeStamp) continue;
                if (clockSequenceAdjustment < 9999) {
                    ++clockSequenceAdjustment;
                    continue;
                }
                timeIsValid = false;
            } while (!timeIsValid);
            lastTimeStamp = adjustedTimestamp;
            if (clockSequenceAdjustment != 0) {
                adjustedTimestamp += (long)clockSequenceAdjustment;
            }
            this.timeLow = (int)(adjustedTimestamp & 0xFFFFFFFFFFFFFFFFL);
            this.timeMiddle = (short)(adjustedTimestamp >>> 32 & 0xFFFFL);
            this.timeHighWithVersion = (short)((short)(adjustedTimestamp >>> 48 & 0xFFFL) | 0xFFFFA000);
            this.clockSequenceLow = (byte)(clockSequence & 0xFFL);
            this.clockSequenceHighWithReserved = (byte)((byte)((clockSequence & 0x3F00L) >>> 8) | 0xFFFFFFC0);
        }
    }

    public String toString() {
        char[] stringBuffer = new char[32];
        int pos = 0;
        int shift = 12;
        while (pos < 4) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeHighWithVersion >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 12;
        while (pos < 8) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeMiddle >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 28;
        while (pos < 16) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeLow >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceHighWithReserved >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceHighWithReserved & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceLow >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceLow & 0xF];
        int i = 0;
        while (pos < 32) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[pseudoIEEE802MACAddress[i] >>> 4 & 0xF];
            stringBuffer[pos + 1] = HEXADECIMAL_CHARACTERS[pseudoIEEE802MACAddress[i] & 0xF];
            ++i;
            pos += 2;
        }
        return new String(stringBuffer).trim();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized byte[] getPseudoIEEE802MACAddress(long uniqueTimeStamp) {
        block7: {
            ieee802Addr = new byte[6];
            currentTime = String.valueOf(uniqueTimeStamp).getBytes();
            localHostAddress = null;
            try {
                localHostAddress = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException v0) {
                v1 = new byte[4];
                v1[0] = 127;
                v1[3] = 1;
                localHostAddress = v1;
            }
            inMemoryObject = Integer.toHexString(new Object().hashCode()).getBytes();
            freeMemory = String.valueOf(Runtime.getRuntime().freeMemory()).getBytes();
            totalMemory = String.valueOf(Runtime.getRuntime().totalMemory()).getBytes();
            messageDigestInput = new byte[currentTime.length + localHostAddress.length + inMemoryObject.length + freeMemory.length + totalMemory.length];
            messageDigestInputIndex = 0;
            System.arraycopy(currentTime, 0, messageDigestInput, messageDigestInputIndex, currentTime.length);
            System.arraycopy(localHostAddress, 0, messageDigestInput, messageDigestInputIndex += currentTime.length, localHostAddress.length);
            System.arraycopy(inMemoryObject, 0, messageDigestInput, messageDigestInputIndex += localHostAddress.length, inMemoryObject.length);
            System.arraycopy(freeMemory, 0, messageDigestInput, messageDigestInputIndex += inMemoryObject.length, freeMemory.length);
            System.arraycopy(totalMemory, 0, messageDigestInput, messageDigestInputIndex += freeMemory.length, totalMemory.length);
            try {
                md5 = MessageDigest.getInstance("MD5");
                md5.reset();
                System.arraycopy(md5.digest(messageDigestInput), 0, ieee802Addr, 0, 6);
                break block7;
            }
            catch (Throwable v2) {
                hashCode = 0;
                counter = 0;
                ** while (counter < messageDigestInput.length)
            }
lbl-1000:
            // 1 sources

            {
                hashCode = 31 * hashCode + messageDigestInput[counter];
                ++counter;
                continue;
            }
lbl34:
            // 1 sources

            hashCodeBytes = Integer.toHexString(hashCode).getBytes();
            if (hashCodeBytes.length < 6) {
                System.arraycopy(hashCodeBytes, 0, ieee802Addr, 6 - hashCodeBytes.length, hashCodeBytes.length);
            } else {
                System.arraycopy(hashCodeBytes, hashCodeBytes.length - 6, ieee802Addr, 0, 6);
            }
        }
        ieee802Addr[0] = (byte)(ieee802Addr[0] | 128);
        return ieee802Addr;
    }

    private synchronized long getAdjustedTimestamp() {
        return System.currentTimeMillis() * 10000L + 122192928000000000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized long getUniqueTimeStamp() {
        File lockFile;
        long timeStamp;
        block18: {
            long l;
            block17: {
                timeStamp = System.currentTimeMillis();
                lockFile = null;
                try {
                    try {
                        lockFile = new File(TEMPORARY_DIRECTORY, "guid.lock");
                        long lastModified = lockFile.lastModified();
                        long maxWaitTimeStamp = System.currentTimeMillis() + 1000L;
                        try {
                            while (!lockFile.createNewFile()) {
                                if (System.currentTimeMillis() <= maxWaitTimeStamp) continue;
                                if (lockFile.lastModified() <= lastModified) {
                                    lockFile.delete();
                                    lastModified = -1L;
                                    continue;
                                }
                                l = timeStamp;
                            }
                        }
                        catch (IOException iOException) {
                            long l2 = timeStamp;
                            Object var8_8 = null;
                            try {
                                if (lockFile == null) return l2;
                                lockFile.delete();
                                return l2;
                            }
                            catch (SecurityException securityException) {}
                            return l2;
                        }
                        {
                            Object var8_7 = null;
                            break block17;
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        timeStamp = System.currentTimeMillis();
                    }
                    catch (SecurityException securityException) {}
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    try {}
                    catch (SecurityException securityException) {}
                    if (lockFile == null) throw throwable;
                    lockFile.delete();
                    throw throwable;
                    throw throwable;
                }
            }
            try {}
            catch (SecurityException securityException) {}
            if (lockFile == null) return l;
            lockFile.delete();
            return l;
        }
        Object var8_10 = null;
        try {}
        catch (SecurityException securityException) {
            return timeStamp;
        }
        if (lockFile == null) return timeStamp;
        lockFile.delete();
        return timeStamp;
    }

    public static String generate() {
        return new Guid().toString();
    }
}

