/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import org.eclipse.hyades.internal.execution.remote.AgentConfiguration;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.QueueManager;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class LoggingAgent {
    public static final String LOGGING_AGENT_TYPE = "Logging";
    private RemoteComponentSkeleton delegate;
    private QueueManager queue;
    private boolean controllerAvailable = false;
    private boolean isMonitored = false;
    private Object currentThreadLock = new Object();

    public LoggingAgent(String name) {
        this(name, 100);
    }

    public LoggingAgent(String name, int bufferSize) {
        this.queue = new QueueManager(bufferSize);
        try {
            this.delegate = new RemoteComponentSkeleton(name, LOGGING_AGENT_TYPE);
            this.delegate.addAgentControllerListener(new AgentControllerListener(){

                public void agentControllerActive() {
                    LoggingAgent.this.controllerAvailable = true;
                }

                public void agentControllerInactive() {
                    LoggingAgent.this.controllerAvailable = false;
                }
            });
            this.delegate.addMonitorListener(new MonitorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void monitorActive() {
                    Object object = LoggingAgent.this.currentThreadLock;
                    synchronized (object) {
                        LoggingAgent.this.isMonitored = true;
                        LoggingAgent.this.currentThreadLock.notify();
                    }
                    LoggingAgent.this.flush();
                }

                public void monitorInactive() {
                    LoggingAgent.this.isMonitored = false;
                    LoggingAgent.this.flush();
                }
            });
            this.delegate.initializeFast();
        }
        catch (Throwable throwable) {
            this.controllerAvailable = false;
        }
    }

    public AgentConfiguration getLoggingAgentDefaultConfiguration() {
        return this.delegate.getDefaultConfiguration();
    }

    public boolean isLogging() {
        return this.controllerAvailable && this.isMonitored;
    }

    public void write(String msg) {
        if (this.isLogging()) {
            this.delegate.logMessageUTF8(msg);
        } else {
            this.enQueue(msg);
        }
    }

    public void enQueue(String msg) {
        this.queue.insertInQueue(msg);
    }

    public void flush() {
        if (this.queue.isFlushNeeded()) {
            this.queue.flushCurrentQueue(this.delegate);
        }
    }

    public void deregister() {
        this.delegate.deregister();
    }

    public String getName() {
        return this.delegate.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilLogging(long maxTime) {
        Object object = this.currentThreadLock;
        synchronized (object) {
            try {
                if (!this.isLogging()) {
                    this.currentThreadLock.wait(maxTime);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.isLogging();
    }

    public void logErrorMessage(String message, String messageId, int severity) {
        this.delegate.logErrMsg(message, messageId, severity);
    }
}

