/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.core.LoggingCoreUtilities;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.SerializableImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class ExtendedDataElementImpl
extends SerializableImpl
implements ExtendedDataElement,
Cloneable {
    private static final long serialVersionUID = -6200886839335499445L;
    private static final EStructuralFeature valuesFeature = EventPackage.eINSTANCE.getExtendedDataElement_Values();
    private static final EStructuralFeature childrenFeature = EventPackage.eINSTANCE.getExtendedDataElement_Children();
    public static final List EDE_TYPES_LIST = Arrays.asList("noValue", "byte", "short", "int", "long", "float", "double", "string", "dateTime", "boolean", "byteArray", "shortArray", "intArray", "longArray", "floatArray", "doubleArray", "stringArray", "dateTimeArray", "booleanArray", "hexBinary");
    public static final String[] EDE_TYPES = EDE_TYPES_LIST.toArray(new String[EDE_TYPES_LIST.size()]);
    private static final char[] HEX_BASE_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final String HEX_VALUE_EDEFAULT = null;
    protected String hexValue = HEX_VALUE_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected EList values = null;
    protected EList children = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected ExtendedDataElementImpl() {
    }

    public EList getChildren() {
        if (this.children == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.logging.events.cbe.ExtendedDataElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.children = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 4);
        }
        return this.children;
    }

    public EList getChildren(String newName) {
        ListIterator it = this.getChildren().listIterator();
        BasicEList res = new BasicEList();
        ExtendedDataElement ede = null;
        while (it.hasNext()) {
            ede = (ExtendedDataElement)it.next();
            if (ede == null || !ede.getName().equals(newName)) continue;
            res.addUnique((Object)ede);
        }
        return res;
    }

    public void setHexValue(String newHexValue) {
        String oldHexValue = this.hexValue;
        this.hexValue = newHexValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldHexValue, (Object)this.hexValue));
        }
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public void setHexValueAsByteArray(byte[] value) {
        this.setHexValue(this.byteArrayToHexBinary(value));
        this.setType("hexBinary");
    }

    public void setHexValueAsCharArray(char[] value) {
        this.setHexValue(new String(value));
        this.setType("hexBinary");
    }

    public byte[] getHexValueAsByteArray() {
        byte[] result = null;
        if (this.getType().equals("hexBinary")) {
            String localHexValue = this.getHexValue();
            if (localHexValue != null) {
                try {
                    result = this.hexBinaryToByteArray(localHexValue);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException(String.valueOf(localHexValue) + " is not a valid xsd:hexBinary value");
                }
            }
        } else {
            throw new IllegalStateException("type is not hexBinary");
        }
        return result;
    }

    public char[] getHexValueAsCharArray() {
        char[] result = null;
        if (this.getType().equals("hexBinary")) {
            String localHexValue = this.getHexValue();
            if (localHexValue != null) {
                try {
                    result = localHexValue.toCharArray();
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException(String.valueOf(localHexValue) + " is not a valid xsd:hexBinary value");
                }
            }
        } else {
            throw new IllegalStateException("type is not hexBinary");
        }
        return result;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldType, (Object)this.type));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setTypeAsInt(int value) {
        switch (value) {
            case 1: {
                this.setType("byte");
                break;
            }
            case 2: {
                this.setType("short");
                break;
            }
            case 3: {
                this.setType("int");
                break;
            }
            case 4: {
                this.setType("long");
                break;
            }
            case 5: {
                this.setType("float");
                break;
            }
            case 6: {
                this.setType("double");
                break;
            }
            case 7: {
                this.setType("string");
                break;
            }
            case 8: {
                this.setType("dateTime");
                break;
            }
            case 9: {
                this.setType("boolean");
                break;
            }
            case 10: {
                this.setType("byteArray");
                break;
            }
            case 11: {
                this.setType("shortArray");
                break;
            }
            case 12: {
                this.setType("intArray");
                break;
            }
            case 13: {
                this.setType("longArray");
                break;
            }
            case 14: {
                this.setType("floatArray");
                break;
            }
            case 15: {
                this.setType("doubleArray");
                break;
            }
            case 16: {
                this.setType("stringArray");
                break;
            }
            case 17: {
                this.setType("dateTimeArray");
                break;
            }
            case 18: {
                this.setType("booleanArray");
                break;
            }
            case 19: {
                this.setType("hexBinary");
                break;
            }
            default: {
                this.setType("noValue");
            }
        }
    }

    public int getTypeAsInt() {
        String t = this.getType();
        if (t != null) {
            if (t.equals("byte")) {
                return 1;
            }
            if (t.equals("short")) {
                return 2;
            }
            if (t.equals("int")) {
                return 3;
            }
            if (t.equals("long")) {
                return 4;
            }
            if (t.equals("float")) {
                return 5;
            }
            if (t.equals("double")) {
                return 6;
            }
            if (t.equals("string")) {
                return 7;
            }
            if (t.equals("dateTime")) {
                return 8;
            }
            if (t.equals("boolean")) {
                return 9;
            }
            if (t.equals("byteArray")) {
                return 10;
            }
            if (t.equals("shortArray")) {
                return 11;
            }
            if (t.equals("intArray")) {
                return 12;
            }
            if (t.equals("longArray")) {
                return 13;
            }
            if (t.equals("floatArray")) {
                return 14;
            }
            if (t.equals("doubleArray")) {
                return 15;
            }
            if (t.equals("stringArray")) {
                return 16;
            }
            if (t.equals("dateTimeArray")) {
                return 17;
            }
            if (t.equals("booleanArray")) {
                return 18;
            }
            if (t.equals("hexBinary")) {
                return 19;
            }
        }
        return 0;
    }

    public EList getValues() {
        if (this.values == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.values = new EDataTypeEList((Class)clazz, (InternalEObject)this, 3);
        }
        return this.values;
    }

    public void setValues(String[] values) {
        this.clearValues();
        EList valueList = this.getValues();
        valueList.addAll(Arrays.asList(values));
    }

    public void clearValues() {
        this.getValues().clear();
    }

    public void setValuesAsBoolean(boolean value) {
        this.setValuesAsString(String.valueOf(value));
        this.setType("boolean");
    }

    public boolean getValuesAsBoolean() {
        if (this.getType().equals("boolean") && this.getValues().size() == 1) {
            return new Boolean((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsBooleanArray(boolean[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)String.valueOf(value[i]));
            ++i;
        }
        this.setType("booleanArray");
    }

    public boolean[] getValuesAsBooleanArray() {
        if (this.getType().equals("booleanArray")) {
            EList newValues = this.getValues();
            boolean[] booleanArray = new boolean[newValues.size()];
            int i = 0;
            while (i < newValues.size()) {
                booleanArray[i] = new Boolean((String)newValues.get(i));
                ++i;
            }
            return booleanArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsByte(byte value) {
        this.setValues(String.valueOf(value));
        this.setType("byte");
    }

    public byte getValuesAsByte() {
        if (this.getType().equals("byte") && this.getValues().size() == 1) {
            return new Byte((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsByteArray(byte[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)String.valueOf(value[i]));
            ++i;
        }
        this.setType("byteArray");
    }

    public byte[] getValuesAsByteArray() {
        if (this.getType().equals("byteArray")) {
            EList newValues = this.getValues();
            byte[] byteArray = new byte[newValues.size()];
            int i = 0;
            while (i < newValues.size()) {
                byteArray[i] = new Byte((String)newValues.get(i));
                ++i;
            }
            return byteArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDate(String value) {
        this.setValues(value);
        this.setType("dateTime");
    }

    public String getValuesAsDate() {
        if (this.getType().equals("dateTime") && this.getValues().size() != 0) {
            return (String)this.getValues().get(0);
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDateArray(String[] value) {
        this.setValues(value);
        this.setType("dateTimeArray");
    }

    public String[] getValuesAsDateArray() {
        if (this.getType().equals("dateTimeArray")) {
            ArrayList valueArray = new ArrayList(this.getValues());
            String[] retArray = new String[valueArray.size()];
            return valueArray.toArray(retArray);
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDateAsLong(long value) {
        this.setValuesAsDate(LoggingCoreUtilities.convertMillisecondsToXsdDateTime(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getValuesAsDateAsLong() {
        long result = 0L;
        if (!this.getType().equals("dateTime")) throw new IllegalStateException("Invalid type " + this.getType());
        if (this.getValues().size() == 0) throw new IllegalStateException("There are " + this.getValues().size() + " elements in the values array");
        try {
            return LoggingCoreUtilities.convertXsdDateTimeToMilliseconds(this.getValuesAsDate());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.valueOf(this.getValuesAsDate()) + " is not a valid xsd:dateTime");
        }
    }

    public void setValuesAsDateAsLongArray(long[] newValues) {
        String[] dateArray = new String[newValues.length];
        int i = 0;
        while (i < newValues.length) {
            dateArray[i] = LoggingCoreUtilities.convertMillisecondsToXsdDateTime(newValues[i]);
            ++i;
        }
        this.setValuesAsDateArray(dateArray);
    }

    public long[] getValuesAsDateAsLongArray() {
        String[] dateArray = this.getValuesAsDateArray();
        long[] longArray = new long[dateArray.length];
        int i = 0;
        while (i < dateArray.length) {
            try {
                longArray[i] = LoggingCoreUtilities.convertXsdDateTimeToMilliseconds(dateArray[i]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.valueOf(dateArray[i]) + " is not a valid xsd:dateTime value");
            }
            ++i;
        }
        return longArray;
    }

    public void setValuesAsDouble(double value) {
        this.setValues(String.valueOf(value));
        this.setType("double");
    }

    public double getValuesAsDouble() {
        if (this.getType().equals("double") && this.getValues().size() == 1) {
            return new Double((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDoubleArray(double[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)String.valueOf(value[i]));
            ++i;
        }
        this.setType("doubleArray");
    }

    public double[] getValuesAsDoubleArray() {
        if (this.getType().equals("doubleArray")) {
            EList localValues = this.getValues();
            double[] doubleArray = new double[localValues.size()];
            int i = 0;
            while (i < localValues.size()) {
                doubleArray[i] = new Double((String)localValues.get(i));
                ++i;
            }
            return doubleArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsFloat(float value) {
        this.setValues(String.valueOf(value));
        this.setType("float");
    }

    public float getValuesAsFloat() {
        if (this.getType().equals("float") && this.getValues().size() == 1) {
            return new Float((String)this.getValues().get(0)).floatValue();
        }
        throw new IllegalStateException();
    }

    public void setValuesAsFloatArray(float[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)String.valueOf(value[i]));
            ++i;
        }
        this.setType("floatArray");
    }

    public float[] getValuesAsFloatArray() {
        if (this.getType().equals("floatArray")) {
            EList localValues = this.getValues();
            float[] floatArray = new float[localValues.size()];
            int i = 0;
            while (i < localValues.size()) {
                floatArray[i] = new Float((String)localValues.get(i)).floatValue();
                ++i;
            }
            return floatArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsInt(int value) {
        this.setValues(Integer.toString(value));
        this.setType("int");
    }

    public int getValuesAsInt() {
        if (this.getType().equals("int") && this.getValues().size() == 1) {
            return Integer.parseInt((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsIntArray(int[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)Integer.toString(value[i]));
            ++i;
        }
        this.setType("intArray");
    }

    public int[] getValuesAsIntArray() {
        if (this.getType().equals("intArray")) {
            EList localValues = this.getValues();
            int[] intArray = new int[localValues.size()];
            int i = 0;
            while (i < localValues.size()) {
                intArray[i] = new Integer((String)localValues.get(i));
                ++i;
            }
            return intArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsLong(long value) {
        this.setValues(String.valueOf(value));
        this.setType("long");
    }

    public long getValuesAsLong() {
        if (this.getType().equals("long") && this.getValues().size() == 1) {
            return new Long((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsLongArray(long[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)String.valueOf(value[i]));
            ++i;
        }
        this.setType("longArray");
    }

    public long[] getValuesAsLongArray() {
        if (this.getType().equals("longArray")) {
            EList localValues = this.getValues();
            long[] longArray = new long[localValues.size()];
            int i = 0;
            while (i < localValues.size()) {
                longArray[i] = new Long((String)localValues.get(i));
                ++i;
            }
            return longArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsShort(short value) {
        this.setValues(String.valueOf(value));
        this.setType("short");
    }

    public short getValuesAsShort() {
        if (this.getType().equals("short") && this.getValues().size() == 1) {
            return new Short((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsShortArray(short[] value) {
        this.clearValues();
        EList valueList = this.getValues();
        int i = 0;
        while (i < value.length) {
            valueList.add((Object)String.valueOf(value[i]));
            ++i;
        }
        this.setType("shortArray");
    }

    public short[] getValuesAsShortArray() {
        if (this.getType().equals("shortArray")) {
            EList localValues = this.getValues();
            short[] shortArray = new short[localValues.size()];
            int i = 0;
            while (i < localValues.size()) {
                shortArray[i] = new Short((String)localValues.get(i));
                ++i;
            }
            return shortArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsString(String value) {
        this.setValues(value);
        this.setType("string");
    }

    public String getValuesAsString() {
        if (this.getType().equals("string") && this.getValues().size() == 1) {
            return (String)this.getValues().get(0);
        }
        throw new IllegalStateException();
    }

    public void setValuesAsStringArray(String[] value) {
        this.setValues(value);
        this.setType("stringArray");
    }

    public String[] getValuesAsStringArray() {
        if (this.getType().equals("stringArray")) {
            ArrayList valueArray = new ArrayList(this.getValues());
            String[] retArray = new String[valueArray.size()];
            return valueArray.toArray(retArray);
        }
        throw new IllegalStateException();
    }

    public ExtendedDataElement addChild(ExtendedDataElement child) {
        this.getChildren().add((Object)child);
        return child;
    }

    public void clearChildren() {
        this.getChildren().clear();
    }

    public void removeChildren(String name) {
        if (this.getChildren() != null) {
            int counter = 0;
            while (counter < this.getChildren().size()) {
                if (((ExtendedDataElement)this.getChildren().get(counter)).getName().equals(name)) {
                    this.getChildren().remove(counter--);
                }
                ++counter;
            }
        }
    }

    public ExtendedDataElement addChild(String newName) {
        ExtendedDataElement ede = EventFactory.eINSTANCE.createExtendedDataElement();
        ede.setName(newName);
        this.getChildren().add((Object)ede);
        return ede;
    }

    public ExtendedDataElement addChild(String newName, int newType, String value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setTypeAsInt(newType);
        if (19 == newType) {
            ede.setHexValue(value);
        } else {
            ede.getValues().add((Object)value);
        }
        return ede;
    }

    public ExtendedDataElement addChild(String newName, int newType, String[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setTypeAsInt(newType);
        ede.getValues().addAll(Arrays.asList(newValues));
        return ede;
    }

    public ExtendedDataElement addChild(String newName, String value) {
        return this.addChild(newName, 7, value);
    }

    public ExtendedDataElement addChild(String newName, String[] newValues) {
        return this.addChild(newName, 16, newValues);
    }

    public ExtendedDataElement addChildWithBooleanArrayValue(String newName, boolean[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsBooleanArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithBooleanValue(String newName, boolean value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsBoolean(value);
        return ede;
    }

    public ExtendedDataElement addChildWithNoValue(String newName) {
        ExtendedDataElement ede = this.addChild(newName);
        this.setTypeAsInt(0);
        return ede;
    }

    public ExtendedDataElement addChildWithByteArrayValue(String newName, byte[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsByteArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithByteValue(String newName, byte value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsByte(value);
        return ede;
    }

    public ExtendedDataElement addChildWithDateArrayValue(String newName, String[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsDateArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithDateAsLongValue(String newName, long value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsDateAsLong(value);
        return ede;
    }

    public ExtendedDataElement addChildWithDateValue(String newName, String value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsDate(value);
        return ede;
    }

    public ExtendedDataElement addChildWithDatesAsLongValue(String newName, long[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsDateAsLongArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithDoubleArrayValue(String newName, double[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsDoubleArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithDoubleValue(String newName, double value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsDouble(value);
        return ede;
    }

    public ExtendedDataElement addChildWithFloatArrayValue(String newName, float[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsFloatArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithFloatValue(String newName, float value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsFloat(value);
        return ede;
    }

    public ExtendedDataElement addChildWithHexValue(String newName, String value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setType("hexBinary");
        ede.setHexValue(value);
        return ede;
    }

    public ExtendedDataElement addChildWithHexValueAsByteArray(String newName, byte[] value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setType("hexBinary");
        ede.setHexValueAsByteArray(value);
        return ede;
    }

    public ExtendedDataElement addChildWithIntArrayValue(String newName, int[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsIntArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithIntValue(String newName, int value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsInt(value);
        return ede;
    }

    public ExtendedDataElement addChildWithLongArrayValue(String newName, long[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsLongArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithLongValue(String newName, long value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsLong(value);
        return ede;
    }

    public ExtendedDataElement addChildWithShortArrayValue(String newName, short[] newValues) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsShortArray(newValues);
        return ede;
    }

    public ExtendedDataElement addChildWithShortValue(String newName, short value) {
        ExtendedDataElement ede = this.addChild(newName);
        ede.setValuesAsShort(value);
        return ede;
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getHexValue();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getType();
            }
            case 3: {
                return this.getValues();
            }
            case 4: {
                return this.getChildren();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return HEX_VALUE_EDEFAULT == null ? this.hexValue != null : !HEX_VALUE_EDEFAULT.equals(this.hexValue);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 3: {
                return this.values != null && !this.values.isEmpty();
            }
            case 4: {
                return this.children != null && !this.children.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setHexValue((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setType((String)newValue);
                return;
            }
            case 3: {
                this.getValues().clear();
                this.getValues().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setHexValue(HEX_VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.getValues().clear();
                return;
            }
            case 4: {
                this.getChildren().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object arg0) {
        ExtendedDataElementImpl extendedDataElementImpl = this;
        synchronized (extendedDataElementImpl) {
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (hexValue: ");
        result.append(this.hexValue);
        result.append(", name: ");
        result.append(this.name);
        result.append(", type: ");
        result.append(this.type);
        result.append(", values: ");
        result.append(this.values);
        result.append(", children: ");
        result.append(this.children);
        result.append(')');
        return result.toString();
    }

    public static boolean isValid(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(String type) {
        return EDE_TYPES_LIST.contains(type);
    }

    public static String typeToString(int type) {
        try {
            return (String)EDE_TYPES_LIST.get(type);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static int typeToInt(String type) {
        return EDE_TYPES_LIST.indexOf(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        ExtendedDataElementImpl extendedDataElementImpl = this;
        synchronized (extendedDataElementImpl) {
            if (this.name == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ExtendedDataElement.Name"));
            }
            if (this.type == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ExtendedDataElement.Type"));
            }
            if (this.values != null && this.hexValue != null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", "CommonBaseEvent.ExtendedDataElement.Values", "CommonBaseEvent.ExtendedDataElement.HexValue"));
            }
            if (this.name.length() > 64) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ExtendedDataElement.Name", this.name, new Integer(this.name.length()), new Integer(64)));
            }
            if (this.type.length() > 64) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ExtendedDataElement.Type", this.type, new Integer(this.type.length()), new Integer(64)));
            }
            if (!ExtendedDataElementImpl.isValid(this.type)) {
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_EXTENDED_DATA_INVALID_TYPE_EXC_", this.name, this.type));
            }
            int typeAsInt = ExtendedDataElementImpl.typeToInt(this.type);
            if (typeAsInt == 19) {
                if (this.hexValue == null) {
                    throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ExtendedDataElement.HexValue"));
                }
                if (this.hexValue.length() % 2 != 0) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_", this.name, this.type, this.hexValue));
                }
                int counter = 0;
                while (counter < this.hexValue.length()) {
                    char character = Character.toUpperCase(this.hexValue.charAt(counter));
                    int index = 0;
                    while (index < HEX_BASE_CHARS.length) {
                        if (character == HEX_BASE_CHARS[index]) break;
                        ++index;
                    }
                    if (index == HEX_BASE_CHARS.length) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_", this.name, this.type, this.hexValue, new Character(character)));
                    }
                    ++counter;
                }
            } else if (typeAsInt == 0) {
                if (this.values != null && this.values.size() > 0 || this.hexValue != null) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INCONSISTENT_ATTRIBUTES_EXC_", "CommonBaseEvent.ExtendedDataElement.Type", this.type, "CommonBaseEvent.ExtendedDataElement.Values, CommonBaseEvent.ExtendedDataElement.HexValue"));
                }
            } else {
                if (this.values == null || this.values.size() == 0) {
                    throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ExtendedDataElement.Values"));
                }
                if ((typeAsInt == 9 || typeAsInt == 1 || typeAsInt == 8 || typeAsInt == 6 || typeAsInt == 5 || typeAsInt == 3 || typeAsInt == 4 || typeAsInt == 2 || typeAsInt == 7) && this.values.size() > 1) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_", new Integer(this.values.size()), this.name, this.type));
                }
                ListIterator iterator = this.values.listIterator();
                String value = null;
                while (iterator.hasNext()) {
                    value = (String)iterator.next();
                    if (value == null) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_EXTENDED_DATA_VALUE_NULL_EXC_", this.name, this.type));
                    }
                    if (value.length() > 1024) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_", value, "CommonBaseEvent.ExtendedDataElement.Value".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]"), new Integer(1024)));
                    }
                    try {
                        if (typeAsInt == 1 || typeAsInt == 10) {
                            Byte.parseByte(value);
                            continue;
                        }
                        if (typeAsInt == 6 || typeAsInt == 15) {
                            Double.parseDouble(value);
                            continue;
                        }
                        if (typeAsInt == 5 || typeAsInt == 14) {
                            Float.parseFloat(value);
                            continue;
                        }
                        if (typeAsInt == 3 || typeAsInt == 12) {
                            Integer.parseInt(value);
                            continue;
                        }
                        if (typeAsInt == 4 || typeAsInt == 13) {
                            Long.parseLong(value);
                            continue;
                        }
                        if (typeAsInt == 2 || typeAsInt == 11) {
                            Short.parseShort(value);
                            continue;
                        }
                        if (typeAsInt != 9 && typeAsInt != 18 || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equals("1") || value.equals("0")) continue;
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_", this.name, this.type, value));
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_TYPE_CONVERSION_EXC_", value, this.type, this.name));
                    }
                }
            }
            if (this.children != null) {
                ListIterator iterator = this.children.listIterator();
                ExtendedDataElement extendedDataElement = null;
                while (iterator.hasNext()) {
                    extendedDataElement = (ExtendedDataElement)iterator.next();
                    try {
                        extendedDataElement.validate();
                    }
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", "CommmonBaseEvent.ExtendedDataElement.Child".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        ExtendedDataElementImpl extendedDataElementImpl = this;
        synchronized (extendedDataElementImpl) {
            return EcoreUtil.copy((EObject)this);
        }
    }

    public void init() {
        this.setHexValue(HEX_VALUE_EDEFAULT);
        this.setName(NAME_EDEFAULT);
        this.setType(TYPE_EDEFAULT);
        this.clearValues();
        this.clearChildren();
    }

    protected void setValues(String value) {
        this.clearValues();
        EList valuList = this.getValues();
        valuList.add(value);
    }

    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getExtendedDataElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ExtendedDataElementImpl extendedDataElementImpl = this;
        synchronized (extendedDataElementImpl) {
            this.hexValue = (String)in.readObject();
            this.name = (String)in.readObject();
            this.type = (String)in.readObject();
            this.eSet(valuesFeature, in.readObject());
            this.eSet(childrenFeature, in.readObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        ExtendedDataElementImpl extendedDataElementImpl = this;
        synchronized (extendedDataElementImpl) {
            out.writeObject(this.hexValue);
            out.writeObject(this.name);
            out.writeObject(this.type);
            if (this.values != null) {
                out.writeObject(new ArrayList(this.values));
            } else {
                out.writeObject(new ArrayList(0));
            }
            if (this.children != null) {
                out.writeObject(new ArrayList(this.children));
            } else {
                out.writeObject(new ArrayList(0));
            }
        }
    }

    private String byteArrayToHexBinary(byte[] inByteArray) {
        String result = null;
        if (inByteArray != null) {
            StringBuffer hexValueAsString = new StringBuffer(inByteArray.length * 2);
            int i = 0;
            while (i < inByteArray.length) {
                hexValueAsString.append(HEX_BASE_CHARS[(inByteArray[i] & 0xF0) >> 4]);
                hexValueAsString.append(HEX_BASE_CHARS[inByteArray[i] & 0xF]);
                ++i;
            }
            result = hexValueAsString.toString();
        }
        return result;
    }

    private byte[] hexBinaryToByteArray(String inHexData) throws IllegalStateException {
        byte[] result = null;
        if (inHexData != null) {
            int count = inHexData.length();
            if (count % 2 == 1) {
                throw new IllegalArgumentException("inHexData must have an even length");
            }
            result = new byte[count / 2];
            int byteValue = 0;
            int i = 0;
            while (i < count) {
                int resultIndex = i / 2;
                int j = 0;
                while (j < 2) {
                    char c = inHexData.charAt(i + j);
                    switch (Character.toUpperCase(c)) {
                        case '0': {
                            byteValue = 0;
                            break;
                        }
                        case '1': {
                            byteValue = 1;
                            break;
                        }
                        case '2': {
                            byteValue = 2;
                            break;
                        }
                        case '3': {
                            byteValue = 3;
                            break;
                        }
                        case '4': {
                            byteValue = 4;
                            break;
                        }
                        case '5': {
                            byteValue = 5;
                            break;
                        }
                        case '6': {
                            byteValue = 6;
                            break;
                        }
                        case '7': {
                            byteValue = 7;
                            break;
                        }
                        case '8': {
                            byteValue = 8;
                            break;
                        }
                        case '9': {
                            byteValue = 9;
                            break;
                        }
                        case 'A': {
                            byteValue = 10;
                            break;
                        }
                        case 'B': {
                            byteValue = 11;
                            break;
                        }
                        case 'C': {
                            byteValue = 12;
                            break;
                        }
                        case 'D': {
                            byteValue = 13;
                            break;
                        }
                        case 'E': {
                            byteValue = 14;
                            break;
                        }
                        case 'F': {
                            byteValue = 15;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("string is not a valid hexBinary");
                        }
                    }
                    if (j == 0) {
                        result[resultIndex] = (byte)(byteValue << 4);
                    } else {
                        int n = resultIndex;
                        result[n] = (byte)(result[n] + byteValue);
                    }
                    ++j;
                }
                i += 2;
            }
        }
        return result;
    }
}

