/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.execution.local;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Assert;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.execution.local.file.FileManagerFactory;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.file.FileServer;

public class FileManagerExtendedTest {
    private static final int COMMAND_INTERVAL_SLEEP = 1000;
    private static final int CONCURRENT_CLIENT_THREADS = 1;
    private static final int CONCURRENT_CLIENT_WORKER_THREADS = 1;
    private static final boolean ENABLE_EXTENDED_FEATURES_4_1 = true;
    private static final int FILE_COUNT = 25;
    private static final int FILE_SAMPLE_SIZE = 4;
    private static final String HEADER = "File transfer test with a file of size: ";
    private static final String HOST = "127.0.0.1";
    private static final int ITERATIONS = 10;
    private static final int OFFSET = 4096;
    private static final int THREAD_START_DELAY = 1250;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i = 0;
        while (i < 1) {
            new Thread(){

                public void run() {
                    new FileManagerExtendedTest().execute();
                }
            }.start();
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                try {
                    Thread.currentThread().wait(1250L);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ++i;
        }
    }

    private IFileManagerExtended.FileIdentifierList createAbsoluteIdentifiers(IFileManagerExtended.FileIdentifierList sourceIdentifiers) {
        IFileManagerExtended.FileIdentifierList destinationIdentifiers = IFileManagerExtended.FileIdentifierList.create();
        Iterator iterator = sourceIdentifiers.iterator();
        while (iterator.hasNext()) {
            String fileIdentifier = (String)iterator.next();
            int extension = fileIdentifier.lastIndexOf(".");
            destinationIdentifiers.add(String.valueOf(fileIdentifier.substring(0, extension).concat("-destination")) + fileIdentifier.substring(extension));
        }
        return destinationIdentifiers;
    }

    private File createAndPopulateFile(String name, String extension, int size) throws IOException {
        File temp = File.createTempFile(name, extension);
        temp.deleteOnExit();
        RandomAccessFile file = new RandomAccessFile(temp, "rw");
        FileChannel channel = file.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
        byteBuffer.clear();
        String string = HEADER + size;
        byteBuffer.put(string.getBytes("UTF-8"));
        byteBuffer.put(this.getFixedLengthRandomBytes(size - string.length()));
        byteBuffer.flip();
        channel.position(0L);
        channel.write(byteBuffer);
        channel.close();
        file.close();
        return temp;
    }

    private IFileManagerExtended.FileIdentifierList createRelativeIdentifiers(IFileManagerExtended.FileIdentifierList sourceIdentifiers) {
        IFileManagerExtended.FileIdentifierList destinationIdentifiers = IFileManagerExtended.FileIdentifierList.create();
        Iterator iterator = sourceIdentifiers.iterator();
        while (iterator.hasNext()) {
            String fileIdentifier = (String)iterator.next();
            int extension = fileIdentifier.lastIndexOf(".");
            if (extension <= -1) {
                throw new IllegalArgumentException();
            }
            int separator = fileIdentifier.indexOf(File.separatorChar);
            if (separator <= -1) {
                throw new IllegalArgumentException();
            }
            destinationIdentifiers.add(String.valueOf(fileIdentifier.substring(separator + 1, extension).concat("-destination2")) + fileIdentifier.substring(extension));
        }
        return destinationIdentifiers;
    }

    public void execute() {
        boolean alreadyExisting = true;
        ISession session = null;
        NodeImpl node = null;
        if (node == null) {
            alreadyExisting = false;
            node = new NodeImpl(HOST);
            try {
                session = node.connect("10002", null, 10);
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (UnknownDaemonException unknownDaemonException) {
            }
            catch (DaemonConnectException daemonConnectException) {}
        }
        IFileManager fileManager = null;
        if (session == null && !alreadyExisting) {
            FileServer fileServer = new FileServer(0);
            fileServer.run();
            fileServer.getFileServerStatus();
            try {
                fileManager = FileManagerFactory.getInstance().createTimed(new InetSocketAddress("localhost", FileServer.getServerPort()), 10);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {}
        } else {
            fileManager = node.getFileManager();
            if (fileManager == null) {
                try {
                    fileManager = FileManagerFactory.getInstance().createTimed(node.node.getConnection(), 10);
                }
                catch (ServerNotAvailableException serverNotAvailableException) {}
            }
        }
        if (fileManager == null || !(fileManager instanceof IFileManagerExtended)) {
            throw new NullPointerException();
        }
        final IFileManagerExtended manager = (IFileManagerExtended)fileManager;
        try {
            final IFileManagerExtended.FileIdentifierList sourceFileIdentifiers = this.generateSourceTestFiles();
            final IFileManagerExtended.FileIdentifierList destinationFileIdentifiersA = this.createAbsoluteIdentifiers(sourceFileIdentifiers);
            final IFileManagerExtended.FileIdentifierList destinationFileIdentifiersB = this.createRelativeIdentifiers(sourceFileIdentifiers);
            final IFileManagerExtended.FileIdentifierList sourceFileIdentifier = IFileManagerExtended.FileIdentifierList.create(sourceFileIdentifiers.get(0));
            final IFileManagerExtended.FileIdentifierList destinationFileIdentifier = IFileManagerExtended.FileIdentifierList.create("single-file-test-destination.dummy");
            int i = 0;
            while (i < 1) {
                new Thread(){

                    public void run() {
                        try {
                            if (!manager.isServerAvailable()) {
                                throw new ServerNotAvailableException(new Throwable());
                            }
                            Thread.sleep(1000L);
                            manager.putFile(sourceFileIdentifiers, destinationFileIdentifiersA);
                            manager.putFile(sourceFileIdentifiers, destinationFileIdentifiersB);
                            manager.putFile(sourceFileIdentifier, destinationFileIdentifier);
                            Thread.sleep(1000L);
                            boolean[] existent = manager.isDirectoryExistent(destinationFileIdentifiersA.getParentIdentifiers());
                            Assert.assertNotNull((Object)existent);
                            Thread.sleep(1000L);
                            manager.getFile(sourceFileIdentifiers, destinationFileIdentifiersA);
                            manager.getFile(sourceFileIdentifiers, destinationFileIdentifiersB);
                            manager.getFile(sourceFileIdentifier, destinationFileIdentifier);
                            Thread.sleep(1000L);
                            manager.deleteFile(destinationFileIdentifiersA);
                            manager.deleteFile(destinationFileIdentifiersB);
                            manager.deleteFile(destinationFileIdentifier);
                            Thread.sleep(1000L);
                            manager.deleteDirectory(destinationFileIdentifiersA.getParentIdentifiers());
                            Thread.sleep(1000L);
                            Thread.sleep(1000L);
                            existent = manager.isDirectoryExistent(destinationFileIdentifiersA.getParentIdentifiers());
                            Assert.assertNotNull((Object)existent);
                            Thread.sleep(1000L);
                            Assert.assertTrue((boolean)manager.determineServerReach("www.google.com", 80));
                            Assert.assertFalse((boolean)manager.determineServerReach("this.should.not.exist", 80));
                            Assert.assertFalse((boolean)manager.determineServerReach("localhost", 32000));
                            Thread.sleep(1000L);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }.start();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (session != null) {
            session.release();
        }
    }

    private IFileManagerExtended.FileIdentifierList generateSourceTestFiles() throws IOException {
        IFileManagerExtended.FileIdentifierList generatedFiles = IFileManagerExtended.FileIdentifierList.create();
        File[] files = new File[25];
        int i = 0;
        while (i < 25) {
            int size = (int)Math.pow(2.0, i) + 4096;
            int j = 0;
            while (j < 4) {
                files[i] = this.createAndPopulateFile("file_" + j + "-" + String.valueOf(size - 4096) + "+" + String.valueOf(4096) + "__", ".dummy", size);
                generatedFiles.add(files[i]);
                ++j;
            }
            ++i;
        }
        return generatedFiles;
    }

    private byte[] getFixedLengthRandomBytes(int count) {
        Random random = new Random(System.currentTimeMillis());
        byte[] bytes = new byte[count];
        random.nextBytes(bytes);
        return bytes;
    }
}

