/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.config;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Variable;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;

public class AgentControllerEnvironment {
    private Hashtable _variables = new Hashtable();

    public String getVariable(String name) {
        String variable = (String)this._variables.get(name);
        if (variable == null && (variable = PlatformUtility.getEnvironment(name)) == null) {
            variable = "";
        }
        return new String(variable);
    }

    public Hashtable getVariables() {
        return (Hashtable)this._variables.clone();
    }

    public void addVariable(Variable variable) {
        String name = variable.getName();
        String value = variable.getValue();
        String position = variable.getPosition();
        if (!this._variables.containsKey(name)) {
            String sysval = PlatformUtility.getEnvironment(name);
            if (sysval == null || sysval.length() == 0) {
                this._variables.put(name, value);
            } else if (position.equals(Variable.APPEND)) {
                this._variables.put(name, String.valueOf(sysval) + File.pathSeparator + value);
            } else if (position.equals(Variable.PREPEND)) {
                this._variables.put(name, String.valueOf(value) + File.pathSeparator + sysval);
            } else if (position.equals(Variable.REPLACE)) {
                this._variables.put(name, value);
            }
        } else if (position.equals(Variable.APPEND)) {
            String oldValue = (String)this._variables.get(name);
            String newValue = String.valueOf(oldValue) + File.pathSeparator + value;
            this._variables.put(name, newValue);
        } else if (position.equals(Variable.PREPEND)) {
            String oldValue = (String)this._variables.get(name);
            String newValue = String.valueOf(value) + File.pathSeparator + oldValue;
            this._variables.put(name, newValue);
        } else if (position.equals(Variable.REPLACE)) {
            this._variables.put(name, value);
        }
    }
}

