/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Agent;
import org.eclipse.tptp.platform.agentcontroller.internal.config.AgentControllerConfiguration;
import org.eclipse.tptp.platform.agentcontroller.internal.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Application;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Configuration;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Option;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Parameter;
import org.eclipse.tptp.platform.agentcontroller.internal.config.Variable;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;

public abstract class AbstractConfigurationImpl
implements Configuration {
    private AgentControllerConfiguration _config = new AgentControllerConfiguration();

    public void addConfiguration(Agent agent) {
        if (agent.isExtends()) {
            Agent base = this._config.getAgent(agent.getName());
            if (base != null) {
                this.merge(base, agent);
            }
        } else if (this._config.getAgent(agent.getName()) == null) {
            this._config.addAgent(agent);
        }
    }

    public void addConfiguration(AgentControllerEnvironment agentControllerEnvironment) {
        this.merge(this._config.getAgentControllerEnvironment(), agentControllerEnvironment);
    }

    public void addConfiguration(Application application) {
        if (application.isExtends()) {
            Application base = this._config.getApplication(application.getExecutable());
            if (base != null) {
                this.merge(base, application);
            }
        } else if (this._config.getApplication(application.getExecutable()) == null) {
            this._config.addApplication(application);
        }
    }

    public void addConfiguration(Option option) {
        this._config.addOption(option);
    }

    public AgentConfiguration getAgentConfiguration(String name, String type) {
        AgentConfiguration aCfg = null;
        Agent agent = this._config.getAgent(name);
        if (agent != null) {
            aCfg = new AgentConfiguration();
            Enumeration options = agent.getOptions();
            while (options.hasMoreElements()) {
                AgentConfigurationEntry aCfgEntry = new AgentConfigurationEntry();
                Option option = (Option)options.nextElement();
                aCfgEntry.setName(option.getName());
                aCfgEntry.setValue(option.getValue());
                aCfgEntry.setType(option.getType());
                aCfg.addEntry(aCfgEntry);
            }
        }
        return aCfg;
    }

    public int getFileServerPort() {
        return this._config.getFilePort();
    }

    private void merge(Agent toAgent, Agent fromAgent) {
        if (fromAgent.isExtends() && toAgent.getName().equals(fromAgent.getName())) {
            if (toAgent.getType() == null) {
                fromAgent.getType();
            } else if (fromAgent.getType() != null && toAgent.getType().equals(fromAgent.getType())) {
                Enumeration options = fromAgent.getOptions();
                while (options.hasMoreElements()) {
                    Option option = (Option)options.nextElement();
                    toAgent.addOption(option);
                }
            }
        }
    }

    private void merge(AgentControllerEnvironment toEnv, AgentControllerEnvironment fromEnv) {
        Hashtable table = fromEnv.getVariables();
        if (table != null) {
            Enumeration names = table.keys();
            while (names != null && names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = (String)table.get(name);
                toEnv.addVariable(new Variable(name, value, Variable.PREPEND));
            }
        }
    }

    private void merge(Application toApplication, Application fromApplication) {
        if (fromApplication.isExtends() && toApplication.getExecutable().equals(fromApplication.getExecutable())) {
            Hashtable table;
            String prependParameterString = fromApplication.getPrependParameter();
            String appendParameterString = fromApplication.getAppendParameter();
            if (prependParameterString != null) {
                toApplication.addParameter(new Parameter(prependParameterString, Parameter.PREPEND));
            }
            if (appendParameterString != null) {
                toApplication.addParameter(new Parameter(appendParameterString, Parameter.APPEND));
            }
            if ((table = fromApplication.getVariables()) != null) {
                Enumeration names = table.keys();
                while (names != null && names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = (String)table.get(name);
                    toApplication.addVariable(new Variable(name, value, Variable.PREPEND));
                }
            }
        }
    }

    public String resolveExecutableArguments(String alias, String origArg) {
        Application app = this._config.getApplication(alias);
        if (app == null) {
            return new String("");
        }
        return ExecutionPlugin.getInstance().resolveVariable(String.valueOf(app.getPrependParameter()) + " " + origArg + " " + app.getAppendParameter());
    }

    public String[] resolveExecutableEnvironment(String alias, String[] origEnv) {
        String value;
        Application app = this._config.getApplication(alias);
        if (app == null) {
            return new String[0];
        }
        Hashtable baseVars = this._config.getAgentControllerEnvironment().getVariables();
        Hashtable appVars = app.getVariables();
        Enumeration keys = appVars.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value2 = (String)appVars.get(name);
            if (name == null || value2 == null) continue;
            if (baseVars.containsKey(name)) {
                baseVars.put(name, ExecutionPlugin.getInstance().resolveVariable(String.valueOf(value2) + File.pathSeparator + baseVars.get(name)));
                continue;
            }
            baseVars.put(name, ExecutionPlugin.getInstance().resolveVariable(value2));
        }
        if (origEnv.length > 0) {
            int i = 0;
            while (i < origEnv.length) {
                String env = origEnv[i];
                int index = env.indexOf(61);
                if (index > 0 && index < env.length() - 1) {
                    String name = env.substring(0, index);
                    String value3 = env.substring(index + 1);
                    if (baseVars.containsKey(name)) {
                        baseVars.put(name, baseVars.get(name) + File.pathSeparator + value3);
                    } else {
                        baseVars.put(name, value3);
                    }
                }
                ++i;
            }
        }
        if (!baseVars.containsKey(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS)) {
            value = ExecutionPlugin.getInstance().getString(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS);
            baseVars.put(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS, value);
        }
        if (!baseVars.containsKey(ACStrings.PREF_TEMP_PATH_ALIAS)) {
            value = ExecutionPlugin.getInstance().getString(ACStrings.PREF_TEMP_PATH_ALIAS);
            baseVars.put(ACStrings.PREF_TEMP_PATH_ALIAS, value);
        }
        String[] result = new String[baseVars.size()];
        int count = 0;
        Enumeration resultKeys = baseVars.keys();
        while (resultKeys.hasMoreElements()) {
            String resultKey = (String)resultKeys.nextElement();
            String resultValue = ExecutionPlugin.getInstance().resolveVariable((String)baseVars.get(resultKey));
            result[count++] = new String(String.valueOf(resultKey) + "=" + resultValue);
        }
        return result;
    }

    public String resolveExecutableName(String alias) {
        Application app = this._config.getApplication(alias);
        if (app == null) {
            return new String("");
        }
        return ExecutionPlugin.getInstance().resolveVariable(app.getPath());
    }

    public Enumeration resolveOptions(String name, String type) {
        Vector<Option> result = new Vector<Option>();
        Enumeration e = this._config.getOptions();
        while (e.hasMoreElements()) {
            Option option = (Option)e.nextElement();
            if (!name.equals("*") && !name.equals(option.getName()) || !type.equals("*") && !type.equals(option.getType())) continue;
            option.setValue(ExecutionPlugin.getInstance().resolveVariable(option.getValue()));
            result.add(option);
        }
        return result.elements();
    }

    public String resolveExecutableWorkingDir(String alias) {
        Application app = this._config.getApplication(alias);
        if (app == null) {
            return new String("");
        }
        return ExecutionPlugin.getInstance().resolveVariable(app.getLocation());
    }

    public void setFileServerPort(int port) {
        this._config.setFilePort(port);
    }
}

