/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.DirectConnectionListener;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.TPTPMessage;
import org.eclipse.tptp.platform.agentcontroller.internal.exception.QueueFullException;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.QueueImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPMessageImpl;

public class DirectControlConnectionImpl
extends BaseConnectionImpl {
    private int _instance;
    private DirectConnectionListener _listener = null;
    private QueueImpl _outputQueue;
    private Object _queueLock = new Object();
    private boolean _destroyed = false;

    protected DirectControlConnectionImpl(int instance, Queue queue) {
        this._instance = instance;
        this.setQueue(queue);
        this.setName(String.valueOf(this.getConnectionType()) + ":" + this.getConnectionName());
        this._outputQueue = new QueueImpl();
    }

    public void create() {
        this.start();
    }

    public void destroyConnection() {
        this._destroyed = true;
        this._outputQueue.destroy();
        this._instance = 0;
        if (this._listener != null) {
            this._listener.peerClosed();
            this._listener = null;
        }
    }

    public void flush() {
    }

    public String getConnectionName() {
        return String.valueOf(this._instance);
    }

    public String getConnectionType() {
        return "TPTP_DIRECT_CONTROL_CONNECTION";
    }

    public InputStream getInputStream() {
        return null;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectReceived(Object obj) {
        Object object = this._queueLock;
        synchronized (object) {
            try {
                this._outputQueue.putItem(obj);
            }
            catch (QueueFullException e) {
                e.printStackTrace();
            }
            this._queueLock.notifyAll();
        }
    }

    public void run() {
        while (!this._destroyed) {
            Object obj = this._outputQueue.getItem();
            if (obj == null) {
                return;
            }
            WorkerThread t = new WorkerThread(obj);
            t.start();
        }
    }

    public void removeDirectConnectionListener() {
        this._listener = null;
    }

    public void sendToQueue(Object obj) throws IOException {
        TPTPMessageImpl message = new TPTPMessageImpl();
        message.setSource(this.getConnectionId());
        message.setPayload(obj);
        super.sendToQueue(message);
    }

    public void setDirectConnectionListener(DirectConnectionListener listener) {
        this._listener = listener;
    }

    public void setInputStream(InputStream inputStream) {
    }

    public void setOutputStream(OutputStream outputStream) {
    }

    class WorkerThread
    extends Thread {
        private Object _obj;

        public WorkerThread(Object obj) {
            this.setName("Direct Connection Worker");
            this._obj = obj;
        }

        public void run() {
            if (this._obj != null && DirectControlConnectionImpl.this._listener != null) {
                if (this._obj instanceof TPTPMessage) {
                    TPTPMessage message = (TPTPMessage)this._obj;
                    DirectControlConnectionImpl.this._listener.objectReceived(message.getPayload());
                } else {
                    DirectControlConnectionImpl.this._listener.objectReceived(this._obj);
                }
            }
        }
    }
}

