/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.Serializer;
import org.eclipse.tptp.platform.agentcontroller.internal.TPTPMessage;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPMessageImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.NamedPipeInputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.NamedPipeOutputStream;

public class NamedPipeConnectionImpl
extends BaseConnectionImpl {
    public static String TPTP_NAMED_PIPE_NAMESPACE;
    private static boolean _nativeAvailable;
    private String _pipeName;
    private boolean _isReader = false;
    private NamedPipeInputStream _inputStream = null;
    private NamedPipeOutputStream _outputStream = null;
    private Serializer _serializer = null;
    private boolean _destroyed = false;

    static {
        _nativeAvailable = false;
        try {
            System.loadLibrary("tptpCommon");
            System.loadLibrary("tptpNP");
            TPTP_NAMED_PIPE_NAMESPACE = PlatformUtility.getOSName().startsWith("Windows") ? "IBMAC" : "IBMRAC";
            _nativeAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            TPTPLoggerImpl.log(0, "Cannot load native library: tptpNP");
        }
        catch (SecurityException securityException) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: tptpNP");
        }
    }

    public NamedPipeConnectionImpl(String pipeName, Queue queue, boolean isReader) {
        this._pipeName = pipeName;
        this.setQueue(queue);
        this._isReader = isReader;
        this.setName(String.valueOf(this.getConnectionType()) + ":" + this.getConnectionName());
    }

    public void create() {
        if (this._isReader) {
            this._inputStream = new NamedPipeInputStream(TPTP_NAMED_PIPE_NAMESPACE, this._pipeName);
        } else {
            boolean openFailed = false;
            this._outputStream = new NamedPipeOutputStream(TPTP_NAMED_PIPE_NAMESPACE, this._pipeName);
            try {
                this._outputStream.open();
                TPTPLoggerImpl.log(this, 3, "Named pipe successfully opened for writing: " + this._pipeName);
            }
            catch (IOException e) {
                TPTPLoggerImpl.log(this, 1, e.getMessage());
                openFailed = true;
            }
            if (openFailed) {
                TPTPLoggerImpl.log(this, 1, "Trying to recover by reopen the named pipe: " + this._pipeName);
                try {
                    Thread.sleep(1000L);
                    this._outputStream.open();
                    TPTPLoggerImpl.log(this, 3, "Named pipe successfully reopened for writing: " + this._pipeName);
                }
                catch (Exception e) {
                    TPTPLoggerImpl.log(this, 0, e.getMessage());
                    TPTPLoggerImpl.log(this, 0, "Unrecoverable error when reopening the named pipe: " + this._pipeName);
                }
            }
        }
    }

    public void destroyConnection() {
        this._destroyed = true;
        try {
            if (this._isReader) {
                if (this._inputStream != null) {
                    this._inputStream.close();
                    this._inputStream = null;
                }
                TPTPLoggerImpl.log(this, 3, "Named pipe reader connection destroyed");
            } else {
                if (this._outputStream != null) {
                    this._outputStream.flush();
                    this._outputStream.close();
                    this._outputStream = null;
                }
                TPTPLoggerImpl.log(this, 3, "Named pipe writer connection destroyed");
            }
        }
        catch (IOException iOException) {}
    }

    public String getConnectionName() {
        return this._pipeName;
    }

    public String getConnectionType() {
        return "TPTP_NAMED_PIPE_CONTROL_CONNECTION";
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public static boolean isPipeAvailable(String pipeName) {
        if (_nativeAvailable) {
            return NamedPipeConnectionImpl.isPipeAvailable0(TPTP_NAMED_PIPE_NAMESPACE, pipeName);
        }
        return false;
    }

    public void objectReceived(Object object) throws IOException {
        if (!this._isReader && object != null && object instanceof TPTPMessage) {
            TPTPMessage message = (TPTPMessage)object;
            this._serializer.putObject(this._outputStream, message.getPayload());
        }
    }

    public void run() {
        if (this._isReader && this._serializer != null) {
            Object obj = null;
            do {
                if ((obj = this._serializer.getObject(this._inputStream)) != null) {
                    TPTPMessageImpl message = new TPTPMessageImpl();
                    message.setSource(this.getConnectionId());
                    message.setPayload(obj);
                    try {
                        this.sendToQueue(message);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    NamedPipeConnectionImpl.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            } while (!this._destroyed && obj != null);
        }
    }

    public void setInputStream(InputStream inputStream) {
        if (inputStream instanceof NamedPipeInputStream) {
            this._inputStream = (NamedPipeInputStream)inputStream;
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream instanceof NamedPipeOutputStream) {
            this._outputStream = (NamedPipeOutputStream)outputStream;
        }
    }

    public void setSerializer(Serializer serializer) {
        this._serializer = serializer;
    }

    private static native boolean isPipeAvailable0(String var0, String var1);
}

