/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class PlatformUtility {
    private static boolean _isNativeAvailable = false;
    private static Hashtable _processes = new Hashtable();

    static {
        try {
            System.loadLibrary("tptpCommon");
            _isNativeAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            TPTPLoggerImpl.log(0, "Cannot load native library: tptpCommon");
        }
        catch (SecurityException securityException) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: tptpCommon");
        }
    }

    public static boolean isNativeAvailable() {
        return _isNativeAvailable;
    }

    public static boolean isProcessAlive(long pid) {
        if (_isNativeAvailable) {
            if (PlatformUtility.isProcessAlive0(pid)) {
                return true;
            }
        } else {
            TPTPLoggerImpl.log(0, "Cannot check process status due to missing native library");
        }
        return false;
    }

    public static long launchProcess(String cmd, String[] env, String dir) {
        Process proc = null;
        long pid = 0L;
        if (_isNativeAvailable) {
            TPTPLoggerImpl.log(3, "Trying to launch process (" + cmd + ") in directory (" + dir + ")");
            try {
                long[] preChilds = PlatformUtility.getChildProcesses0();
                proc = Runtime.getRuntime().exec(cmd, env, new File(dir));
                try {
                    pid = PlatformUtility.getProcessID0(proc);
                }
                catch (Exception exception) {
                    TPTPLoggerImpl.log(0, "Problem querying the process ID from the native layer. Pleaes check the JDK specific implementation of the Process class");
                }
                if (pid == 0L) {
                    long[] postChilds = PlatformUtility.getChildProcesses0();
                    pid = PlatformUtility.diff(preChilds, postChilds);
                }
                if (pid > 0L) {
                    TPTPLoggerImpl.log(2, "Process launched: pid = " + pid);
                    _processes.put(new Long(pid), proc);
                }
            }
            catch (Exception exception) {
                TPTPLoggerImpl.log(0, "Error launch process: " + cmd);
            }
        } else {
            TPTPLoggerImpl.log(0, "Cannot launch process due to missing native library");
        }
        return pid;
    }

    public static void killProcess(long pid) {
        Process p = (Process)_processes.get(new Long(pid));
        if (p != null) {
            p.destroy();
            _processes.remove(new Long(pid));
        }
    }

    public static String[] getEnvironment() {
        if (_isNativeAvailable) {
            return PlatformUtility.getEnvironment0();
        }
        return new String[0];
    }

    public static String getEnvironment(String name) {
        String value = null;
        String[] values = PlatformUtility.getEnvironment();
        int nameLen = name.length() + 1;
        int i = 0;
        while (i < values.length) {
            if (values[i].startsWith(String.valueOf(name) + "=")) {
                value = values[i].substring(nameLen);
                break;
            }
            ++i;
        }
        return value;
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static Process getProcess(long pid) {
        if (_processes.containsKey(new Long(pid))) {
            return (Process)_processes.get(new Long(pid));
        }
        return null;
    }

    public static String[] mergeEnvironment(String[] oldSet, String[] newSet) {
        String[] resultSet = null;
        Hashtable<String, String> tempSet = new Hashtable<String, String>();
        if (oldSet != null && newSet != null) {
            int separator;
            int i = 0;
            while (i < oldSet.length) {
                separator = oldSet[i].indexOf(61);
                if (separator > 0) {
                    String oldName = oldSet[i].substring(0, separator);
                    String oldValue = separator < oldSet[i].length() - 1 ? oldSet[i].substring(separator + 1) : "";
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        tempSet.put(oldName.toUpperCase(), oldValue);
                    } else {
                        tempSet.put(oldName, oldValue);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < newSet.length) {
                separator = newSet[i].indexOf(61);
                if (separator > 0) {
                    String update;
                    String newName = newSet[i].substring(0, separator);
                    String newValue = separator < newSet[i].length() - 1 ? newSet[i].substring(separator + 1) : "";
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        if (tempSet.get(newName.toUpperCase()) == null) {
                            tempSet.put(newName.toUpperCase(), newValue);
                        } else {
                            update = String.valueOf(newValue) + File.pathSeparator + tempSet.get(newName.toUpperCase());
                            tempSet.remove(newName.toUpperCase());
                            tempSet.put(newName.toUpperCase(), update);
                        }
                    } else if (tempSet.get(newName) == null) {
                        tempSet.put(newName, newValue);
                    } else {
                        update = String.valueOf(newValue) + File.pathSeparator + tempSet.get(newName);
                        tempSet.remove(newName);
                        tempSet.put(newName, update);
                    }
                }
                ++i;
            }
            resultSet = new String[tempSet.size()];
            i = 0;
            Enumeration e = tempSet.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)tempSet.get(name);
                resultSet[i] = String.valueOf(name) + "=" + value;
                ++i;
            }
        }
        return resultSet;
    }

    private static long diff(long[] pre, long[] post) {
        boolean matched = false;
        int i = 0;
        while (i < post.length) {
            int j = 0;
            while (j < pre.length) {
                if (post[i] == pre[j]) {
                    matched = true;
                }
                ++j;
            }
            if (!matched) {
                return post[i];
            }
            ++i;
        }
        return 0L;
    }

    private static native boolean isProcessAlive0(long var0);

    private static native long[] getChildProcesses0();

    private static native long getProcessID0(Process var0);

    private static native String[] getEnvironment0();
}

