/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.SharedMemoryCircularBufferInputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.stream.SharedMemoryOutputStream;

public class SharedMemoryConnectionImpl
extends BaseConnectionImpl {
    private String _shmName;
    private boolean _isReader = false;
    private InputStream _inputStream = null;
    private OutputStream _outputStream = null;

    public SharedMemoryConnectionImpl(String shmName, Queue queue, boolean isReader) {
        this._shmName = shmName;
        this.setQueue(queue);
        this._isReader = isReader;
        this.setName(String.valueOf(this.getConnectionType()) + ":" + this.getConnectionName());
    }

    public void create() {
        if (this._isReader) {
            this._inputStream = new SharedMemoryCircularBufferInputStream(this._shmName);
        } else {
            this._outputStream = new SharedMemoryOutputStream(this._shmName);
        }
    }

    public void destroyConnection() {
        try {
            if (this._isReader) {
                if (this._inputStream != null) {
                    this._inputStream.close();
                }
            } else if (this._outputStream != null) {
                this._outputStream.flush();
                this._outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public String getConnectionName() {
        return this._shmName;
    }

    public String getConnectionType() {
        return "TPTP_SHARED_MEMORY_DATA_CONNECTION";
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public void objectReceived(Object object) throws IOException {
    }

    public void run() {
    }

    public void setInputStream(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._outputStream = outputStream;
    }
}

