/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseServerConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConnectionFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.HyadesSerializer;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.SocketControlConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class SocketServerConnectionImpl
extends BaseServerConnectionImpl {
    private int _port;
    private ServerSocket _serverSocket = null;
    private boolean _destroyed = false;

    public SocketServerConnectionImpl() {
        this(10002);
    }

    public SocketServerConnectionImpl(int port) {
        this._port = port;
        this.setName("TPTP_SERVER_SOCKET_CONNECTION:" + port);
        try {
            this._serverSocket = new ServerSocket(port);
            TPTPLoggerImpl.log(this, 2, "Server socket created successfully on port: " + this._port);
        }
        catch (IOException iOException) {
            TPTPLoggerImpl.log(this, 0, "Cannot create server socket on port: " + this._port);
        }
    }

    public void destroyConnection() {
        this._destroyed = true;
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
                TPTPLoggerImpl.log(this, 2, "Server socket destroyed successfully on port: " + this._port);
            }
            catch (IOException iOException) {
                TPTPLoggerImpl.log(this, 0, "Cannot close server socket on port: " + this._port);
            }
        }
    }

    public void run() {
        while (!this._destroyed && this._serverSocket != null) {
            Socket socket = null;
            try {
                socket = this._serverSocket.accept();
                TPTPLoggerImpl.log(this, 0, "Connection accepted from host: " + socket.getInetAddress().getHostName() + ":" + socket.getPort());
            }
            catch (IOException iOException) {
                TPTPLoggerImpl.log(this, 0, "Error accepting socket on port: " + this._port);
                return;
            }
            if (socket == null) continue;
            SocketControlConnectionImpl controlSocket = ConnectionFactoryImpl.createSocketControlConnection(socket);
            controlSocket.setSerializer(new HyadesSerializer());
            controlSocket.start();
        }
    }

    public String getConnectionName() {
        return String.valueOf(this._port);
    }

    public String getConnectionType() {
        return "TPTP_SERVER_SOCKET_CONNECTION";
    }
}

