/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.preference;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;
import org.osgi.framework.Bundle;

public class AgentControllerPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IEclipsePreferences node = new DefaultScope().getNode(ExecutionPlugin.PLUGIN_ID);
        node.putBoolean(ACStrings.PREF_AUTO_START, false);
        node.putBoolean(ACStrings.PREF_ENABLED, PlatformUtility.isNativeAvailable());
        node.putBoolean(ACStrings.PREF_KEEP_ALIVE, false);
        node.putBoolean(ACStrings.PREF_LOGGING_ENABLED, false);
        node.putInt(ACStrings.PREF_LOGGING_LEVEL, 0);
        node.putBoolean(ACStrings.PREF_SOCKET_ENABLED, false);
        node.putInt(ACStrings.PREF_SOCKET_PORT, 10002);
        node.put(ACStrings.PREF_JAVA_PATH_ALIAS, this.getDefaultJavaPath());
        node.put(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS, System.getProperty("java.io.tmpdir"));
        node.put(ACStrings.PREF_TEMP_PATH_ALIAS, System.getProperty("java.io.tmpdir"));
        node.put(ACStrings.PREF_LOGGING_DIRECTORY, this.getDefaultLoggingDirectory());
        node.putInt(ACStrings.PREF_SHARED_MEMORY_SIZE, 16);
    }

    private String getDefaultJavaPath() {
        File javaExe;
        String javaHome = System.getProperty("java.home");
        String ext = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        if (javaHome.endsWith(File.separator)) {
            javaHome = javaHome.substring(0, javaHome.length() - 1);
        }
        if ((javaExe = new File(String.valueOf(javaHome) + File.separator + "jre" + File.separator + "bin" + File.separator + "java" + ext)).exists() && javaExe.isFile()) {
            return javaExe.getAbsolutePath();
        }
        javaExe = new File(String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java" + ext);
        if (javaExe.exists() && javaExe.isFile()) {
            return javaExe.getAbsolutePath();
        }
        return new String("");
    }

    private String getDefaultLoggingDirectory() {
        String logDir = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.hyades.execution")).toFile().getAbsolutePath();
        if (logDir != null) {
            if (logDir.endsWith(File.separator)) {
                logDir = logDir.substring(0, logDir.length() - 1);
            }
            return logDir;
        }
        return System.getProperty("java.io.tmpdir");
    }
}

