/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.PlatformUtility;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AgentControllerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean _transientAutoStart;
    private boolean _transientEnabled;
    private boolean _transientSocketEnabled;
    private boolean _transientLoggingEnabled;
    private int _transientLoggingLevel;
    private int _transientPort;
    private String _transientJavaPath;
    private String _transientAgentTempPath;
    private String _transientTempPath;
    private String _transientLoggingDirectory;
    private int _transientShmSize;
    private Button _bAutoStart;
    private Button _bEnabled;
    private Button _bSocketEnabled;
    private Button _bLoggingEnabled;
    private Combo _cbLoggingLevel;
    private Text _tPort;
    private Text _tJavaPath;
    private Text _tAgentTempPath;
    private Text _tTempPath;
    private Text _tLoggingDirectory;
    private Text _tShmSize;
    private DefaultSelectionListener _defaultSelectionListener = new DefaultSelectionListener();
    private JavaPathEntryListener _javaPathEntryListener = new JavaPathEntryListener();
    private LoggingEntryListener _loggingEntryListener = new LoggingEntryListener();
    private PortEntryListener _portEntryListener = new PortEntryListener();
    private TempPathEntryListener _tempPathEntryListener = new TempPathEntryListener();
    private AgentTempPathEntryListener _agentTempPathEntryListener = new AgentTempPathEntryListener();
    private LoggingDirectoryListener _loggingDirectoryListener = new LoggingDirectoryListener();
    private SharedMemoryEntryListener _shmEntryListener = new SharedMemoryEntryListener();

    private void createAgentTempPathEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(ACStrings.PREF_AGENT_TEMP_PATH) + " (" + ACStrings.PREF_AGENT_TEMP_PATH_ALIAS + ")");
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        this._tAgentTempPath = new Text(composite2, 2052);
        RowData data = new RowData();
        data.width = 300;
        this._tAgentTempPath.setLayoutData((Object)data);
        this._tAgentTempPath.setEditable(false);
        Button browse = new Button(composite2, 8);
        browse.setText(ACStrings.PREF_BROWSE);
        browse.addMouseListener((MouseListener)this._agentTempPathEntryListener);
    }

    private void createAutoStartEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout());
        this._bAutoStart = new Button(composite, 32);
        this._bAutoStart.setText(ACStrings.PREF_AUTO_START);
        this._bAutoStart.addSelectionListener((SelectionListener)this._defaultSelectionListener);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.createFill());
        composite.setLayout((Layout)new GridLayout());
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)this.createFill());
        folder.setLayout((Layout)new GridLayout());
        TabItem behaviour = new TabItem(folder, 0);
        behaviour.setText(ACStrings.PREF_BEHAVIOUR);
        behaviour.setControl(this.createSettingTab((Composite)folder));
        TabItem environment = new TabItem(folder, 0);
        environment.setText(ACStrings.PREF_ENVIRONMENT);
        environment.setControl(this.createEnvironmentTab((Composite)folder));
        this.refreshValuesFromPreference();
        return composite;
    }

    private void createEnabledEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout());
        this._bEnabled = new Button(composite, 32);
        this._bEnabled.setText(ACStrings.PREF_ENABLED);
        this._bEnabled.addSelectionListener((SelectionListener)this._defaultSelectionListener);
        this._bEnabled.setEnabled(PlatformUtility.isNativeAvailable() && !ExecutionPlugin.getInstance().isErrorOccurred());
    }

    private Control createEnvironmentTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.createFill());
        composite.setLayout((Layout)new GridLayout());
        this.createJavaPathEntry(composite);
        this.createTempPathEntry(composite);
        this.createAgentTempPathEntry(composite);
        this.createLoggingDirectoryEntry(composite);
        return composite;
    }

    private GridData createFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    private void createJavaPathEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(ACStrings.PREF_JAVA_PATH) + " (" + ACStrings.PREF_JAVA_PATH_ALIAS + ")");
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        this._tJavaPath = new Text(composite2, 2052);
        RowData data = new RowData();
        data.width = 300;
        this._tJavaPath.setLayoutData((Object)data);
        this._tJavaPath.setEditable(false);
        Button browse = new Button(composite2, 8);
        browse.setText(ACStrings.PREF_BROWSE);
        browse.addMouseListener((MouseListener)this._javaPathEntryListener);
    }

    private void createLoggingEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this._bLoggingEnabled = new Button(composite, 32);
        this._bLoggingEnabled.setText(ACStrings.PREF_LOGGING_ENABLED);
        this._bLoggingEnabled.addSelectionListener((SelectionListener)this._loggingEntryListener);
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        Label label = new Label(composite2, 0);
        label.setText(ACStrings.PREF_LOGGING_LEVEL);
        this._cbLoggingLevel = new Combo(composite2, 12);
        this._cbLoggingLevel.addSelectionListener((SelectionListener)this._loggingEntryListener);
        this._cbLoggingLevel.add(ACStrings.PREF_LOGGING_LEVEL_SEVERE, 0);
        this._cbLoggingLevel.add(ACStrings.PREF_LOGGING_LEVEL_WARNING, 1);
        this._cbLoggingLevel.add(ACStrings.PREF_LOGGING_LEVEL_INFO, 2);
        this._cbLoggingLevel.add(ACStrings.PREF_LOGGING_LEVEL_DEBUG, 3);
        this._cbLoggingLevel.select(0);
    }

    private void createLoggingDirectoryEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(ACStrings.PREF_LOGGING_DIRECTORY);
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        this._tLoggingDirectory = new Text(composite2, 2052);
        RowData data = new RowData();
        data.width = 300;
        this._tLoggingDirectory.setLayoutData((Object)data);
        this._tLoggingDirectory.setEditable(false);
        Button browse = new Button(composite2, 8);
        browse.setText(ACStrings.PREF_BROWSE);
        browse.addMouseListener((MouseListener)this._loggingDirectoryListener);
    }

    private void createPortEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this._bSocketEnabled = new Button(composite, 32);
        this._bSocketEnabled.setText(ACStrings.PREF_SOCKET_ENABLED);
        this._bSocketEnabled.addSelectionListener((SelectionListener)this._portEntryListener);
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        Label label = new Label(composite2, 0);
        label.setText(ACStrings.PREF_SOCKET_PORT);
        this._tPort = new Text(composite2, 2052);
        RowData data = new RowData();
        data.width = 50;
        this._tPort.setLayoutData((Object)data);
        this._tPort.setTextLimit(5);
        this._tPort.addVerifyListener((VerifyListener)this._portEntryListener);
        this._tPort.addModifyListener((ModifyListener)this._portEntryListener);
    }

    private Control createSettingTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.createFill());
        composite.setLayout((Layout)new GridLayout());
        this.createEnabledEntry(composite);
        this.createAutoStartEntry(composite);
        this.createLoggingEntry(composite);
        this.createPortEntry(composite);
        this.createSharedMemoryEntry(composite);
        return composite;
    }

    private void createSharedMemoryEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        Label label = new Label(composite2, 0);
        label.setText(String.valueOf(ACStrings.PREF_SHARED_MEMORY_SIZE) + " (MB)");
        this._tShmSize = new Text(composite2, 2052);
        RowData data = new RowData();
        data.width = 50;
        this._tShmSize.setLayoutData((Object)data);
        this._tShmSize.setTextLimit(5);
        this._tShmSize.addVerifyListener((VerifyListener)this._shmEntryListener);
        this._tShmSize.addModifyListener((ModifyListener)this._shmEntryListener);
    }

    private void createTempPathEntry(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(ACStrings.PREF_TEMP_PATH) + " (" + ACStrings.PREF_TEMP_PATH_ALIAS + ")");
        Composite composite2 = new Composite(composite, 0);
        GridData gd = new GridData();
        composite2.setLayoutData((Object)gd);
        composite2.setLayout((Layout)new RowLayout());
        this._tTempPath = new Text(composite2, 2052);
        RowData data = new RowData();
        data.width = 300;
        this._tTempPath.setLayoutData((Object)data);
        this._tTempPath.setEditable(false);
        Button browse = new Button(composite2, 8);
        browse.setText(ACStrings.PREF_BROWSE);
        browse.addMouseListener((MouseListener)this._tempPathEntryListener);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        ExecutionPlugin.getInstance().setBoolean(ACStrings.PREF_AUTO_START, this._transientAutoStart);
        ExecutionPlugin.getInstance().setBoolean(ACStrings.PREF_ENABLED, this._transientEnabled);
        ExecutionPlugin.getInstance().setBoolean(ACStrings.PREF_LOGGING_ENABLED, this._transientLoggingEnabled);
        ExecutionPlugin.getInstance().setInt(ACStrings.PREF_LOGGING_LEVEL, this._transientLoggingLevel);
        ExecutionPlugin.getInstance().setBoolean(ACStrings.PREF_SOCKET_ENABLED, this._transientSocketEnabled);
        ExecutionPlugin.getInstance().setInt(ACStrings.PREF_SOCKET_PORT, this._transientPort);
        ExecutionPlugin.getInstance().setString(ACStrings.PREF_JAVA_PATH_ALIAS, this._transientJavaPath);
        ExecutionPlugin.getInstance().setString(ACStrings.PREF_TEMP_PATH_ALIAS, this._transientTempPath);
        ExecutionPlugin.getInstance().setString(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS, this._transientAgentTempPath);
        ExecutionPlugin.getInstance().setString(ACStrings.PREF_LOGGING_DIRECTORY, this._transientLoggingDirectory);
        ExecutionPlugin.getInstance().setInt(ACStrings.PREF_SHARED_MEMORY_SIZE, this._transientShmSize);
    }

    public boolean performCancel() {
        return true;
    }

    protected void performDefaults() {
        this.restoreValuesFromPreferenceDefault();
        this.updateApplyButton();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    private void restoreValuesFromPreferenceDefault() {
        this._transientAutoStart = ExecutionPlugin.getInstance().getDefaultBoolean(ACStrings.PREF_AUTO_START);
        this._transientEnabled = ExecutionPlugin.getInstance().getDefaultBoolean(ACStrings.PREF_ENABLED);
        this._transientLoggingEnabled = ExecutionPlugin.getInstance().getDefaultBoolean(ACStrings.PREF_LOGGING_ENABLED);
        this._transientLoggingLevel = ExecutionPlugin.getInstance().getDefaultInt(ACStrings.PREF_LOGGING_LEVEL);
        this._transientSocketEnabled = ExecutionPlugin.getInstance().getDefaultBoolean(ACStrings.PREF_SOCKET_ENABLED);
        this._transientPort = ExecutionPlugin.getInstance().getDefaultInt(ACStrings.PREF_SOCKET_PORT);
        this._transientJavaPath = ExecutionPlugin.getInstance().getDefaultString(ACStrings.PREF_JAVA_PATH_ALIAS);
        this._transientTempPath = ExecutionPlugin.getInstance().getDefaultString(ACStrings.PREF_TEMP_PATH_ALIAS);
        this._transientAgentTempPath = ExecutionPlugin.getInstance().getDefaultString(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS);
        this._transientLoggingDirectory = ExecutionPlugin.getInstance().getDefaultString(ACStrings.PREF_LOGGING_DIRECTORY);
        this._transientShmSize = ExecutionPlugin.getInstance().getDefaultInt(ACStrings.PREF_SHARED_MEMORY_SIZE);
        this._bAutoStart.setSelection(this._transientAutoStart);
        this._bEnabled.setSelection(this._transientEnabled);
        this._bLoggingEnabled.setSelection(this._transientLoggingEnabled);
        this._cbLoggingLevel.select(this._transientLoggingLevel);
        this._bSocketEnabled.setSelection(this._transientSocketEnabled);
        this._tPort.setText(String.valueOf(this._transientPort));
        this._tJavaPath.setText(this._transientJavaPath);
        this._tTempPath.setText(this._transientTempPath);
        this._tAgentTempPath.setText(this._transientAgentTempPath);
        this._tLoggingDirectory.setText(this._transientLoggingDirectory);
        this._tShmSize.setText(String.valueOf(this._transientShmSize));
        this.updateButtonStates();
    }

    private void refreshValuesFromPreference() {
        this._transientAutoStart = ExecutionPlugin.getInstance().getBoolean(ACStrings.PREF_AUTO_START);
        this._transientEnabled = ExecutionPlugin.getInstance().getBoolean(ACStrings.PREF_ENABLED);
        this._transientLoggingEnabled = ExecutionPlugin.getInstance().getBoolean(ACStrings.PREF_LOGGING_ENABLED);
        this._transientLoggingLevel = ExecutionPlugin.getInstance().getInt(ACStrings.PREF_LOGGING_LEVEL);
        this._transientSocketEnabled = ExecutionPlugin.getInstance().getBoolean(ACStrings.PREF_SOCKET_ENABLED);
        this._transientPort = ExecutionPlugin.getInstance().getInt(ACStrings.PREF_SOCKET_PORT);
        this._transientJavaPath = ExecutionPlugin.getInstance().getString(ACStrings.PREF_JAVA_PATH_ALIAS);
        this._transientTempPath = ExecutionPlugin.getInstance().getString(ACStrings.PREF_TEMP_PATH_ALIAS);
        this._transientAgentTempPath = ExecutionPlugin.getInstance().getString(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS);
        this._transientLoggingDirectory = ExecutionPlugin.getInstance().getString(ACStrings.PREF_LOGGING_DIRECTORY);
        this._transientShmSize = ExecutionPlugin.getInstance().getInt(ACStrings.PREF_SHARED_MEMORY_SIZE);
        this._bAutoStart.setSelection(this._transientAutoStart);
        this._bEnabled.setSelection(this._transientEnabled);
        this._bLoggingEnabled.setSelection(this._transientLoggingEnabled);
        this._cbLoggingLevel.select(this._transientLoggingLevel);
        this._bSocketEnabled.setSelection(this._transientSocketEnabled);
        this._tPort.setText(String.valueOf(this._transientPort));
        this._tJavaPath.setText(this._transientJavaPath);
        this._tTempPath.setText(this._transientTempPath);
        this._tAgentTempPath.setText(this._transientAgentTempPath);
        this._tLoggingDirectory.setText(this._transientLoggingDirectory);
        this._tShmSize.setText(String.valueOf(this._transientShmSize));
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this._bAutoStart.setEnabled(this._transientEnabled);
        this._bLoggingEnabled.setEnabled(this._transientEnabled);
        this._cbLoggingLevel.setEnabled(this._transientEnabled && this._bLoggingEnabled.getSelection());
        this._bSocketEnabled.setEnabled(this._transientEnabled);
        this._tPort.setEnabled(this._transientEnabled && this._bSocketEnabled.getSelection());
        this._tShmSize.setEnabled(this._transientEnabled);
    }

    class AgentTempPathEntryListener
    implements MouseListener {
        AgentTempPathEntryListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                DirectoryDialog dirDialog = new DirectoryDialog(b.getShell());
                dirDialog.setFilterPath(ExecutionPlugin.getInstance().getString(ACStrings.PREF_AGENT_TEMP_PATH_ALIAS));
                AgentControllerPreferencePage.this._transientAgentTempPath = dirDialog.open();
                AgentControllerPreferencePage.this._tAgentTempPath.setText(AgentControllerPreferencePage.this._transientAgentTempPath);
            }
        }
    }

    class DefaultSelectionListener
    implements SelectionListener {
        DefaultSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                String selectedButton = b.getText();
                if (selectedButton.equals(ACStrings.PREF_AUTO_START)) {
                    AgentControllerPreferencePage.this._transientAutoStart = b.getSelection();
                } else if (selectedButton.equals(ACStrings.PREF_ENABLED)) {
                    AgentControllerPreferencePage.this._transientEnabled = b.getSelection();
                    AgentControllerPreferencePage.this.updateButtonStates();
                } else {
                    selectedButton.equals(ACStrings.PREF_KEEP_ALIVE);
                }
            }
        }
    }

    class JavaPathEntryListener
    implements MouseListener {
        JavaPathEntryListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                FileDialog fileDialog = new FileDialog(b.getShell());
                fileDialog.setFileName(ExecutionPlugin.getInstance().getString(ACStrings.PREF_JAVA_PATH_ALIAS));
                AgentControllerPreferencePage.this._transientJavaPath = fileDialog.open();
                AgentControllerPreferencePage.this._tJavaPath.setText(AgentControllerPreferencePage.this._transientJavaPath);
            }
        }
    }

    class LoggingDirectoryListener
    implements MouseListener {
        LoggingDirectoryListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                DirectoryDialog dirDialog = new DirectoryDialog(b.getShell());
                dirDialog.setFilterPath(ExecutionPlugin.getInstance().getString(ACStrings.PREF_LOGGING_DIRECTORY));
                AgentControllerPreferencePage.this._transientLoggingDirectory = dirDialog.open();
                AgentControllerPreferencePage.this._tLoggingDirectory.setText(AgentControllerPreferencePage.this._transientLoggingDirectory);
            }
        }
    }

    class LoggingEntryListener
    implements SelectionListener {
        LoggingEntryListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                String selectedButton = b.getText();
                if (selectedButton.equals(ACStrings.PREF_LOGGING_ENABLED)) {
                    AgentControllerPreferencePage.this._transientLoggingEnabled = b.getSelection();
                    AgentControllerPreferencePage.this._cbLoggingLevel.setEnabled(AgentControllerPreferencePage.this._transientLoggingEnabled);
                }
            } else if (e.getSource() instanceof Combo) {
                Combo cb = (Combo)e.getSource();
                AgentControllerPreferencePage.this._transientLoggingLevel = cb.getSelectionIndex();
            }
        }
    }

    class PortEntryListener
    implements ModifyListener,
    SelectionListener,
    VerifyListener {
        PortEntryListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text t;
            String selectedText;
            if (e.getSource() instanceof Text && (selectedText = (t = (Text)e.getSource()).getText()) != null && selectedText.length() > 0) {
                try {
                    AgentControllerPreferencePage.this._transientPort = Integer.parseInt(selectedText);
                    if (AgentControllerPreferencePage.this._transientPort > 65535) {
                        AgentControllerPreferencePage.this._transientPort = 65535;
                        t.setText(String.valueOf(AgentControllerPreferencePage.this._transientPort));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Button b;
            String selectedButton;
            if (e.getSource() instanceof Button && (selectedButton = (b = (Button)e.getSource()).getText()).equals(ACStrings.PREF_SOCKET_ENABLED)) {
                AgentControllerPreferencePage.this._transientSocketEnabled = b.getSelection();
                AgentControllerPreferencePage.this._tPort.setEnabled(AgentControllerPreferencePage.this._transientSocketEnabled);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void verifyText(VerifyEvent e) {
            e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
        }
    }

    class SharedMemoryEntryListener
    implements ModifyListener,
    VerifyListener {
        SharedMemoryEntryListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text t;
            String selectedText;
            if (e.getSource() instanceof Text && (selectedText = (t = (Text)e.getSource()).getText()) != null && selectedText.length() > 0) {
                try {
                    AgentControllerPreferencePage.this._transientShmSize = Integer.parseInt(selectedText);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }

        public void verifyText(VerifyEvent e) {
            e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
        }
    }

    class TempPathEntryListener
    implements MouseListener {
        TempPathEntryListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (e.getSource() instanceof Button) {
                Button b = (Button)e.getSource();
                DirectoryDialog dirDialog = new DirectoryDialog(b.getShell());
                dirDialog.setFilterPath(ExecutionPlugin.getInstance().getString(ACStrings.PREF_TEMP_PATH_ALIAS));
                AgentControllerPreferencePage.this._transientTempPath = dirDialog.open();
                AgentControllerPreferencePage.this._tTempPath.setText(AgentControllerPreferencePage.this._transientTempPath);
            }
        }
    }
}

