/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.proxy;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.AgentProxyListener;
import org.eclipse.tptp.platform.agentcontroller.internal.proxy.ProcessProxy;

public class AgentProxy {
    private String _name;
    private String _type;
    private String _uuid;
    private ProcessProxy _process = null;
    private boolean _isActive = true;
    private boolean _isAttached = false;
    private boolean _isMonitoring = false;
    private String _attachedClient = null;
    private String _attachedControlConnection = null;
    private String _attachedDataConnection = null;
    private Vector _listeners = new Vector();

    public AgentProxy(String name) {
        this(name, null, null);
    }

    public AgentProxy(String name, String type, String uuid) {
        this._name = name;
        this._type = type;
        this._uuid = uuid;
    }

    public ProcessProxy getProcess() {
        return this._process;
    }

    public void addAgentListener(AgentProxyListener listener) {
        this._listeners.add(listener);
    }

    public void setProcess(ProcessProxy p) {
        this._process = p;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getUuid() {
        return this._uuid;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
        Enumeration listeners = this._listeners.elements();
        while (listeners.hasMoreElements()) {
            if (isActive) {
                ((AgentProxyListener)listeners.nextElement()).agentActive(this._process.getPid(), this._name);
                continue;
            }
            ((AgentProxyListener)listeners.nextElement()).agentInactive(this._process.getPid(), this._name);
        }
    }

    public boolean isAttached() {
        return this._isAttached;
    }

    public void setAttached(boolean isAttached) {
        this._isAttached = isAttached;
        Enumeration listeners = this._listeners.elements();
        while (listeners.hasMoreElements()) {
            if (isAttached) {
                ((AgentProxyListener)listeners.nextElement()).agentAttached(this._process.getPid(), this._name);
                continue;
            }
            ((AgentProxyListener)listeners.nextElement()).agentDetached(this._process.getPid(), this._name);
        }
    }

    public boolean isMonitoring() {
        return this._isMonitoring;
    }

    public void setMonitoring(boolean isMonitoring) {
        this._isMonitoring = isMonitoring;
        Enumeration listeners = this._listeners.elements();
        while (listeners.hasMoreElements()) {
            if (isMonitoring) {
                ((AgentProxyListener)listeners.nextElement()).agentStartMonitored(this._process.getPid(), this._name);
                continue;
            }
            ((AgentProxyListener)listeners.nextElement()).agentStopMonitored(this._process.getPid(), this._name);
        }
    }

    public String getAttachedClient() {
        return this._attachedClient;
    }

    public String getAttachedControlConnection() {
        if (this._attachedControlConnection == null) {
            this._attachedControlConnection = new String("TPTP_NAMED_PIPE_CONTROL_CONNECTION:" + this._uuid);
        }
        return this._attachedControlConnection;
    }

    public String getAttachedDataConnection() {
        return this._attachedDataConnection;
    }

    public void setAttachedClient(String attacheClient) {
        this._attachedClient = attacheClient;
    }

    public void setAttacheControlConnection(String attacheControlConnection) {
        this._attachedControlConnection = attacheControlConnection;
    }

    public void setAttachedDataConnection(String attacheDataConnection) {
        this._attachedDataConnection = attacheDataConnection;
    }
}

