/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class NamedPipeOutputStream
extends OutputStream {
    private static boolean _nativeAvailable = false;
    private String _pipeNameSpace;
    private String _pipeName;
    private int _handle = -1;

    static {
        try {
            System.loadLibrary("tptpCommon");
            System.loadLibrary("tptpNP");
            _nativeAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            TPTPLoggerImpl.log(0, "Cannot load native library: tptpNP");
        }
        catch (SecurityException securityException) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: tptpNP");
        }
    }

    public NamedPipeOutputStream(String pipeNameSpace, String pipeName) {
        this._pipeNameSpace = pipeNameSpace;
        this._pipeName = pipeName;
    }

    public void close() throws IOException {
        if (!_nativeAvailable) {
            throw new IOException();
        }
        this.close0(this._handle);
        this._handle = -1;
    }

    public void flush() throws IOException {
    }

    public void open() throws IOException {
        if (_nativeAvailable) {
            this._handle = this.open0(this._pipeNameSpace, this._pipeName);
            if (this._handle == -1) {
                throw new IOException("Invalid file handle returned when opening named pipe: " + this._pipeName);
            }
        } else {
            throw new IOException("Error occurred when opening named pipe: " + this._pipeName);
        }
    }

    public void write(byte[] b) throws IOException {
        if (!_nativeAvailable || this._handle == -1) {
            throw new IOException();
        }
        int byteWritten = this.write0(this._handle, b);
        TPTPLoggerImpl.log(3, "Byte written to named pipe = " + byteWritten);
    }

    public void write(int arg0) throws IOException {
        byte[] b = new byte[]{(byte)arg0};
        this.write(b);
    }

    private native int open0(String var1, String var2);

    private native void close0(int var1);

    private native int write0(int var1, byte[] var2);
}

