/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.test;

import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.TPTPMessage;
import org.eclipse.tptp.platform.agentcontroller.internal.exception.QueueFullException;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.QueueImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPMessageImpl;

public class TestQueue {
    private Queue _queue;
    private boolean _done = false;
    private String[] _data = new String[4000];

    public static void main(String[] args) {
        TestQueue test = new TestQueue();
        test.init();
        test.test01();
    }

    private void init() {
        int i = 0;
        while (i < 4000) {
            this._data[i] = new String("String " + i);
            ++i;
        }
    }

    private boolean verify(Object obj) {
        int i = 0;
        while (i < 4000) {
            if (this._data[i] != null && this._data[i].equals(obj) && obj instanceof TPTPMessage) {
                this._data[i] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    private void test01() {
        this._queue = new QueueImpl();
        ReadThread rt1 = new ReadThread();
        WriteThreadA wt1 = new WriteThreadA();
        WriteThreadB wt2 = new WriteThreadB();
        wt2.start();
        wt1.start();
        rt1.start();
        try {
            wt2.join();
            wt1.join();
            this._done = true;
            rt1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < 4000) {
            if (this._data[i] != null) {
                System.out.println("Missing object: " + this._data[i]);
            }
            ++i;
        }
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        public void run() {
            int count = 0;
            boolean empty = false;
            this.setName("Read Thread 01");
            while (!TestQueue.this._done || !empty) {
                Object obj = TestQueue.this._queue.getItem();
                if (!TestQueue.this.verify(obj)) {
                    System.err.println("Object does not match: " + ((TPTPMessage)obj).getPayload());
                }
                ++count;
                empty = false;
            }
            System.out.println("Total A+B received = " + count);
            System.out.flush();
        }
    }

    private class WriteThreadA
    extends Thread {
        private WriteThreadA() {
        }

        public void run() {
            int count = 0;
            this.setName("Write Thread A");
            int i = 0;
            while (i < 2000) {
                boolean success = false;
                while (!success) {
                    try {
                        TestQueue.this._queue.putItem(new TPTPMessageImpl(null, null, TestQueue.this._data[i]));
                        ++count;
                        success = true;
                    }
                    catch (QueueFullException queueFullException) {
                        WriteThreadA.yield();
                    }
                }
                ++i;
            }
            System.out.println("Total A sent = " + count);
            System.out.flush();
        }
    }

    private class WriteThreadB
    extends Thread {
        private WriteThreadB() {
        }

        public void run() {
            int count = 0;
            this.setName("Write Thread B");
            int i = 2000;
            while (i < 4000) {
                boolean success = false;
                while (!success) {
                    try {
                        TestQueue.this._queue.putItem(new TPTPMessageImpl(null, null, TestQueue.this._data[i]));
                        ++count;
                        success = true;
                    }
                    catch (QueueFullException queueFullException) {
                        WriteThreadB.yield();
                    }
                }
                ++i;
            }
            System.out.println("Total B sent = " + count);
            System.out.flush();
        }
    }
}

