/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.persistence.EnhancedEnumeration;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.persistence.RemoteEnumerator;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import javax.ejb.EJBObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FinderEnumerator
implements EnhancedEnumeration,
Serializable {
    static final int PREFETCH_COUNT = 25;
    private RemoteEnumerator enum = null;
    private EJBObject[] elements = null;
    private int index = 0;
    private boolean exhausted = false;
    private static final long serialVersionUID = 4603100038030697154L;

    FinderEnumerator(EJBObject[] eJBObjectArray) {
        this.elements = eJBObjectArray;
        this.exhausted = true;
    }

    FinderEnumerator(EJBObject[] eJBObjectArray, boolean bl, RemoteEnumerator remoteEnumerator) {
        this.elements = eJBObjectArray;
        this.exhausted = bl;
        this.enum = remoteEnumerator;
    }

    public Object nextElement() {
        try {
            return this.nextElementR();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            throw new NoSuchElementException();
        }
        catch (EnumeratorException enumeratorException) {
            throw new RuntimeException(enumeratorException.toString());
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.toString());
        }
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMoreElementsR();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            return false;
        }
        catch (EnumeratorException enumeratorException) {
            throw new RuntimeException(enumeratorException.toString());
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.toString());
        }
    }

    public synchronized boolean hasMoreElementsR() throws RemoteException, EnumeratorException {
        if (this.elements != null && this.index < this.elements.length) {
            return true;
        }
        if (!this.exhausted) {
            try {
                this.elements = null;
                this.index = 0;
                this.elements = this.fetchElements(25);
                return true;
            }
            catch (NoMoreElementsException noMoreElementsException) {
                return false;
            }
        }
        return false;
    }

    public synchronized Object nextElementR() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        return this.elements[this.index++];
    }

    public synchronized Object[] nextNElements(int n) throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] eJBObjectArray = null;
        int n2 = this.elements.length - this.index;
        if (!this.exhausted && n2 < n) {
            try {
                eJBObjectArray = this.fetchElements(n - n2);
            }
            catch (NoMoreElementsException noMoreElementsException) {
                // empty catch block
            }
        }
        int n3 = eJBObjectArray != null ? eJBObjectArray.length : 0;
        int n4 = n2 + n3;
        int n5 = Math.min(n, n4);
        Object[] objectArray = new EJBObject[n5];
        int n6 = Math.min(n5, n2);
        System.arraycopy(this.elements, this.index, objectArray, 0, n6);
        this.index += n6;
        if (eJBObjectArray != null) {
            System.arraycopy(eJBObjectArray, 0, objectArray, n6, n3);
        }
        return objectArray;
    }

    public int size() {
        this.loadEntireCollection();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length;
    }

    public EJBObject[] loadEntireCollection() {
        EJBObject[] eJBObjectArray = null;
        try {
            eJBObjectArray = (EJBObject[])this.allRemainingElements();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            return this.elements;
        }
        catch (EnumeratorException enumeratorException) {
            throw new RuntimeException(enumeratorException.toString());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.toString());
        }
        this.elements = eJBObjectArray;
        return eJBObjectArray;
    }

    public synchronized Object[] allRemainingElements() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] eJBObjectArray = null;
        if (!this.exhausted) {
            try {
                eJBObjectArray = this.enum.allRemainingElements();
            }
            catch (NoMoreElementsException noMoreElementsException) {
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new CollectionCannotBeFurtherAccessedException();
            }
            finally {
                this.exhausted = true;
                this.enum = null;
            }
        }
        int n = this.elements.length - this.index;
        int n2 = eJBObjectArray != null ? eJBObjectArray.length : 0;
        Object[] objectArray = new EJBObject[n + n2];
        System.arraycopy(this.elements, this.index, objectArray, 0, n);
        if (eJBObjectArray != null) {
            System.arraycopy(eJBObjectArray, 0, objectArray, n, n2);
        }
        this.elements = null;
        return objectArray;
    }

    private final EJBObject[] fetchElements(int n) throws RemoteException, EnumeratorException {
        EJBObject[] eJBObjectArray = null;
        try {
            if (this.enum != null) {
                eJBObjectArray = this.enum.nextNElements(n);
            }
            EJBObject[] eJBObjectArray2 = eJBObjectArray;
            return eJBObjectArray2;
        }
        catch (NoMoreElementsException noMoreElementsException) {
            throw noMoreElementsException;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new CollectionCannotBeFurtherAccessedException();
        }
        finally {
            if (eJBObjectArray == null || eJBObjectArray.length < n) {
                this.exhausted = true;
                this.enum = null;
            }
        }
    }
}

