/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.LegacyHandleDelegateImpl;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.rmi.PortableRemoteObject;

public class HomeHandleImpl
implements HomeHandle,
Serializable {
    private static final long serialVersionUID = 3592459660841320056L;
    static final byte[] EYECATCHER = Constants.HOME_HANDLE_EYE_CATCHER;
    static final short PLATFORM = 1;
    private transient EJBHome ivEjbHome;
    private transient short ivActualVersion;
    private transient String ivJndiName = null;
    private transient String ivHomeInterface = null;
    private transient Properties ivInitialContextProperties = null;

    public HomeHandleImpl(EJBHome eJBHome) {
        this.ivEjbHome = eJBHome;
        this.ivActualVersion = (short)2;
    }

    public EJBHome getEJBHome() throws RemoteException {
        if (this.ivEjbHome == null) {
            try {
                Object object;
                Class<?> clazz = null;
                try {
                    object = Thread.currentThread().getContextClassLoader();
                    if (object == null) {
                        throw new ClassNotFoundException();
                    }
                    clazz = ((ClassLoader)object).loadClass(this.ivHomeInterface);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName(this.ivHomeInterface);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new ClassNotFoundException(this.ivHomeInterface);
                    }
                }
                object = null;
                try {
                    if (this.ivInitialContextProperties == null) {
                        object = new InitialContext();
                    } else {
                        try {
                            object = new InitialContext(this.ivInitialContextProperties);
                        }
                        catch (NamingException namingException) {
                            object = new InitialContext();
                        }
                    }
                    this.ivEjbHome = (EJBHome)PortableRemoteObject.narrow((Object)((InitialContext)object).lookup(this.ivJndiName), clazz);
                }
                catch (NoInitialContextException noInitialContextException) {
                    Properties properties = new Properties();
                    properties.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                    object = new InitialContext(properties);
                    this.ivEjbHome = (EJBHome)PortableRemoteObject.narrow((Object)((InitialContext)object).lookup(this.ivJndiName), clazz);
                }
            }
            catch (NamingException namingException) {
                NoSuchObjectException noSuchObjectException = new NoSuchObjectException("Could not find home in JNDI");
                noSuchObjectException.detail = namingException;
                throw noSuchObjectException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RemoteException("Could not load home interface", classNotFoundException);
            }
        }
        return this.ivEjbHome;
    }

    private HandleDelegate lookupHandleDelegate() {
        HandleDelegate handleDelegate = null;
        try {
            InitialContext initialContext = new InitialContext();
            handleDelegate = (HandleDelegate)initialContext.lookup("java:comp/HandleDelegate");
        }
        catch (NamingException namingException) {
            handleDelegate = LegacyHandleDelegateImpl.getInstance();
        }
        return handleDelegate;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(EYECATCHER);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(this.ivActualVersion);
        this.lookupHandleDelegate().writeEJBHome(this.ivEjbHome, objectOutputStream);
        if (this.ivActualVersion == 1) {
            objectOutputStream.writeObject(this.ivInitialContextProperties);
            objectOutputStream.writeUTF(this.ivHomeInterface);
            objectOutputStream.writeUTF(this.ivJndiName);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block6: {
            int n;
            objectInputStream.defaultReadObject();
            byte[] byArray = new byte[4];
            int n2 = 0;
            for (n = 0; n < 4; n += n2) {
                n2 = objectInputStream.read(byArray, n, 4 - n);
                if (n2 != -1) continue;
                throw new IOException("end of input stream while reading eye catcher");
            }
            for (n = 0; n < EYECATCHER.length; ++n) {
                if (byArray[n] == EYECATCHER[n]) continue;
                String string = new String(byArray);
                throw new IOException("Invalid eye catcher '" + string + "' in handle input stream");
            }
            n = objectInputStream.readShort();
            this.ivActualVersion = objectInputStream.readShort();
            if (this.ivActualVersion != 1 && this.ivActualVersion != 2) {
                throw new InvalidObjectException("Home Handle data stream is not of the correct version, this client should be updated.");
            }
            try {
                this.ivEjbHome = this.lookupHandleDelegate().readEJBHome(objectInputStream);
            }
            catch (IOException iOException) {
                if (this.ivActualVersion == 1) break block6;
                throw iOException;
            }
        }
        if (this.ivActualVersion == 1) {
            this.ivInitialContextProperties = (Properties)objectInputStream.readObject();
            this.ivHomeInterface = objectInputStream.readUTF();
            this.ivJndiName = objectInputStream.readUTF();
            this.ivEjbHome = null;
        }
    }
}

