/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class DBA_Encoder
extends IBMCharsetEncoder {
    private final int convertType;
    private final boolean maplow;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private boolean islegal = true;
    private final char[] cm;

    DBA_Encoder(Charset charset, byte by, byte by2, byte[] byArray, char[] cArray) {
        super(charset, 1.5f, 2.0f);
        this.convertType = by;
        boolean bl = this.maplow = by2 == 1;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
        this.islegal = false;
        this.cm = cArray;
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (this.islegal) {
            return true;
        }
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if (this.maplow && c <= '\u007f') {
            return true;
        }
        char c2 = this.cm[c];
        return c2 != '\u0000' || c == '\u0000';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            if (this.maplow && c <= '\u007f') {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c;
                continue;
            }
            char c2 = this.cm[c];
            if (c2 < '\u0100') {
                if (c2 == '\u0000' && c != '\u0000') {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (n4 - n3 < 2) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            byArray[n3++] = (byte)(c2 >> 8);
            byArray[n3++] = (byte)c2;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (this.maplow && c <= '\u007f') {
                    byteBuffer.put((byte)c);
                } else {
                    char c2 = this.cm[c];
                    if (c2 < '\u0100') {
                        if (c2 == '\u0000' && c != '\u0000' || this.convertType == 2) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c2);
                    } else {
                        if (this.convertType == 1) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(c2 >> 8));
                        byteBuffer.put((byte)c2);
                    }
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType == 0 && charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

