/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.security.action.GetPropertyAction;

public class CharToByteUnicode
extends CharToByteConverter {
    static final char BYTE_ORDER_MARK = '\ufeff';
    protected boolean usesMark = true;
    private boolean markWritten = false;
    static final int UNKNOWN = 0;
    static final int BIG = 1;
    static final int LITTLE = 2;
    protected int byteOrder = 0;

    public CharToByteUnicode() {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.io.unicode.encoding", "UnicodeBig"));
        this.byteOrder = string.equals("UnicodeBig") ? 1 : (string.equals("UnicodeLittle") ? 2 : 1);
    }

    public CharToByteUnicode(int n, boolean bl) {
        this.byteOrder = n;
        this.usesMark = bl;
    }

    public CharToByteUnicode(boolean bl) {
        this();
        this.usesMark = bl;
    }

    public String getCharacterEncoding() {
        switch (this.byteOrder) {
            case 1: {
                return this.usesMark ? "UnicodeBig" : "UnicodeBigUnmarked";
            }
            case 2: {
                return this.usesMark ? "UnicodeLittle" : "UnicodeLittleUnmarked";
            }
        }
        return "UnicodeUnknown";
    }

    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws ConversionBufferFullException, MalformedInputException {
        int n5;
        boolean bl;
        this.charOff = n;
        this.byteOff = n3;
        if (n >= n2) {
            return 0;
        }
        int n6 = n;
        int n7 = n3;
        int n8 = n4 - 2;
        if (this.usesMark && !this.markWritten) {
            if (n7 > n8) {
                throw new ConversionBufferFullException();
            }
            if (this.byteOrder == 1) {
                byArray[n7++] = -2;
                byArray[n7++] = -1;
            } else {
                byArray[n7++] = -1;
                byArray[n7++] = -2;
            }
            this.markWritten = true;
        }
        if (n2 - n6 > n4 - n7) {
            bl = true;
            n5 = n4 - n7;
        } else {
            bl = false;
            n5 = n2 - n6;
        }
        if (this.byteOrder == 1) {
            while (n6 < n2) {
                if (n7 > n8) {
                    this.charOff = n6;
                    this.byteOff = n7;
                    throw new ConversionBufferFullException();
                }
                char c = cArray[n6++];
                byArray[n7++] = (byte)(c >> 8);
                byArray[n7++] = (byte)(c & 0xFF);
            }
        } else {
            while (n6 < n2) {
                if (n7 > n8) {
                    this.charOff = n6;
                    this.byteOff = n7;
                    throw new ConversionBufferFullException();
                }
                char c = cArray[n6++];
                byArray[n7++] = (byte)(c & 0xFF);
                byArray[n7++] = (byte)(c >> 8);
            }
        }
        this.charOff = n6;
        this.byteOff = n7;
        if (bl) {
            throw new ConversionBufferFullException();
        }
        return n7 - n3;
    }

    public int flush(byte[] byArray, int n, int n2) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.markWritten = false;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }

    public boolean canConvert(char c) {
        return true;
    }
}

