/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.javah;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.javah.JavahAdapter;
import org.apache.tools.ant.taskdefs.optional.javah.Kaffeh;
import org.apache.tools.ant.taskdefs.optional.javah.SunJavah;
import org.apache.tools.ant.util.JavaEnvUtils;

public class JavahAdapterFactory {
    public static String getDefault() {
        if (JavaEnvUtils.isKaffe()) {
            return "kaffeh";
        }
        return "sun";
    }

    public static JavahAdapter getAdapter(String choice, ProjectComponent log) throws BuildException {
        if (JavaEnvUtils.isKaffe() && choice == null || "kaffeh".equals(choice)) {
            return new Kaffeh();
        }
        if ("sun".equals(choice)) {
            return new SunJavah();
        }
        if (choice != null) {
            return JavahAdapterFactory.resolveClassName(choice);
        }
        return new SunJavah();
    }

    private static JavahAdapter resolveClassName(String className) throws BuildException {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            return (JavahAdapter)o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException("Can't load " + className, cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " is not a Javah adapter", cce);
        }
        catch (Throwable t) {
            throw new BuildException(className + " caused an interesting " + "exception.", t);
        }
    }
}

