/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jdepend;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import jdepend.xmlui.JDepend;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.LoaderUtils;

public class JDependTask
extends Task {
    private Path sourcesPath;
    private Path classesPath;
    private File outputFile;
    private File dir;
    private Path compileClasspath;
    private boolean haltonerror = false;
    private boolean fork = false;
    private Long timeout = null;
    private String jvm = null;
    private String format = "text";
    private PatternSet defaultPatterns = new PatternSet();
    private static Constructor packageFilterC;
    private static Method setFilter;
    private boolean includeRuntime = false;
    private Path runtimeClasses = null;
    private static final int SUCCESS = 0;
    private static final int ERRORS = 1;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$jdepend$textui$JDepend;

    public void setIncluderuntime(boolean b) {
        this.includeRuntime = b;
    }

    public void setTimeout(Long value) {
        this.timeout = value;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setHaltonerror(boolean haltonerror) {
        this.haltonerror = haltonerror;
    }

    public boolean getHaltonerror() {
        return this.haltonerror;
    }

    public void setFork(boolean value) {
        this.fork = value;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setJvm(String value) {
        this.jvm = value;
    }

    public Path createSourcespath() {
        if (this.sourcesPath == null) {
            this.sourcesPath = new Path(this.getProject());
        }
        return this.sourcesPath.createPath();
    }

    public Path getSourcespath() {
        return this.sourcesPath;
    }

    public Path createClassespath() {
        if (this.classesPath == null) {
            this.classesPath = new Path(this.getProject());
        }
        return this.classesPath.createPath();
    }

    public Path getClassespath() {
        return this.classesPath;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public Commandline.Argument createJvmarg(CommandlineJava commandline) {
        return commandline.createVmArgument();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public PatternSet.NameEntry createExclude() {
        return this.defaultPatterns.createExclude();
    }

    public PatternSet getExcludes() {
        return this.defaultPatterns;
    }

    public void setFormat(FormatAttribute ea) {
        this.format = ea.getValue();
    }

    private void addClasspathEntry(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/jdepend/" + resource;
        File f = LoaderUtils.getResourceSource(this.getClass().getClassLoader(), resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.runtimeClasses.createPath().setLocation(f);
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    public void execute() throws BuildException {
        boolean errorOccurred;
        CommandlineJava commandline = new CommandlineJava();
        if ("text".equals(this.format)) {
            commandline.setClassname("jdepend.textui.JDepend");
        } else if ("xml".equals(this.format)) {
            commandline.setClassname("jdepend.xmlui.JDepend");
        }
        if (this.jvm != null) {
            commandline.setVm(this.jvm);
        }
        if (this.getSourcespath() == null && this.getClassespath() == null) {
            throw new BuildException("Missing classespath required argument");
        }
        if (this.getClassespath() == null) {
            String msg = "sourcespath is deprecated in JDepend >= 2.5 - please convert to classespath";
            this.log(msg);
        }
        int exitValue = 1;
        boolean wasKilled = false;
        if (!this.getFork()) {
            exitValue = this.executeInVM(commandline);
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(commandline, watchdog);
            if (watchdog != null) {
                wasKilled = watchdog.killedProcess();
            }
        }
        boolean bl = errorOccurred = exitValue == 1 || wasKilled;
        if (errorOccurred) {
            String errorMessage = "JDepend FAILED" + (wasKilled ? " - Timed out" : "");
            if (this.getHaltonerror()) {
                throw new BuildException(errorMessage, this.getLocation());
            }
            this.log(errorMessage, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeInVM(CommandlineJava commandline) throws BuildException {
        void var2_4;
        if ("xml".equals(this.format)) {
            JDepend jDepend = new JDepend();
        } else {
            jdepend.textui.JDepend jDepend = new jdepend.textui.JDepend();
        }
        FileWriter fw = null;
        if (this.getOutputFile() != null) {
            try {
                fw = new FileWriter(this.getOutputFile().getPath());
            }
            catch (IOException e) {
                String msg = "JDepend Failed when creating the output file: " + e.getMessage();
                this.log(msg);
                throw new BuildException(msg);
            }
            var2_4.setWriter(new PrintWriter(fw));
            this.log("Output to be stored in " + this.getOutputFile().getPath());
        }
        try {
            File f;
            int i;
            if (this.getClassespath() != null) {
                String[] classesPath = this.getClassespath().list();
                i = 0;
                while (i < classesPath.length) {
                    f = new File(classesPath[i]);
                    if (!f.exists() || !f.isDirectory()) {
                        String msg = "\"" + f.getPath() + "\" does not represent a valid" + " directory. JDepend would fail.";
                        this.log(msg);
                        throw new BuildException(msg);
                    }
                    try {
                        var2_4.addDirectory(f.getPath());
                    }
                    catch (IOException e) {
                        String msg = "JDepend Failed when adding a class directory: " + e.getMessage();
                        this.log(msg);
                        throw new BuildException(msg);
                    }
                    ++i;
                }
            } else if (this.getSourcespath() != null) {
                String[] sourcesPath = this.getSourcespath().list();
                i = 0;
                while (i < sourcesPath.length) {
                    f = new File(sourcesPath[i]);
                    if (!f.exists() || !f.isDirectory()) {
                        String msg = "\"" + f.getPath() + "\" does not represent a valid" + " directory. JDepend would fail.";
                        this.log(msg);
                        throw new BuildException(msg);
                    }
                    try {
                        var2_4.addDirectory(f.getPath());
                    }
                    catch (IOException e) {
                        String msg = "JDepend Failed when adding a source directory: " + e.getMessage();
                        this.log(msg);
                        throw new BuildException(msg);
                    }
                    ++i;
                }
            }
            String[] patterns = this.defaultPatterns.getExcludePatterns(this.getProject());
            if (patterns != null && patterns.length > 0) {
                if (setFilter != null) {
                    Vector<String> v = new Vector<String>();
                    int i2 = 0;
                    while (i2 < patterns.length) {
                        v.addElement(patterns[i2]);
                        ++i2;
                    }
                    try {
                        Object o = packageFilterC.newInstance(v);
                        setFilter.invoke((Object)var2_4, o);
                    }
                    catch (Throwable e) {
                        this.log("excludes will be ignored as JDepend doesn't like me: " + e.getMessage(), 1);
                    }
                } else {
                    this.log("Sorry, your version of JDepend doesn't support excludes", 1);
                }
            }
            var2_4.analyze();
            Object var10_21 = null;
            if (fw == null) return 0;
        }
        catch (Throwable throwable) {
            Object var10_22 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fw.close();
            return 0;
        }
        catch (Throwable t) {}
        return 0;
    }

    public int executeAsForked(CommandlineJava commandline, ExecuteWatchdog watchdog) throws BuildException {
        File f;
        this.runtimeClasses = new Path(this.getProject());
        this.addClasspathEntry("/jdepend/textui/JDepend.class");
        this.createClasspath();
        if (this.getClasspath().toString().length() > 0) {
            this.createJvmarg(commandline).setValue("-classpath");
            this.createJvmarg(commandline).setValue(this.getClasspath().toString());
        }
        if (this.includeRuntime) {
            Vector v = Execute.getProcEnvironment();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!s.startsWith("CLASSPATH=")) continue;
                commandline.createClasspath(this.getProject()).createPath().append(new Path(this.getProject(), s.substring("CLASSPATH=".length())));
            }
            this.log("Implicitly adding " + this.runtimeClasses + " to CLASSPATH", 3);
            commandline.createClasspath(this.getProject()).createPath().append(this.runtimeClasses);
        }
        if (this.getOutputFile() != null) {
            commandline.createArgument().setValue("-file");
            commandline.createArgument().setValue(this.outputFile.getPath());
        }
        if (this.getSourcespath() != null) {
            String[] sourcesPath = this.getSourcespath().list();
            int i = 0;
            while (i < sourcesPath.length) {
                f = new File(sourcesPath[i]);
                if (!f.exists() || !f.isDirectory()) {
                    throw new BuildException("\"" + f.getPath() + "\" does not represent a valid" + " directory. JDepend would" + " fail.");
                }
                commandline.createArgument().setValue(f.getPath());
                ++i;
            }
        }
        if (this.getClassespath() != null) {
            String[] classesPath = this.getClassespath().list();
            int i = 0;
            while (i < classesPath.length) {
                f = new File(classesPath[i]);
                if (!f.exists() || !f.isDirectory()) {
                    throw new BuildException("\"" + f.getPath() + "\" does not represent a valid" + " directory. JDepend would" + " fail.");
                }
                commandline.createArgument().setValue(f.getPath());
                ++i;
            }
        }
        Execute execute = new Execute(new LogStreamHandler(this, 2, 1), watchdog);
        execute.setCommandline(commandline.getCommandline());
        if (this.getDir() != null) {
            execute.setWorkingDirectory(this.getDir());
            execute.setAntRun(this.getProject());
        }
        if (this.getOutputFile() != null) {
            this.log("Output to be stored in " + this.getOutputFile().getPath());
        }
        this.log(commandline.describeCommand(), 3);
        try {
            return execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", e, this.getLocation());
        }
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.getTimeout() == null) {
            return null;
        }
        return new ExecuteWatchdog(this.getTimeout());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            try {
                Class<?> packageFilter = Class.forName("jdepend.framework.PackageFilter");
                packageFilterC = packageFilter.getConstructor(class$java$util$Collection == null ? (class$java$util$Collection = JDependTask.class$("java.util.Collection")) : class$java$util$Collection);
                setFilter = (class$jdepend$textui$JDepend == null ? (class$jdepend$textui$JDepend = JDependTask.class$("jdepend.textui.JDepend")) : class$jdepend$textui$JDepend).getDeclaredMethod("setFilter", packageFilter);
            }
            catch (Throwable t) {
                if (setFilter != null) break block2;
                packageFilterC = null;
            }
        }
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private String[] formats = new String[]{"xml", "text"};

        public String[] getValues() {
            return this.formats;
        }
    }
}

