/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.P4HandlerAdapter;
import org.apache.tools.ant.util.StringUtils;

public class P4Label
extends P4Base {
    protected String name;
    protected String desc;
    protected String lock;

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    public void execute() throws BuildException {
        this.log("P4Label exec:", 2);
        if (this.P4View == null || this.P4View.length() < 1) {
            this.log("View not set, assuming //depot/...", 1);
            this.P4View = "//depot/...";
        } else {
            this.P4View = StringUtils.replace(this.P4View, ":", "\n\t");
            this.P4View = StringUtils.replace(this.P4View, ";", "\n\t");
        }
        if (this.desc == null || this.desc.length() < 1) {
            this.log("Label Description not set, assuming 'AntLabel'", 1);
            this.desc = "AntLabel";
        }
        if (this.lock != null && !this.lock.equalsIgnoreCase("locked")) {
            this.log("lock attribute invalid - ignoring", 1);
        }
        if (this.name == null || this.name.length() < 1) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd-hh:mm");
            Date now = new Date();
            this.name = "AntLabel-" + formatter.format(now);
            this.log("name not set, assuming '" + this.name + "'", 1);
        }
        String newLabel = "Label: " + this.name + "\nDescription: " + this.desc + "\nOptions: unlocked" + "\nView: \n\t" + this.P4View;
        P4HandlerAdapter handler = new P4HandlerAdapter(){

            public void process(String line) {
                P4Label.this.log(line, 3);
            }
        };
        handler.setOutput(newLabel);
        this.execP4Command("label -i", handler);
        this.execP4Command("labelsync -l " + this.name, new P4HandlerAdapter(){

            public void process(String line) {
                P4Label.this.log(line, 3);
            }
        });
        this.log("Created Label " + this.name + " (" + this.desc + ") with view:\n" + this.P4View, 2);
        if (this.lock != null && this.lock.equalsIgnoreCase("locked")) {
            this.log("Modifying lock status to 'locked'", 2);
            final StringBuffer labelSpec = new StringBuffer();
            handler = new P4HandlerAdapter(){

                public void process(String line) {
                    P4Label.this.log(line, 3);
                    if (P4Label.this.util.match("/^Options:/", line)) {
                        line = "Options: " + P4Label.this.lock;
                    }
                    labelSpec.append(line + "\n");
                }
            };
            this.execP4Command("label -o " + this.name, handler);
            this.log(labelSpec.toString(), 4);
            this.log("Now locking label...", 3);
            handler = new P4HandlerAdapter(){

                public void process(String line) {
                    P4Label.this.log(line, 3);
                }
            };
            handler.setOutput(labelSpec.toString());
            this.execP4Command("label -i", handler);
        }
    }
}

