/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sound;

import java.io.File;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.sound.AntSoundPlayer;

public class SoundTask
extends Task {
    private BuildAlert success = null;
    private BuildAlert fail = null;

    public BuildAlert createSuccess() {
        this.success = new BuildAlert();
        return this.success;
    }

    public BuildAlert createFail() {
        this.fail = new BuildAlert();
        return this.fail;
    }

    public void init() {
    }

    public void execute() {
        AntSoundPlayer soundPlayer = new AntSoundPlayer();
        if (this.success == null) {
            this.log("No nested success element found.", 1);
        } else {
            soundPlayer.addBuildSuccessfulSound(this.success.getSource(), this.success.getLoops(), this.success.getDuration());
        }
        if (this.fail == null) {
            this.log("No nested failure element found.", 1);
        } else {
            soundPlayer.addBuildFailedSound(this.fail.getSource(), this.fail.getLoops(), this.fail.getDuration());
        }
        this.getProject().addBuildListener(soundPlayer);
    }

    public class BuildAlert {
        private File source = null;
        private int loops = 0;
        private Long duration = null;

        public void setDuration(Long duration) {
            this.duration = duration;
        }

        public void setSource(File source) {
            this.source = source;
        }

        public void setLoops(int loops) {
            this.loops = loops;
        }

        public File getSource() {
            Object nofile = null;
            if (this.source.exists()) {
                if (this.source.isDirectory()) {
                    String[] entries = this.source.list();
                    Vector<File> files = new Vector<File>();
                    int i = 0;
                    while (i < entries.length) {
                        File f = new File(this.source, entries[i]);
                        if (f.isFile()) {
                            files.addElement(f);
                        }
                        ++i;
                    }
                    if (files.size() < 1) {
                        throw new BuildException("No files found in directory " + this.source);
                    }
                    int numfiles = files.size();
                    Random rn = new Random();
                    int x = rn.nextInt(numfiles);
                    this.source = (File)files.elementAt(x);
                }
            } else {
                SoundTask.this.log(this.source + ": invalid path.", 1);
                this.source = nofile;
            }
            return this.source;
        }

        public int getLoops() {
            return this.loops;
        }

        public Long getDuration() {
            return this.duration;
        }
    }
}

