/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.util.TeeOutputStream;

public class SSHExec
extends SSHBase {
    private static final int BUFFER_SIZE = 1024;
    private String command = null;
    private long maxwait = 0L;
    private Thread thread = null;
    private String outputProperty = null;
    private File outputFile = null;
    private boolean append = false;
    private static final String TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";

    public void setCommand(String command) {
        this.command = command;
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setOutputproperty(String property) {
        this.outputProperty = property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.getHost() == null) {
            throw new BuildException("Host is required.");
        }
        if (this.getUserInfo().getName() == null) {
            throw new BuildException("Username is required.");
        }
        if (this.getUserInfo().getKeyfile() == null && this.getUserInfo().getPassword() == null) {
            throw new BuildException("Password or Keyfile is required.");
        }
        if (this.command == null) {
            throw new BuildException("Command is required.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TeeOutputStream tee = new TeeOutputStream(out, System.out);
        Session session = null;
        try {
            block20: {
                try {
                    int ec;
                    session = this.openSession();
                    session.setTimeout((int)this.maxwait);
                    final ChannelExec channel = (ChannelExec)session.openChannel("exec");
                    channel.setCommand(this.command);
                    channel.setOutputStream((OutputStream)tee);
                    channel.setExtOutputStream((OutputStream)tee);
                    channel.connect();
                    this.thread = new Thread(){

                        public void run() {
                            while (!channel.isEOF()) {
                                if (SSHExec.this.thread == null) {
                                    return;
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                    };
                    this.thread.start();
                    this.thread.join(this.maxwait);
                    if (this.thread.isAlive()) {
                        this.thread = null;
                        if (this.getFailonerror()) {
                            throw new BuildException(TIMEOUT_MESSAGE);
                        }
                        this.log(TIMEOUT_MESSAGE, 0);
                        break block20;
                    }
                    if (this.outputProperty != null) {
                        this.getProject().setProperty(this.outputProperty, out.toString());
                    }
                    if (this.outputFile != null) {
                        this.writeToFile(out.toString(), this.append, this.outputFile);
                    }
                    if ((ec = channel.getExitStatus()) == 0) break block20;
                    String msg = "Remote command failed with exit status " + ec;
                    if (this.getFailonerror()) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (JSchException e) {
                    if (e.getMessage().indexOf("session is down") >= 0) {
                        if (this.getFailonerror()) {
                            throw new BuildException(TIMEOUT_MESSAGE, e);
                        }
                        this.log(TIMEOUT_MESSAGE, 0);
                    } else {
                        if (this.getFailonerror()) {
                            throw new BuildException(e);
                        }
                        this.log("Caught exception: " + e.getMessage(), 0);
                    }
                    Object var8_11 = null;
                    if (session == null) return;
                    if (!session.isConnected()) return;
                    session.disconnect();
                    return;
                }
                catch (Exception e) {
                    if (this.getFailonerror()) {
                        throw new BuildException(e);
                    }
                    this.log("Caught exception: " + e.getMessage(), 0);
                    Object var8_12 = null;
                    if (session == null) return;
                    if (!session.isConnected()) return;
                    session.disconnect();
                    return;
                }
            }
            Object var8_10 = null;
            if (session == null) return;
            if (!session.isConnected()) return;
            session.disconnect();
            return;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (session == null) throw throwable;
            if (!session.isConnected()) throw throwable;
            session.disconnect();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeToFile(String from, boolean append, File to) throws IOException {
        FileWriter out = null;
        try {
            int bytesRead;
            out = new FileWriter(to.getAbsolutePath(), append);
            StringReader in = new StringReader(from);
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            Object var9_8 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

