/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.BasicShape;
import org.apache.tools.ant.types.optional.image.ColorMapper;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Ellipse
extends BasicShape
implements DrawOperation {
    protected int width = 0;
    protected int height = 0;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public PlanarImage executeDrawOperation() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 7);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        if (!this.stroke.equals("transparent")) {
            BasicStroke b_stroke = new BasicStroke(this.stroke_width);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(b_stroke);
            graphics.draw(new Ellipse2D.Double(0.0, 0.0, this.width, this.height));
        }
        if (!this.fill.equals("transparent")) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            graphics.fill(new Ellipse2D.Double(0.0, 0.0, this.width, this.height));
        }
        int i = 0;
        while (i < this.instructions.size()) {
            ImageOperation instr = (ImageOperation)this.instructions.elementAt(i);
            if (instr instanceof DrawOperation) {
                PlanarImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img.getAsBufferedImage(), null, 0, 0);
            } else if (instr instanceof TransformOperation) {
                graphics = (Graphics2D)bi.getGraphics();
                PlanarImage image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
                bi = image.getAsBufferedImage();
            }
            ++i;
        }
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }
}

