/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathImpl;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.IBMCertPathHelper;
import com.ibm.security.cert.PKIXCertPathValidatorImpl;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PKIXCertPathBuilderImpl
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final String x509String = "X.509";

    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        if (debug != null) {
            System.out.println("CERTPATH: to build a certpath with parameters " + certPathParameters + ")");
        }
        PKIXBuilderParameters pKIXBuilderParameters = null;
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult = null;
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        CertPath certPath = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Collection<Object> collection = new ArrayList();
        X509Certificate x509Certificate = null;
        LinkedList<X509Certificate> linkedList2 = new LinkedList<X509Certificate>();
        boolean bl = false;
        X509CertSelector x509CertSelector = null;
        Object[] objectArray = new Object[]{null, null};
        Object var13_13 = null;
        List<CertStore> list = null;
        int n = -1;
        Object var16_16 = null;
        Object var17_17 = null;
        CertSelector certSelector = null;
        Date date = null;
        boolean bl2 = false;
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters are not an instance of PKIXBuilderParameters");
        }
        pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
        list = pKIXBuilderParameters.getCertStores();
        n = pKIXBuilderParameters.getMaxPathLength();
        String[] stringArray = this.getTaNames(pKIXBuilderParameters.getTrustAnchors());
        certSelector = pKIXBuilderParameters.getTargetCertConstraints();
        if (certSelector == null) {
            throw new InvalidAlgorithmParameterException("TargetCertConstraints is not set in the CertPathParameters");
        }
        if (!(certSelector instanceof X509CertSelector)) {
            throw new InvalidAlgorithmParameterException("TargetCertConstrants is not an instance of X509CertSelector");
        }
        date = pKIXBuilderParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        if (IBMCertPathHelper.getSubject(x509CertSelector = (X509CertSelector)certSelector) == null && (object2 = x509CertSelector.getCertificate()) != null) {
            object = ((X509Certificate)object2).getSubjectDN();
            if (!(object instanceof X500Name)) {
                try {
                    object2 = new X509CertImpl(((Certificate)object2).getEncoded());
                    object = ((X509Certificate)object2).getSubjectDN();
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            IBMCertPathHelper.setSubject(x509CertSelector, (X500Name)object);
        }
        if (IBMCertPathHelper.getSubject(x509CertSelector) == null) {
            throw new InvalidAlgorithmParameterException("TargetSubject must be set");
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (CertStore)object2.next();
            try {
                collection = ((CertStore)object).getCertificates(x509CertSelector);
            }
            catch (CertStoreException certStoreException) {
                throw new CertPathBuilderException("Exception caught: " + certStoreException);
            }
            if (collection.isEmpty()) continue;
            linkedList.addAll(collection);
        }
        if (linkedList.isEmpty()) {
            throw new CertPathBuilderException("No end-entity certificate matching the selection criteria could be found.");
        }
        if (linkedList.size() > 1 && IBMCertPathHelper.getSubject(x509CertSelector) == null) {
            throw new InvalidAlgorithmParameterException("TargetSubject must be set, target constraints do not uniquely identify a certificate");
        }
        object = new X509CertSelector();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext() && !bl2) {
            x509Certificate = (X509Certificate)iterator.next();
            linkedList2.add(x509Certificate);
            object = this.createCASelector(x509Certificate, (X509CertSelector)object);
            objectArray = this.buildCertPath((X509CertSelector)object, list, linkedList2, pKIXBuilderParameters, n, stringArray);
            if (objectArray[1] != null) {
                bl2 = true;
                continue;
            }
            linkedList2.clear();
        }
        certPath = (CertPath)objectArray[0];
        if (!(objectArray[1] instanceof Exception)) {
            pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)objectArray[1];
            try {
                pKIXCertPathBuilderResult = new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    System.out.println("CERTPATH: exception thrown while constructing builder result");
                    nullPointerException.printStackTrace();
                }
                throw (CertPathBuilderException)new CertPathBuilderException().initCause(nullPointerException);
            }
        } else {
            if (debug != null) {
                System.out.println("CERTPATH: PKIXCertPathBuilderImpl.engineBuild() exception thrown");
                ((Exception)objectArray[1]).printStackTrace();
            }
            throw new CertPathBuilderException("PKIXCertPathBuilderImpl could not build a valid CertPath.", (Exception)objectArray[1]);
        }
        return pKIXCertPathBuilderResult;
    }

    private Object[] buildCertPath(X509CertSelector x509CertSelector, List list, LinkedList linkedList, PKIXBuilderParameters pKIXBuilderParameters, int n, String[] stringArray) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Object object;
        CertPathImpl certPathImpl = null;
        Collection<Object> collection = new ArrayList();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        Object[] objectArray = new Object[]{null, null};
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                object = (CertStore)iterator.next();
                collection = ((CertStore)object).getCertificates(x509CertSelector);
                if (collection.isEmpty()) continue;
                linkedList2.addAll(collection);
            }
            catch (CertStoreException certStoreException) {
                throw new CertPathBuilderException("Exception caught: " + certStoreException);
            }
        }
        if (linkedList.size() <= n || n == -1) {
            object = linkedList2.iterator();
            while (object.hasNext() && !bl) {
                x509Certificate = (X509Certificate)object.next();
                if (linkedList.contains(x509Certificate)) continue;
                if (this.isEndOfCertPath(x509Certificate, stringArray)) {
                    if (n != -1 && linkedList.size() > n) {
                        throw new CertPathBuilderException("length of cert chain exceeds max path length");
                    }
                    certPathImpl = new CertPathImpl(x509String, linkedList);
                    objectArray = this.myValidator(certPathImpl, pKIXBuilderParameters);
                    if (objectArray[1] == null) continue;
                    bl = true;
                    continue;
                }
                linkedList.add(x509Certificate);
                x509CertSelector = this.createCASelector(x509Certificate, x509CertSelector);
                objectArray = this.buildCertPath(x509CertSelector, list, linkedList, pKIXBuilderParameters, n, stringArray);
                if (objectArray[1] != null) {
                    bl = true;
                    continue;
                }
                x509Certificate2 = (X509Certificate)linkedList.removeLast();
            }
        }
        if (objectArray[1] == null) {
            x509Certificate2 = (X509Certificate)linkedList.getLast();
            object = null;
            if (this.isSelfSigned(x509Certificate2)) {
                linkedList.removeLast();
                if (linkedList.size() == 0) {
                    boolean bl2;
                    block17: {
                        Set<TrustAnchor> set = pKIXBuilderParameters.getTrustAnchors();
                        bl2 = false;
                        try {
                            object = CertPathUtil.findIssuer(x509Certificate2, set, pKIXBuilderParameters.getSigProvider());
                            if (object != null) {
                                bl2 = true;
                            }
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            if (debug == null) break block17;
                            System.out.println("CERTPATH: failed to validate the certpath " + certPathValidatorException.toString());
                        }
                    }
                    if (!bl2) {
                        throw new CertPathBuilderException("unable to find valid certification path to requested target");
                    }
                }
            }
            if (!((objectArray = this.myValidator(certPathImpl = new CertPathImpl(x509String, linkedList), pKIXBuilderParameters))[1] instanceof Exception)) {
                objectArray[0] = certPathImpl;
                if (((CertPath)objectArray[0]).getCertificates().size() == 0) {
                    objectArray[1] = new PKIXCertPathValidatorResult((TrustAnchor)object, ((PKIXCertPathValidatorResult)objectArray[1]).getPolicyTree(), ((PKIXCertPathValidatorResult)objectArray[1]).getPublicKey());
                }
            }
        }
        return objectArray;
    }

    private boolean isSelfSigned(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN());
    }

    private X509CertSelector createCASelector(X509Certificate x509Certificate, X509CertSelector x509CertSelector) throws CertPathBuilderException {
        try {
            x509CertSelector.setSubject("");
            x509CertSelector.setSubjectKeyIdentifier(null);
            Principal principal = x509Certificate.getIssuerDN();
            if (principal instanceof X500Name) {
                IBMCertPathHelper.setSubject(x509CertSelector, (X500Name)principal);
            } else {
                x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getName());
            }
            Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.AuthorityKeyIdentifier", x509Certificate);
            if (objectArray[1] != null) {
                AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension((Boolean)objectArray[0], objectArray[1]);
                KeyIdentifier keyIdentifier = (KeyIdentifier)authorityKeyIdentifierExtension.get("key_id");
                if (keyIdentifier != null) {
                    x509CertSelector.setSubjectKeyIdentifier(new DerValue(4, keyIdentifier.getIdentifier()).toByteArray());
                } else if (debug != null) {
                    System.out.println("CERTPATH: no AuthorityKeyIdentifier");
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CertPathValidatorException certPathValidatorException) {
            // empty catch block
        }
        if (debug != null) {
            System.out.println("CERTPATH: created CA selector ");
            System.out.println(x509CertSelector.toString());
        }
        return x509CertSelector;
    }

    private Object[] myValidator(CertPath certPath, PKIXBuilderParameters pKIXBuilderParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        PKIXCertPathValidatorImpl pKIXCertPathValidatorImpl = new PKIXCertPathValidatorImpl();
        Object[] objectArray = new Object[]{null, null};
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        try {
            pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)pKIXCertPathValidatorImpl.engineValidate(certPath, pKIXBuilderParameters);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            if (debug != null) {
                System.out.println("CERTPATH: myValidator failed on validation");
                certPathValidatorException.printStackTrace();
            }
            objectArray[1] = certPathValidatorException;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (debug != null) {
                System.out.println("CERTPATH: myValidator has invalid parameter");
                invalidAlgorithmParameterException.printStackTrace();
            }
            objectArray[1] = invalidAlgorithmParameterException;
        }
        if (pKIXCertPathValidatorResult != null) {
            objectArray[0] = certPath;
            objectArray[1] = pKIXCertPathValidatorResult;
        }
        return objectArray;
    }

    private String[] getTaNames(Set set) {
        int n = 0;
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            String string = trustAnchor.getCAName();
            stringArray[n] = string == null ? trustAnchor.getTrustedCert().getSubjectDN().getName() : string;
            ++n;
        }
        return stringArray;
    }

    private boolean isEndOfCertPath(X509Certificate x509Certificate, String[] stringArray) {
        String string = x509Certificate.getSubjectDN().getName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

