/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.ObjectIdentifier;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class PolicyNodeImpl
implements PolicyNode {
    private ObjectIdentifier validPolicy;
    private Set qualifiers;
    private boolean criticality;
    private Set expectedPolicySet;
    private PolicyNode parent;
    private Set children;
    private int depth;

    PolicyNodeImpl(ObjectIdentifier objectIdentifier, Set set, boolean bl, Set set2, PolicyNode policyNode) {
        this.validPolicy = objectIdentifier;
        this.qualifiers = set;
        this.criticality = bl;
        this.expectedPolicySet = set2;
        this.parent = policyNode;
        this.children = new HashSet();
        this.depth = this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public PolicyNode getParent() {
        return this.parent;
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public String getValidPolicy() {
        return this.validPolicy.toString();
    }

    public Set getPolicyQualifiers() {
        if (this.depth == 0) {
            return new HashSet();
        }
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        Iterator iterator = this.qualifiers.iterator();
        while (iterator.hasNext()) {
            hashSet.add((PolicyQualifierInfo)iterator.next());
        }
        return hashSet;
    }

    public Set getExpectedPolicies() {
        HashSet hashSet = new HashSet(this.expectedPolicySet);
        return (Set)hashSet.clone();
    }

    public boolean isCritical() {
        return this.criticality;
    }

    void addChild(PolicyNode policyNode) {
        this.children.add(policyNode);
    }

    void removeChild(PolicyNode policyNode) {
        this.children.remove(policyNode);
    }

    public boolean match(ObjectIdentifier objectIdentifier) {
        HashSet hashSet = new HashSet(this.expectedPolicySet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.equals(objectIdentifier.toString())) continue;
            return true;
        }
        return false;
    }

    void setExpectedPolicySet(Set set) {
        HashSet hashSet = new HashSet(set);
        this.expectedPolicySet = new HashSet();
        this.expectedPolicySet = (HashSet)hashSet.clone();
    }

    public void print() {
        Iterator iterator;
        System.out.println("PolicyNodeImpl [");
        System.out.println("    valid policy: " + this.validPolicy.toString());
        System.out.print("    qualifier set: ");
        while ((iterator = this.qualifiers.iterator()).hasNext()) {
            System.out.print(iterator.next());
        }
        System.out.println("    criticality: " + this.criticality);
        System.out.print("    expected policy set: " + this.expectedPolicySet.size());
        System.out.println("]");
    }
}

