/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

final class DSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    static final long serialVersionUID = 6681063074876594473L;
    private BigInteger x;
    private static String[] z;

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.x = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1] + iOException.getMessage());
        }
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public BigInteger getX() {
        return this.x;
    }

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public String toString() {
        return z[0] + this.getX().toString() + "\n";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block19: {
            int n2;
            int n3;
            block18: {
                char[] cArray2;
                Object var0;
                block17: {
                    int n4;
                    block16: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray3 = "HV/\u0014xD4&\rz!D\u00107M``\u0007~pdmXT".toCharArray();
                        cArray2 = cArray3;
                        n4 = cArray3.length;
                        n3 = 0;
                        if (!true) break block16;
                        n4 = n4;
                        if (n4 <= n3) break block17;
                    }
                    do {
                        int n5;
                        cArray2 = cArray2;
                        int n6 = n3;
                        char c2 = cArray2[n6];
                        switch (n3 % 5) {
                            case 0: {
                                n5 = 1;
                                break;
                            }
                            case 1: {
                                n5 = 20;
                                break;
                            }
                            case 2: {
                                n5 = 98;
                                break;
                            }
                            case 3: {
                                n5 = 94;
                                break;
                            }
                            default: {
                                n5 = 59;
                            }
                        }
                        cArray2[n6] = (char)(c2 ^ n5);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[0] = new String(cArray2).intern();
                var0 = null;
                char[] cArray4 = "b{\u00172_!z\r*\u001bEQ0~^ow\r:^!lX~".toCharArray();
                cArray = cArray4;
                n2 = cArray4.length;
                n3 = 0;
                if (!true) break block18;
                n2 = n2;
                if (n2 <= n3) break block19;
            }
            do {
                int n7;
                cArray = cArray;
                int n8 = n3;
                char c3 = cArray[n8];
                switch (n3 % 5) {
                    case 0: {
                        n7 = 1;
                        break;
                    }
                    case 1: {
                        n7 = 20;
                        break;
                    }
                    case 2: {
                        n7 = 98;
                        break;
                    }
                    case 3: {
                        n7 = 94;
                        break;
                    }
                    default: {
                        n7 = 59;
                    }
                }
                cArray[n8] = (char)(c3 ^ n7);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[1] = new String(cArray).intern();
        z = stringArray;
    }
}

