/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class ECNamedCurve
extends ECGenParameterSpec
implements AlgorithmParameterSpec {
    private final String a;
    private final ObjectIdentifier b;
    private final byte[] c;
    private final ECParameterSpec d;
    private static final Map<String, String> e;
    private static final Map<String, ECParameterSpec> f;
    private static final Map<String, ECParameterSpec> g;
    private static final Map<Integer, ECParameterSpec> h;
    private static Pattern i;
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 5;
    private static final int m = 6;
    private static String[] z;

    public ECNamedCurve(String string) {
        super(string);
        this.a = string;
        this.d = ECNamedCurve.getECParameterSpec(this.a);
        this.b = ECNamedCurve.getOIDFromName(this.a);
        if (this.b == null) {
            throw new InvalidParameterException(z[0]);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOID(this.b);
        }
        catch (IOException iOException) {
            throw new InvalidParameterException(z[1]);
        }
        this.c = derOutputStream.toByteArray();
    }

    protected ECNamedCurve(String string, ObjectIdentifier objectIdentifier, EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n2) throws IOException {
        super(string);
        this.a = string;
        this.b = objectIdentifier;
        this.d = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(objectIdentifier);
        this.c = derOutputStream.toByteArray();
    }

    byte[] a() {
        return (byte[])this.c.clone();
    }

    public String getName() {
        return this.a;
    }

    public ECParameterSpec getECParameterSpec() {
        return this.d;
    }

    public static ObjectIdentifier getOIDFromName(String string) {
        try {
            if (string.startsWith(z[2]) || string.startsWith(z[3])) {
                if (f.get(string) == null) {
                    throw new IOException();
                }
                return new ObjectIdentifier(string);
            }
            String string2 = e.get(string);
            if (string2 == null) {
                throw new IOException();
            }
            return new ObjectIdentifier(string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(String string) {
        ECParameterSpec eCParameterSpec = f.get(string);
        return eCParameterSpec != null ? eCParameterSpec : g.get(string);
    }

    static ECParameterSpec a(ObjectIdentifier objectIdentifier) {
        return ECNamedCurve.getECParameterSpec(objectIdentifier.toString());
    }

    public String toString() {
        return this.a + z[9] + this.b + ")";
    }

    private static BigInteger a(String string) {
        return new BigInteger(string, 16);
    }

    private static void a(String string, String string2, int n2, String string3, String string4, String string5, String string6, String string7, String string8, int n3) {
        BigInteger bigInteger = ECNamedCurve.a(string3);
        if (n2 != 1 && n2 != 5) {
            if (n2 == 2 || n2 == 6) {
                throw new RuntimeException(z[6]);
            }
            throw new RuntimeException(z[4] + n2);
        }
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECNamedCurve.a(string4), ECNamedCurve.a(string5));
        ECPoint eCPoint = new ECPoint(ECNamedCurve.a(string6), ECNamedCurve.a(string7));
        try {
            String[] stringArray;
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
            ECNamedCurve eCNamedCurve = new ECNamedCurve(string, objectIdentifier, ellipticCurve, eCPoint, ECNamedCurve.a(string8), n3);
            ECParameterSpec eCParameterSpec = eCNamedCurve.getECParameterSpec();
            if (f.put(string2, eCParameterSpec) != null) {
                throw new RuntimeException(z[7] + string2);
            }
            for (String string9 : stringArray = i.split(string)) {
                if (g.put(string9.trim(), eCParameterSpec) != null) {
                    throw new RuntimeException(z[5] + string9);
                }
                if (e.put(string9.trim(), string2) == null) continue;
                throw new RuntimeException(z[5] + string9);
            }
            int n4 = eCFieldFp.getFieldSize();
            if (n2 == 5 || n2 == 6 || h.get(n4) == null) {
                h.put(n4, eCParameterSpec);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(z[8], iOException);
        }
    }

    static {
        z = new String[]{ECNamedCurve.z(ECNamedCurve.z("\f_]\u000114PWS9,_U\u0001>9Z]\u0001?*\u0017wh\u0014xGJN&1S]Ep/VK\u0001>7C\u0018S5;X_O9\"R\\\u0001?*\u0017QRp6XL\u0001#-GHN\",R\\")), ECNamedCurve.z(ECNamedCurve.z("\f_]\u0001\u001f\u0011s\u0018B?-[\\\u0001>7C\u0018C5xs}s}=Y[N4=S")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r")), ECNamedCurve.z(ECNamedCurve.z("\u0011YN@<1S\u0018U)(R\u0002\u0001")), ECNamedCurve.z(ECNamedCurve.z("\u001cBHM9;VLH?6\u0017V@==\r\u0018")), ECNamedCurve.z(ECNamedCurve.z("\u001a^V@\"!\u0017^H54SK\u00011*R\u0018O?,\u0017KT (XJU5<")), ECNamedCurve.z(ECNamedCurve.z("\u001cBHM9;VLH?6\u0017WH4b\u0017")), ECNamedCurve.z(ECNamedCurve.z("\u0011YLD\"6VT\u00015*EWS")), ECNamedCurve.z(ECNamedCurve.z("x\u001f"))};
        e = new HashMap<String, String>();
        f = new LinkedHashMap<String, ECParameterSpec>();
        g = new HashMap<String, ECParameterSpec>();
        h = new HashMap<Integer, ECParameterSpec>();
        i = Pattern.compile(ECNamedCurve.z(ECNamedCurve.z("tKdz,\u0004j")));
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qai\u0005J\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~n")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001cu\u000fbb\u0019u~\u0017b\u001d\u0004\rdfn\u000f\b\u0016f\u001aryebh\u000fz")), ECNamedCurve.z(ECNamedCurve.z("\u001cu\u000fbb\u0019u~\u0017b\u001d\u0004\rdfn\u000f\b\u0016f\u001aryebh\u000f\u0000")), ECNamedCurve.z(ECNamedCurve.z("n\u0002\u0001d\u0016`uy\u0011dk\u000e\t\u0017\u0015\u001ds}\u0019ii\u0006\u000f\u0011b\u001a\u0005\n")), ECNamedCurve.z(ECNamedCurve.z("h\u000e\f\u0019gj\u0004\u0001\u0018imv\rd\u0015o\u0001z\u0014e\u001e\u000e{\u0013\u0016h\u000e\u0000")), ECNamedCurve.z(ECNamedCurve.z("\u0019\u000f\u0001b\u0015mv~\u0019gj\u0003{\u0011\u0011j\u0004}\u0011\u0015hq~\u0016gm\u0007\b")), ECNamedCurve.z(ECNamedCurve.z("\u001cu\u000fbb\u0019u~\u0017b\u001d\u0004\rdgn\u0005\u0000e\u0016\u0019t\u000e\u0014fit\r")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qai\u0005J\u0013")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~o")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001cu\u000fbb\u0019u~\u0017b\u001d\u0004\rdfn\u000f\b\u0016f\u001aryebh\u000fz")), ECNamedCurve.z(ECNamedCurve.z("n\u0006\n\u0016\u0013j\u0003{\u0011e\u001e\u0004\u0000``\u0019vygfmt\bd\u0016h\u0005{")), ECNamedCurve.z(ECNamedCurve.z("m\u0006|d\u0016i\u000f\t\u0014\u0014\u001a\u0002}eglq{bclt\u0000\u0014\u0014o\u0007\u0001")), ECNamedCurve.z(ECNamedCurve.z("luy\u0012`\u0019u\rdha\u0005z\u0015\u0015i\u0001\f\u0018\u0014\u001c\u0007\u0001\u0013hn\u0003\u000b")), ECNamedCurve.z(ECNamedCurve.z("9S[EdnQ\r\u0019hjR\u000b\u0016doS]GcnR\u0001\u0014f=\u000e\u000f")), ECNamedCurve.z(ECNamedCurve.z("k\u0001|g`\u0019v~eh\u001a\u000f|\u0016ea\u0000{`ah\u0002\n\u0011\u0014h\u0003z")), 4);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qaj\u000fJ\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~j\u000f")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq|g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq|g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001et")), ECNamedCurve.z(ECNamedCurve.z("\u001d\u000f\u000f\u0014gat\t\u0010`o\u000e~\u0015c\u001cs\u0000\u0013da\u000e\u000bbb\u001br}\u0014\u0015\u001c\u0004")), ECNamedCurve.z(ECNamedCurve.z("i\u0001\tg\u0016o\u0002\n\u0019\u0012`\u000e\u0001cb\u001c\u0007{\u0013hn\u0007\u000fb\u0011m\u0005{\u0014\u0012`\u0001")), ECNamedCurve.z(ECNamedCurve.z("\u001bq\r`\u0013`\u0004\u0001\u0014\u0012\u0019q}cakt\b\u0013\u0014\u0019\u0005\u0001\u0013\u0014\u001cr|\u0016\u0011`\u0004")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq}\u0011`h\u0007\b\u0011`h\u0000\r`chs\tcih\u0004\u0000`ai\u0002")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qaj\u000fJ\u0013")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~j\u000e")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq|g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq")), ECNamedCurve.z(ECNamedCurve.z("\u001c\u0001\b\u0012aa\u000e\u0000ea\u001a\u0004zc\u0016\u001du~\u0014i\u001bt\u0001c\u0012\u001eq\u0001`\u0015\u001d\u0006")), ECNamedCurve.z(ECNamedCurve.z("mr}d\u0016\u001bv\u000b\u0019`\u001c\u0007\n\u0018aas{\u0013\u0013n\u0002\r\u0019\u0012\u001a\u0001|\u0019\u0011ms")), ECNamedCurve.z(ECNamedCurve.z("ou\u000e`\u0011ms\u0000\u0014\u0015m\u0000\n\u0018hkr\u000eg\u0012k\u0005y\u0016\u0013\u001crzbal\u0007")), ECNamedCurve.z(ECNamedCurve.z("j\u0000z\u0017ii\u0001y\u0019ils\u000b`\u0015\u001d\u0000\t\u0011f\u001er\u0000\u0011e\u001et\u000b\u0015\u0012l\u0003")), ECNamedCurve.z(ECNamedCurve.z("kq~g\u0016\u001eq~\u0016\u0016\u001eq~g\u0016\u001eu}\u0011`j\u0003\u000f\u0013`n\u0006\u000bce\u0019\u0004")), 4);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qan\u0007S\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~a")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001ev{\u0016c")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011g")), ECNamedCurve.z(ECNamedCurve.z("ku\fbc`\u0005{dcovy\u0010ijv\f\u0011aar\u000f\u0017ch\u0004\u000egd\u001e\u0002|ed\u001c\u0000}c\u0012")), ECNamedCurve.z(ECNamedCurve.z("a\u0004\u0000b\u0016a\u0004\r\u0012a`q|b\u0015\u001c\u0001zbb`\u0005\u0000\u0017ek\u0006\u000f\u0012c\u001b\u0004~\u0011c\u001b\u0003~d\u0015")), ECNamedCurve.z(ECNamedCurve.z("h\u0006\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0006z\u0019\u0016\u0019\u0006\u000ee\u0016\u0019u\u0001`\u0013\u0019\u0006\u000ecf\u001a\u0004")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qan\u0007J\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~`")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq\u000fg\u0016\u001eq~g\u0016")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq\u000fg\u0016\u001eq~g\u0013")), ECNamedCurve.z(ECNamedCurve.z("it\u0001\u0016\u0012\u001dq{\u0014d\u001as\u000f`h\u001a\u0001\r`\u0013\u001e\u000f\u0001ghis\fed\u0019s{\u0014fmqy\u0015e")), ECNamedCurve.z(ECNamedCurve.z("lv\u0001\u0017\u0012m\u0001\u0000\u0019\u0015\u001e\u0002\u000f\u0012b`\u0003\u000e\u0017dn\u000e\u0000\u0018f`t\u000b\u0019\u0012\u001a\u000e\t\u0012\u0013\u001aq{\u0019b")), ECNamedCurve.z(ECNamedCurve.z("j\u0004y\u0017b`\u0002\r\u0012an\u000f\u0001\u0015g\u001c\u0002\u0001e\u0013\u001b\u000e\t\u0013`l\u0005\u000b\u0014ak\u0000\u000f`\u0013mqz\u0012b")), ECNamedCurve.z(ECNamedCurve.z("h\u0006\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0006~\u0015\u0013`q\u0001\u0013g\u0019r|\u0012\u0013\u0019\u0000\r\u0013bm\u0000")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qan\u0007J\u0013")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~k\u0007")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001ev{\u0016c")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001ev{\u0016`")), ECNamedCurve.z(ECNamedCurve.z("\u001a\u0003}\u0010cls\u000bg\u0012m\u000e}ch\u001avz\u0014gj\u0000\f\u0018`l\u0001\u000e\u0015\u0014mv~\u0014`k\u000f\u0000c\u0011")), ECNamedCurve.z(ECNamedCurve.z("m\u0005|b\u0012h\u0004\f\u0013ikv\t\u0010g\u001d\u0006~\u0015\u0016\u001e\u0006\tcchq\u000f\u0010ias\u000b\u0010dlt}\u0017\u0014")), ECNamedCurve.z(ECNamedCurve.z("\u001eryg\u0016\u001dq\ndck\u0006~\u0013inr\b\u0016a\u001ev\be\u0016a\u000e\u0000\u0013\u0013\u001ery\u0016\u0014l\u0004~\u0013\u0015")), ECNamedCurve.z(ECNamedCurve.z("h\u0006\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\u000b\u0014a\u001dr\u000f\u0019f\u0019\u000f\t\u0019\u0016kv\t`anu")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qaa\u0005S\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~k\u0006")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0015\u001eq~g\u0015\u001d\u0004\u000f")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\u000b")), ECNamedCurve.z(ECNamedCurve.z("\u001cu\fg\u0016i\u0007}b`m\u0000}\u0018\u0011\u001d\u0005\u000ec`os\b\u0013hhu\u000fgdk\u0003\te\u0011ms\tca\u001dv}\u0011f\u001b\u0000|")), ECNamedCurve.z(ECNamedCurve.z("au\ngb\u001e\u0001|\u0018\u0013m\u0001\n\u0019\u0011o\u000f\f\u0015an\u0004|\u0011amu}\u0019fk\u0003\f\u0011hjvy\u0019h\u001c\u000e\rdb\u001e\u000e|")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~dbnq\ng\u0013i\u0000\bgfa\u0003\u000e\u0017\u0011o\u0003|d\u0016\u001c\u000f|")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qaa\u0005J\u0010p\u0003yqr\u0004xg\u0015\u0010ij\u001b\u0018yiv\u0001\n\u0001 *^UDaa\u0005N\u0010\r")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0010")), 5, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq{")), ECNamedCurve.z(ECNamedCurve.z("n\u0003\n\u0010`m\u0006\u0001deat\u0000\u0011\u0015o\u0007~`g\u001d\u000eycgj\u0005\f\u0012`l\u000e~d\u0012`s}d\u0013\u001b\u0006\f\u0017\u0012au\t")), ECNamedCurve.z(ECNamedCurve.z("i\u000f\u0000e\u0011`\u0007}c`k\u0007\u0001\u0011\u0016n\u0000{c\u0016j\u0007}cdkv\t\u0019hh\u0007~\u0015\u0016\u001e\u0007yg\u0014`\u0005~gah\u0006\n")), ECNamedCurve.z(ECNamedCurve.z("h\u0000\t\u0018b\u001a\u000e\rg\u0016\u001b\u000f|`g`\u0001\u000b\u0010`i\u0006}ef\u001a\u0005\fb\u0014\u001c\u0002\u000f\u0012\u0016a\u0000\u000f`air\u000f\u0018d`\u0006\t")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gias}ghk\u0001\t\u0015f\u001at\u0001ca\u001a\u0003|\u0013b`\u0004\t")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qbj\u0003S\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~k\u0005")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq}g\u0016\u001eq}\u0014f\u001c")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`m")), ECNamedCurve.z(ECNamedCurve.z("\u0019\u0006\f\u0014e\u001a\u0004\u000b\u0015\u0014\u001e\u0007\u0001\u0018\u0014\u001e\u0004\bg\u0013j\u000fy\u0010fav\f\u0017g\u001d\u000e}\u0015gh\u0000\r`ihq\u000fdfm\u0007}cf\u001a\u0000y\u0015e\u001b")), ECNamedCurve.z(ECNamedCurve.z("or\b\u0019i\u001er|\u0016\u0016\u001av\u000b\u0015dj\u000f\nb\u0011\u001eu|\u0017\u0016or\u000b\u0010i\u001e\u0000{\u0011\u0012hu|\u0014i\u001d\u0005{`d\u001asz\u0014ens\u000e\u0010\u0011m")), ECNamedCurve.z(ECNamedCurve.z("h\u0006\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011a\u001ct}\u0019\u0014jr{\u0017a`\u0003{`\u0016hv\u0001\u0016ao\u0001\u0001g\u0012iq\u000f")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qbj\u0003J\u0010p\u0003yqr\u0004xg\u0015\u0013blj")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~k\u0004")), 5, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`i")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001d")), ECNamedCurve.z(ECNamedCurve.z("\u001a\u0003\b\u0014`\u0019\u000f\r\u0011\u0013h\u0003z\u0012\u0011\u001aq\r\u0015ak\u0005\r\u0017eh\u0003\fc`\u001a\u0000|\u0016\u0012\u001es\u0000c\u0011j\u0000\bcca\u0003\u000b\u0013cm\u0002~g\u0012l")), ECNamedCurve.z(ECNamedCurve.z("\u001a\u0000\bd`\u001bu|\u0017\u0012\u001a\u0003zgg\u001e\u0004\n\u0010ca\u0007z\u0018d\u0019\u0007\u000bba\u001c\u0004\r\u0017\u0013j\u0006\t\u0013bk\u0003\u000b\u0013hhs\u000e\u0010amt\tebi")), ECNamedCurve.z(ECNamedCurve.z("\u001as\u000b\u0016fk\u000f\u0000ce\u001e\u0000\n\u0012\u0016\u001a\u0003{\u0013b\u001cq}\u0017\u0013\u001c\u0003\u000b\u0016e\u0019\u0007\r``o\u0003\u000f\u0017dl\u0003|\u0014hi\u000e\u0001\u0019eh\u0007\u000fdcl")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~\u0010f\u0019\u0005}\u0011\u0012`q\b\u0012\u0015i\u0004|eba\u0003\r\u0014\u0013mt\n`c\u001c")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qbm\u0001S\u0010")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~i\u0007")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001dq~g\u0016\u001et\ng")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016")), ECNamedCurve.z(ECNamedCurve.z("o\u000ezdfn\u0000}gi\u001ctzc\u0011\u001b\u0002\r``n\u0005\u0001\u0014\u0013\u001d\u000f\u000f\u0011\u0012h\u0000\b\u0013i\u001aq{e\u0012js{db`s\u0001\u0014i\u001e\u0005\u0000\u0010e\u001a\u0006\u000eghi\u0000\u0001\u0019")), ECNamedCurve.z(ECNamedCurve.z("l\u000f\u000b`\u0014\u0019\u0000\u000f\u0013f\u0019\u0004{\u0015fm\u0002|`d\u001eu~b`\u001d\u0006\t\u0011h\u0019\u000f~eaou\f\u0015h\u0019\u0001\u0000\u0014el\u0006\u0001\u0018\u0013l\u0000|\u0011h\u001eqz\u0010`\u001c\u0003z\u0019")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001erz`\u0011\u001ds{df\u0019q\f\u0019\u0011h\u0004zc\u0016\u001c\u0005\rdh\u001bs\b\u0012fl\u0006\f\u0010")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qbm\u0001J\u0010p\u0003yqr\u0004xg\u0015\u0013en\u001b\u0018yiv\u0001\n\u0001 *^UDbm\u0001N\u0010\r")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0016")), 5, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~\u0011`h\u0007\b\u0011`i\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~\u0011`h\u0007\b\u0011`i\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~b")), ECNamedCurve.z(ECNamedCurve.z("mv{\u0017cms\u0000`\u0011kv\u0001\u0012\u0015ou\u000bd\u0012\u001as\r\u0014gn\u000e\u0000\u0019f\u001at\u000e\u0014a\u001c\u0007\u000ec`\u001bt\r\u0012\u0012hq\u000e\u0012\u0012\u001br\u000bbc\u001d\u0005\u000febn\u0007\fc")), ECNamedCurve.z(ECNamedCurve.z("nu\t\u0016\u0014iq\ndajt\f\u0013doq\u0000c\u0013\u001d\u0001}\u0014fkv\f\u0015`\u001e\u0005\u000f\u0016`k\u0000|\u0019ajs}cckv\bgd\u0019\u0006\u000b\u0018dms\u0000\u0018h\u001b\u0005\u0001\u0017")), ECNamedCurve.z(ECNamedCurve.z("lq}\u0012djr\ng\u0015iv\u000fgi\u001a\u000f}dg\u001du\f`g\u001b\u0007~\u0018\u0015i\u0001\nc\u0013\u001d\u0004\u000b\u0014gnu\u000b\u0010e\u001dt}b\u0012\u001a\u0001\f\u0011f`\u0004\u000fc\u0016m\u0006~\u0014")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~\u0011`h\u0007\b\u0011`hq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eqzb\u0015nqy`\u0014\u0019\u0000\t\u0016i\u001d\u000f\fgc\u001a\u000e{`\u0013jq{\u0017cj\u0002\r\u0010")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qc`\u0003J\u0010p\u0003yqr\u0004xg\u0015\u0012hlj")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~k\u0003")), 5, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~d\u0016\u001eq~g\u0016\u001eq\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\bg\u0016\u001eq~g\u0016\u001e")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~d\u0016\u001eq~g\u0016\u001eq\b\u0011`h\u0007\b\u0011`h\u0007\b\u0011`h\u0007\bg\u0016\u001eq~g\u0016\u001b")), ECNamedCurve.z(ECNamedCurve.z("\u001a\u0004\u000b\u0010b\u001ev\u000fdbkr}\u0016\u0015l\u000e\u0000\u0019\u0015h\u0002\u000ec\u0015kq\u0000\u0013\u0014i\u000e\t\u0019a\u001c\u000e{\u0017\u0015\u001er\u0000\u0010di\u0006\n\u0011ci\u0003\b\u0019h\u001e\u0002\b\u0010c`\u0000\r`\u0013n\u0002\u000e\u0012i`s\u0000`b\u001ds\t\u0018\u0014jv\u0000\u0014\u0013`r|ec\u001dt\n`\u0015\u001e")), ECNamedCurve.z(ECNamedCurve.z("\u0019v\u0000\u0016\u0013\u0019\u0005\nc\u0015`u\b\u0014co\u000f}ca\u001b\u0000\td\u0016k\u0005\b`\u0014o\u0003\u000eda\u001c\u0004z\u0017b`uy\u0016i\u001a\u000e\u0000\u0014i\u001e\u0000\f\u0010\u0015h\u000f\n\u0014djv\u000b\u0019em\u0007\ngbmszgem\u0005\u0001\u0017\u0013kv\r\u0015e\u001d\u0004\u0000\u0016bo\u0001\b`\u0012o")), ECNamedCurve.z(ECNamedCurve.z("k\u0001\t\u0016\u0014\u001d\u0003y\u0018fj\u0001\nbf\u001e\u0002|\u0018\u0015a\u000fzgij\u000e\ne\u0013j\u000e~\u0019\u0016l\u0006|c\u0014j\u000f\u0001`al\u0000{di\u001cv\u000b\u0010aku\rg`\u001a\u000f{\u0011`\u0019\u0001\bca\u001br\teg\u001d\u000f\t\u0018\u0014ov\f\u0012a\u001c\u0000{\u0018`\u001dv\bde\u001e")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~bgn\u0004\fehiq\f\u0012gjs|ge`\u0006y\u0011\u0014\u001a\u0005\f\u0019\u0012hv\u000f\u0016\u0011\u001dt}baa\u0001yb\u0013\u001b\u0002\n\u0018gk")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("+R[Qej\u0006J\u0010p\u0003yqr\u0004xg\u0015\u0014bij")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\u000b\u000fak\u0005\u0016\u0011~k\u0002")), 5, ECNamedCurve.z(ECNamedCurve.z("h\u0006~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq")), ECNamedCurve.z(ECNamedCurve.z("h\u0006~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001et")), ECNamedCurve.z(ECNamedCurve.z("h\u0007\r\u0010im\u0004}cin\u0006\u0000da\u001b\u000ey\u0010\u0016a\u0005\u0001`biv\bcf`\u0002\f\u0011\u0015\u001dv\ne\u0011o\u0005\rciau\u000b\u0010e\u001e\u0004z\u0019\u0012l\u000f\u0001\u0018a`r~\u0010`ar\t\u0014fi\u000e\u000b\u0018eir{\u0016\u0015a\u0004\u000fcan\u0002\nb`\u001as\u000bc\u0012iu~\u0011gk\u0002\u000f\u0012\u0014\u001e\u000f\u0000\u0012\u0014jt\u000b\u0015\u0016ir~\u0015eiq|\u0015f\u001a\u0002\b\u0012\u0016h\u0007")), ECNamedCurve.z(ECNamedCurve.z("h\u0007{\u0017hm\u000f}\u0011f\u001a\u0000\b\u0015`lr\u0001b\u0014ar\u000bd\u0013\u001a\u0001\u000e\u0013ca\u0002z\u0015dj\u000e{\u0017d`\u0006\u000b\u0018`m\u0004~cej\u0006~\u0019b`v~\u0017`nu\fec\u001cuy`alu\rdgor~dgm\u000e\n\u0019\u0016\u001d\u0006|baj\u0000y\u0013\u0016\u001ev\u0000e\u0015k\u0004\f\u0019\u0012kt\t\u0019env\f\u0013i\u001aq\u0001\u0016\u0015or\u000b\u0010\u0013jr\rc\u0014n\u0001")), ECNamedCurve.z(ECNamedCurve.z("h\u0006\t\u0019ca\u0005\u0001\u0017\u0011o\u000f\u0001`c\u001at\b\u0011dmt\u0000`e\u001eu\f\u0013\u0013os\tc\u0014a\u000e\u0000gel\u0003\f\u0018eo\u000ez\u0015dn\u000f\t\u0016\u0011\u001eu|\u0010gj\u0000\u000bdfn\u0005{\u0018g\u001dr\u000f\u0013ia\u0002}gdj\u0001\f\u0011\u0013m\u0002\bcih\u0006\u000bg\u0011\u001c\u0007\u000f\u0017ak\u0002\u000bbgh\u000f\u000e`bo\u0005{\u0013dh\u000f\u0000c\u0015a\u0003\u000f\u0017i\u001es\t\u0017fm\u0007")), ECNamedCurve.z(ECNamedCurve.z("h\u0006~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eqy\u0014a`\u0001\u0000\u0016hku~\u0013\u0016a\u0001\u000ecg\u001et{\u0011al\u000f~\u0016`av\re`kuz\u0014\u0013au\u0000\u0019iat\f\u0016\u0011\u001duz\u0017\u0016\u001a\u0000\tdii\u0004\u0000\u0017dh\u000e")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0000\u000e\u0016\u0017bxGJH==\u0006\u0001\u0013&j")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0013")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq{")), ECNamedCurve.z(ECNamedCurve.z("\u001bt\n\u0013\u0014ns~cimt\u000ecbmr\f\u0018\u0013hs\u000e\u0012flv\fdea\u000f\bbca\u0004y`bi\u0001\u000e\u0019\u0014a\u0002\u000b")), ECNamedCurve.z(ECNamedCurve.z("\u001dry\u0013\u0012\u0019r\u000fdal\u000e\u000f\u0019djq\ne\u0015o\u0000\u000e\u0018\u0013\u001er\u0001bi`\u000e{\u0011gjv|\u0017inq\f\u0019`k\u0003y")), ECNamedCurve.z(ECNamedCurve.z("n\u0002\u000f\u0015\u0014i\u0006|\u0017i\u001a\u0001}bg\u0019\u0001\u000f\u0013\u0012\u001a\u000f\n```\u0004|gb\u001e\u0005z\u0011hl\u0000|dio\u0007z\u0013\u0014\u001d\u0006\r")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~de\u001eu\t`gj\u0003|bhh\u0003\t\u0019fl\u000f|\u0019\u0014\u001c\u0004\t")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0000\u000e\u0016\u0017bxGJH==\u0006\u0001\u0013&k")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0012")), 1, ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001er~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq{")), ECNamedCurve.z(ECNamedCurve.z("j\u0005\t\u0013c\u001ct\n\u0012imv\b\u0014\u0013\u0019v\u000f\u0015bksyd\u0013\u001bt\u0001\u0015gn\u0007y\u0016\u0014l\u0001\n\u0013enu|\u0014fa\u0006\u000e")), ECNamedCurve.z(ECNamedCurve.z("os\n\u0018go\u000f\t\u0011`\u001b\u0001\r`a\u001cv\t\u0016hk\u0000\t\u0017e`\u000f|b\u0015ju\u0000cd\u0019r}\u0019\u0015j\u0005\u0000ga`\u000e\u000e")), ECNamedCurve.z(ECNamedCurve.z("k\u000fy\u0018`\u001e\u0005\n\u0017co\u0004\u000b\u0016ck\u0003z\u0015i\u001ctz\u0017f\u0019\u0001|bh\u001e\u000e\u0001\u0016h\u0019ty\u0016fl\u000fy\u0018dku\b")), ECNamedCurve.z(ECNamedCurve.z("\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u0019\u0001\ne`k\u0006{\u0019c\u001e\u0003\n\u0018d\u001e\u0001\f\u0011\u0015\u001b\u0006\u000b")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0000\u000e\u0016\u0017bxGJH==\u0005\u000b\u0018&i")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0015")), 1, ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016\u001eq~g\u0016\u001e\u000f\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016\u0016\u001eq~g\u0016\u001eq~g\u0016")), ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016\u001eq~g\u0016\u001e\u000f\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016\u0016\u001eq~g\u0016\u001eq~g\u0013")), ECNamedCurve.z(ECNamedCurve.z("nu\b\u0010f\u001b\u0004ze\u0013\u001e\u0006\u0000\u0018dis\befm\u0003\u0001\u0013al\u0000\rb\u0011o\u0006y\u0018\u0014\u001a\u0005~cbos\teco\u0000\u0001\u0017a`\u0002{\u0013il\u0005{\u0011\u0011")), ECNamedCurve.z(ECNamedCurve.z("hq~`in\u0004{e\u0013\u0019\u000f\u0000\u0010f\u001bt{\u0012c\u001a\u000f\u000e\u0015b\u001ar|gih\u0002{\u0012\u0014k\u0002\u0000\u0014gks\u000bgboqzc\u0014ku\u000bb\u0012avy`\u0016")), ECNamedCurve.z(ECNamedCurve.z("os}c\u0015`r\fdihv\re\u0011\u001d\u0001}\u0015`m\u0003{`ek\u0007z``l\u0001\r\u0015\u0012k\u0001\u0000\u0010h\u001br\n\u0013f\u001a\u0004\u0001g\u0013\u001bu\u000fc`jq\t`\u0015")), ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016ar\rdi\u0019\u000e~\u0014\u0014a\u0007\u000f\u0010\u0016\u001as\t\u0014bj\u0001\u0000\u0019ih\u000e|\u0011\u0012")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0000\u000e\u0016\u0017bxGJH==\u0005\u000b\u0018&j")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0014")), 1, ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016\u001eq~g\u0016\u001e\u000f\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016\u0016\u001eq~g\u0016\u001eq~g\u0016")), ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016\u001eq~g\u0016\u001e\u000f\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016\u0016\u001eq~g\u0016\u001eq~g\u0013")), ECNamedCurve.z(ECNamedCurve.z("n\u0006\u000fg\u0011\u001a\u0001\u0000\u0012bm\u0000\u000eb\u0012\u001aq}eehs\u0001\u0018\u0016h\u0005\f\u0018\u0013kq}de`u\u0001\u0015\u0012\u0019\u0007\b\u0012h\u001b\u0000ydhlt\u0000bhk\u0005~\u0013\u0013")), ECNamedCurve.z(ECNamedCurve.z("k\u000fyg`as\u0001\u0019gj\u0000\u000f\u0011ei\u0005\bbij\u0006zce\u001d\u000e}\u0013fj\u000e\u000e`c\u001bs{gb\u001e\u0004\r\u0016eov\bd\u0011\u001es\u0000\u0016\u0012`\u0004\bdg")), ECNamedCurve.z(ECNamedCurve.z("mu\b\u0010bmr\fe\u0012\u001dv\bd\u0013o\u0005\b\u0017\u0014\u0019\u0007~b`is\u0001c``\u0006\u000b\u0013i\u001eu\r\u0014e\u001cr\u000ed\u0016l\u0001\b\u0013cos~gh\u001ar\fc\u0011")), ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~ghh\u0007\b\u0011`\u001bqy\u0016\u0015`\u0002\u0001\u0015co\u0000|\u0015alt\b\u0012hj\u0006zbe`\u0005\b\u0017c")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0000\u000e\u0016\u0017bxGJH==\u0005\u000b\u0018&k")), ECNamedCurve.z(ECNamedCurve.z("i\u0019\n\u000fhl\u0007\u0016\u0010`h\u0003\r\u000fcv\u0006\u0016\u0017")), 1, ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016\u001eq~g\u0016\u001e\u000f\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016\u0016\u001eq~g\u0016\u001eq~g\u0016")), ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016\u001eq~g\u0016\u001e\u000f\b\u0011`h\u0007\b\u0011`h\u0007\b\u0016\u0016\u001eq~g\u0016\u001eq~g\u0013")), ECNamedCurve.z(ECNamedCurve.z("j\u0002\r\u0016`mqy\u0013\u0011k\u0007\u000e\u0017elu\tgd\u001bu\b\u0012\u0014nv\u000f\u0014`\u0019\u0004\bbbm\u0007\t\u0011b\u001c\u0003\u0001\u0019ho\u0006\u000fei\u001av\t\u0014\u0011\u001a\u0001|\u0012\u0015")), ECNamedCurve.z(ECNamedCurve.z("n\u0000\u000e\u0019\u0011\u001d\u000f}\u0010h\u001au\u0001\u0013\u0013\u001et~\u0011`mt\u0001\u0015i\u0019v\nbf\u001c\u000e\f\u0019eks\bdfn\u0007zc\u0016`\u0002\fca\u001b\u000e\r\u0011e\u001er\u0001\u0014\u0011")), ECNamedCurve.z(ECNamedCurve.z("i\u0001\b\u0016\u0015n\u000f\u0001\u0019\u0016k\u000e\bb`nu{\u0010\u0014m\u0002\nc\u0011\u001c\u0005\n\u0017\u0016ku\u000eg\u0013\u001er\f\u0019\u0012nr\u0000\u0010hl\u000e\u0001`\u0016i\u000f}\u0012\u0015\u001c\u0001{gc")), ECNamedCurve.z(ECNamedCurve.z("oq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~g\u0016\u001eq~gg\u001eq~g\u0016a\u0000\re\u0015\u001a\u0003\tcc\u0019\u0001\b\u0014g\u001b\u0004{\u0015cj\u0006\f\u0017ej\u0001\r\u0014a")), 1);
        i = null;
    }

    private static char[] z(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x50);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block9: {
            int n2;
            int n3;
            block8: {
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray2 = cArray2;
                int n5 = n2;
                char c2 = cArray2[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 88;
                        break;
                    }
                    case 1: {
                        n4 = 55;
                        break;
                    }
                    case 2: {
                        n4 = 56;
                        break;
                    }
                    case 3: {
                        n4 = 33;
                        break;
                    }
                    default: {
                        n4 = 80;
                    }
                }
                cArray2[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

