/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.oc;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class ECPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.ECPrivateKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962695L;
    private BigInteger s;
    private ECParameterSpec params;
    private static String[] z;

    public ECPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public ECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.s = bigInteger;
        this.params = eCParameterSpec;
        AlgorithmParameters algorithmParameters = oc.a(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, algorithmParameters);
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            byte[] byArray = oc.a(bigInteger.toByteArray());
            derOutputStream.putOctetString(byArray);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    protected void parseKeyBits() throws IOException {
        try {
            Object object;
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException(z[3]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            int n2 = derInputStream2.getInteger().intValue();
            if (n2 != 1) {
                throw new IOException(z[1]);
            }
            byte[] byArray = derInputStream2.getOctetString();
            this.s = new BigInteger(1, byArray);
            while (derInputStream2.available() != 0) {
                object = derInputStream2.getDerValue();
                if (object.isContextSpecific((byte)0) || object.isContextSpecific((byte)1)) continue;
                throw new IOException(z[4] + object);
            }
            object = this.algid.getAlgParameters();
            if (object == null) {
                throw new IOException(z[2]);
            }
            this.params = ((AlgorithmParameters)object).getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException iOException) {
            throw new IOException(z[0]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[0]);
        }
    }

    public BigInteger getS() {
        return this.s;
    }

    public ECParameterSpec getParams() {
        return this.params;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block49: {
            int n2;
            int n3;
            block48: {
                char[] cArray2;
                Object var0;
                block47: {
                    int n4;
                    block46: {
                        char[] cArray3;
                        block45: {
                            int n5;
                            block44: {
                                char[] cArray4;
                                block43: {
                                    int n6;
                                    block42: {
                                        char[] cArray5;
                                        block41: {
                                            int n7;
                                            block40: {
                                                stringArray = new String[5];
                                                var0 = null;
                                                char[] cArray6 = "N\u001c4[&n\u0016b\u007f\t'\u00020S<f\u0006'\u001a!b\u000b".toCharArray();
                                                cArray5 = cArray6;
                                                n7 = cArray6.length;
                                                n3 = 0;
                                                if (!true) break block40;
                                                n7 = n7;
                                                if (n7 <= n3) break block41;
                                            }
                                            do {
                                                int n8;
                                                cArray5 = cArray5;
                                                int n9 = n3;
                                                char c2 = cArray5[n9];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n8 = 7;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n8 = 114;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n8 = 66;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n8 = 58;
                                                        break;
                                                    }
                                                    default: {
                                                        n8 = 74;
                                                    }
                                                }
                                                cArray5[n9] = (char)(c2 ^ n8);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[0] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray7 = "Q\u00170I#h\u001cbW?t\u0006bX/'C".toCharArray();
                                        cArray4 = cArray7;
                                        n6 = cArray7.length;
                                        n3 = 0;
                                        if (!true) break block42;
                                        n6 = n6;
                                        if (n6 <= n3) break block43;
                                    }
                                    do {
                                        int n10;
                                        cArray4 = cArray4;
                                        int n11 = n3;
                                        char c3 = cArray4[n11];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n10 = 7;
                                                break;
                                            }
                                            case 1: {
                                                n10 = 114;
                                                break;
                                            }
                                            case 2: {
                                                n10 = 66;
                                                break;
                                            }
                                            case 3: {
                                                n10 = 58;
                                                break;
                                            }
                                            default: {
                                                n10 = 74;
                                            }
                                        }
                                        cArray4[n11] = (char)(c3 ^ n10);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[1] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray8 = "B1b^%j\u0013+Tjw\u00130['b\u0006'H9'\u001f7I>'\u0010'\u001a/i\u0011-^/cR+Tjs\u001a'\u001a+k\u0015-H#s\u001a/\u001a#c\u0017,N#a\u001b'H".toCharArray();
                                cArray3 = cArray8;
                                n5 = cArray8.length;
                                n3 = 0;
                                if (!true) break block44;
                                n5 = n5;
                                if (n5 <= n3) break block45;
                            }
                            do {
                                int n12;
                                cArray3 = cArray3;
                                int n13 = n3;
                                char c4 = cArray3[n13];
                                switch (n3 % 5) {
                                    case 0: {
                                        n12 = 7;
                                        break;
                                    }
                                    case 1: {
                                        n12 = 114;
                                        break;
                                    }
                                    case 2: {
                                        n12 = 66;
                                        break;
                                    }
                                    case 3: {
                                        n12 = 58;
                                        break;
                                    }
                                    default: {
                                        n12 = 74;
                                    }
                                }
                                cArray3[n13] = (char)(c4 ^ n12);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[2] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray9 = "I\u001d6\u001a+'!\u0007k\u001fB<\u0001\u007f".toCharArray();
                        cArray2 = cArray9;
                        n4 = cArray9.length;
                        n3 = 0;
                        if (!true) break block46;
                        n4 = n4;
                        if (n4 <= n3) break block47;
                    }
                    do {
                        int n14;
                        cArray2 = cArray2;
                        int n15 = n3;
                        char c5 = cArray2[n15];
                        switch (n3 % 5) {
                            case 0: {
                                n14 = 7;
                                break;
                            }
                            case 1: {
                                n14 = 114;
                                break;
                            }
                            case 2: {
                                n14 = 66;
                                break;
                            }
                            case 3: {
                                n14 = 58;
                                break;
                            }
                            default: {
                                n14 = 74;
                            }
                        }
                        cArray2[n15] = (char)(c5 ^ n14);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[3] = new String(cArray2).intern();
                var0 = null;
                char[] cArray10 = "R\u001c'B:b\u00116_.'\u0004#V?bHb".toCharArray();
                cArray = cArray10;
                n2 = cArray10.length;
                n3 = 0;
                if (!true) break block48;
                n2 = n2;
                if (n2 <= n3) break block49;
            }
            do {
                int n16;
                cArray = cArray;
                int n17 = n3;
                char c6 = cArray[n17];
                switch (n3 % 5) {
                    case 0: {
                        n16 = 7;
                        break;
                    }
                    case 1: {
                        n16 = 114;
                        break;
                    }
                    case 2: {
                        n16 = 66;
                        break;
                    }
                    case 3: {
                        n16 = 58;
                        break;
                    }
                    default: {
                        n16 = 74;
                    }
                }
                cArray[n17] = (char)(c6 ^ n16);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[4] = new String(cArray).intern();
        z = stringArray;
    }
}

