/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public final class RSAKeyFactory
extends KeyFactorySpi {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean a;
    private static String[] z;

    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[6] + n3 + z[4]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[7] + n5 + z[5]);
        }
        if (a && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[8]);
        }
    }

    static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[1] + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[1] + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(z[10]);
                Class<?> clazz3 = Class.forName(z[14]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[0]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(z[11]);
                Class<?> clazz5 = Class.forName(z[15]);
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[0]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(z[12]);
                Class<?> clazz7 = Class.forName(z[15]);
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[0]);
            }
            throw new InvalidKeySpecException(z[9]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[13] + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, RSAPublicKeySpec.class);
                return this.engineGeneratePublic(rSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateCrtKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateCrtKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            throw new InvalidKeyException(z[2]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[3] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block179: {
            int n2;
            int n3;
            block178: {
                char[] cArray2;
                Object var0;
                block177: {
                    int n4;
                    block176: {
                        char[] cArray3;
                        block175: {
                            int n5;
                            block174: {
                                char[] cArray4;
                                block173: {
                                    int n6;
                                    block172: {
                                        char[] cArray5;
                                        block171: {
                                            int n7;
                                            block170: {
                                                char[] cArray6;
                                                block169: {
                                                    int n8;
                                                    block168: {
                                                        char[] cArray7;
                                                        block167: {
                                                            int n9;
                                                            block166: {
                                                                char[] cArray8;
                                                                block165: {
                                                                    int n10;
                                                                    block164: {
                                                                        char[] cArray9;
                                                                        block163: {
                                                                            int n11;
                                                                            block162: {
                                                                                char[] cArray10;
                                                                                block161: {
                                                                                    int n12;
                                                                                    block160: {
                                                                                        char[] cArray11;
                                                                                        block159: {
                                                                                            int n13;
                                                                                            block158: {
                                                                                                char[] cArray12;
                                                                                                block157: {
                                                                                                    int n14;
                                                                                                    block156: {
                                                                                                        char[] cArray13;
                                                                                                        block155: {
                                                                                                            int n15;
                                                                                                            block154: {
                                                                                                                char[] cArray14;
                                                                                                                block153: {
                                                                                                                    int n16;
                                                                                                                    block152: {
                                                                                                                        char[] cArray15;
                                                                                                                        block151: {
                                                                                                                            int n17;
                                                                                                                            block150: {
                                                                                                                                char[] cArray16;
                                                                                                                                block149: {
                                                                                                                                    int n18;
                                                                                                                                    block148: {
                                                                                                                                        char[] cArray17;
                                                                                                                                        block147: {
                                                                                                                                            int n19;
                                                                                                                                            block146: {
                                                                                                                                                char[] cArray18;
                                                                                                                                                block145: {
                                                                                                                                                    int n20;
                                                                                                                                                    block144: {
                                                                                                                                                        stringArray = new String[18];
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray19 = "]z\n{,f{\u001by5u`\u000e+7qmKx,qw\u0002m5wu\u001fb3z".toCharArray();
                                                                                                                                                        cArray18 = cArray19;
                                                                                                                                                        n20 = cArray19.length;
                                                                                                                                                        n3 = 0;
                                                                                                                                                        if (!true) break block144;
                                                                                                                                                        n20 = n20;
                                                                                                                                                        if (n20 <= n3) break block145;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        int n21;
                                                                                                                                                        cArray18 = cArray18;
                                                                                                                                                        int n22 = n3;
                                                                                                                                                        char c2 = cArray18[n22];
                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                            case 0: {
                                                                                                                                                                n21 = 20;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 1: {
                                                                                                                                                                n21 = 20;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 2: {
                                                                                                                                                                n21 = 107;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 3: {
                                                                                                                                                                n21 = 11;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            default: {
                                                                                                                                                                n21 = 92;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                        cArray18[n22] = (char)(c2 ^ n21);
                                                                                                                                                        ++n3;
                                                                                                                                                        n20 = n20;
                                                                                                                                                    } while (n20 > n3);
                                                                                                                                                }
                                                                                                                                                stringArray[0] = new String(cArray18).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray20 = "]z\n{,f{\u001by5u`\u000e+7qmKx,qw\u0002m5wu\u001fb3z.K".toCharArray();
                                                                                                                                                cArray17 = cArray20;
                                                                                                                                                n19 = cArray20.length;
                                                                                                                                                n3 = 0;
                                                                                                                                                if (!true) break block146;
                                                                                                                                                n19 = n19;
                                                                                                                                                if (n19 <= n3) break block147;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                int n23;
                                                                                                                                                cArray17 = cArray17;
                                                                                                                                                int n24 = n3;
                                                                                                                                                char c3 = cArray17[n24];
                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                    case 0: {
                                                                                                                                                        n23 = 20;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 1: {
                                                                                                                                                        n23 = 20;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 2: {
                                                                                                                                                        n23 = 107;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 3: {
                                                                                                                                                        n23 = 11;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    default: {
                                                                                                                                                        n23 = 92;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                cArray17[n24] = (char)(c3 ^ n23);
                                                                                                                                                ++n3;
                                                                                                                                                n19 = n19;
                                                                                                                                            } while (n19 > n3);
                                                                                                                                        }
                                                                                                                                        stringArray[1] = new String(cArray17).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray21 = "Cf\u0004e;4u\u0007l3f}\u001fc14`\u0012{9".toCharArray();
                                                                                                                                        cArray16 = cArray21;
                                                                                                                                        n18 = cArray21.length;
                                                                                                                                        n3 = 0;
                                                                                                                                        if (!true) break block148;
                                                                                                                                        n18 = n18;
                                                                                                                                        if (n18 <= n3) break block149;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        int n25;
                                                                                                                                        cArray16 = cArray16;
                                                                                                                                        int n26 = n3;
                                                                                                                                        char c4 = cArray16[n26];
                                                                                                                                        switch (n3 % 5) {
                                                                                                                                            case 0: {
                                                                                                                                                n25 = 20;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 1: {
                                                                                                                                                n25 = 20;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 2: {
                                                                                                                                                n25 = 107;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 3: {
                                                                                                                                                n25 = 11;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                n25 = 92;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        cArray16[n26] = (char)(c4 ^ n25);
                                                                                                                                        ++n3;
                                                                                                                                        n18 = n18;
                                                                                                                                    } while (n18 > n3);
                                                                                                                                }
                                                                                                                                stringArray[2] = new String(cArray16).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray22 = "Wu\u0005e3`4\u001fy=zg\u0007j(q4\u0000n%.4".toCharArray();
                                                                                                                                cArray15 = cArray22;
                                                                                                                                n17 = cArray22.length;
                                                                                                                                n3 = 0;
                                                                                                                                if (!true) break block150;
                                                                                                                                n17 = n17;
                                                                                                                                if (n17 <= n3) break block151;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                int n27;
                                                                                                                                cArray15 = cArray15;
                                                                                                                                int n28 = n3;
                                                                                                                                char c5 = cArray15[n28];
                                                                                                                                switch (n3 % 5) {
                                                                                                                                    case 0: {
                                                                                                                                        n27 = 20;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 1: {
                                                                                                                                        n27 = 20;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 2: {
                                                                                                                                        n27 = 107;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 3: {
                                                                                                                                        n27 = 11;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    default: {
                                                                                                                                        n27 = 92;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                cArray15[n28] = (char)(c5 ^ n27);
                                                                                                                                ++n3;
                                                                                                                                n17 = n17;
                                                                                                                            } while (n17 > n3);
                                                                                                                        }
                                                                                                                        stringArray[3] = new String(cArray15).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray23 = "4v\u0002\u007f/4x\u0004e;".toCharArray();
                                                                                                                        cArray14 = cArray23;
                                                                                                                        n16 = cArray23.length;
                                                                                                                        n3 = 0;
                                                                                                                        if (!true) break block152;
                                                                                                                        n16 = n16;
                                                                                                                        if (n16 <= n3) break block153;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        int n29;
                                                                                                                        cArray14 = cArray14;
                                                                                                                        int n30 = n3;
                                                                                                                        char c6 = cArray14[n30];
                                                                                                                        switch (n3 % 5) {
                                                                                                                            case 0: {
                                                                                                                                n29 = 20;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                n29 = 20;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 2: {
                                                                                                                                n29 = 107;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 3: {
                                                                                                                                n29 = 11;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            default: {
                                                                                                                                n29 = 92;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        cArray14[n30] = (char)(c6 ^ n29);
                                                                                                                        ++n3;
                                                                                                                        n16 = n16;
                                                                                                                    } while (n16 > n3);
                                                                                                                }
                                                                                                                stringArray[4] = new String(cArray14).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray24 = "4v\u0002\u007f/".toCharArray();
                                                                                                                cArray13 = cArray24;
                                                                                                                n15 = cArray24.length;
                                                                                                                n3 = 0;
                                                                                                                if (!true) break block154;
                                                                                                                n15 = n15;
                                                                                                                if (n15 <= n3) break block155;
                                                                                                            }
                                                                                                            do {
                                                                                                                int n31;
                                                                                                                cArray13 = cArray13;
                                                                                                                int n32 = n3;
                                                                                                                char c7 = cArray13[n32];
                                                                                                                switch (n3 % 5) {
                                                                                                                    case 0: {
                                                                                                                        n31 = 20;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 1: {
                                                                                                                        n31 = 20;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        n31 = 107;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3: {
                                                                                                                        n31 = 11;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        n31 = 92;
                                                                                                                    }
                                                                                                                }
                                                                                                                cArray13[n32] = (char)(c7 ^ n31);
                                                                                                                ++n3;
                                                                                                                n15 = n15;
                                                                                                            } while (n15 > n3);
                                                                                                        }
                                                                                                        stringArray[5] = new String(cArray13).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray25 = "FG*+7qm\u0018+1ag\u001f+>q4\n\u007f|xq\nx(4".toCharArray();
                                                                                                        cArray12 = cArray25;
                                                                                                        n14 = cArray25.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block156;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block157;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n33;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n34 = n3;
                                                                                                        char c8 = cArray12[n34];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n33 = 20;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n33 = 20;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n33 = 107;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n33 = 11;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n33 = 92;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n34] = (char)(c8 ^ n33);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[6] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray26 = "FG*+7qm\u0018+1ag\u001f+>q4\u0005d|x{\u0005l9f4\u001fc=z4".toCharArray();
                                                                                                cArray11 = cArray26;
                                                                                                n13 = cArray26.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block158;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block159;
                                                                                            }
                                                                                            do {
                                                                                                int n35;
                                                                                                cArray11 = cArray11;
                                                                                                int n36 = n3;
                                                                                                char c9 = cArray11[n36];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n35 = 20;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n35 = 20;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n35 = 107;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n35 = 11;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n35 = 92;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n36] = (char)(c9 ^ n35);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[7] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray27 = "FG*+9ld\u0004e9z`\u0018+?uzKi94z\u0004+0{z\fn.4`\u0003j24\"_+>}`\u0018+|}rKf3pa\u0007~/4}\u0018+;fq\n\u007f9f4\u001fc=z4X;k&4\tb(g".toCharArray();
                                                                                        cArray10 = cArray27;
                                                                                        n12 = cArray27.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block160;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block161;
                                                                                    }
                                                                                    do {
                                                                                        int n37;
                                                                                        cArray10 = cArray10;
                                                                                        int n38 = n3;
                                                                                        char c10 = cArray10[n38];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n37 = 20;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n37 = 20;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n37 = 107;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n37 = 11;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n37 = 92;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n38] = (char)(c10 ^ n37);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[8] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray28 = "]z\n{,f{\u001by5u`\u000e+7qmK\u007f%dq".toCharArray();
                                                                                cArray9 = cArray28;
                                                                                n11 = cArray28.length;
                                                                                n3 = 0;
                                                                                if (!true) break block162;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block163;
                                                                            }
                                                                            do {
                                                                                int n39;
                                                                                cArray9 = cArray9;
                                                                                int n40 = n3;
                                                                                char c11 = cArray9[n40];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n39 = 20;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n39 = 20;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n39 = 107;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n39 = 11;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n39 = 92;
                                                                                    }
                                                                                }
                                                                                cArray9[n40] = (char)(c11 ^ n39);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[9] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray29 = "~u\u001djrgq\b~.}`\u0012%/dq\b%\u000eGU;~>x}\b@9mG\u001bn?".toCharArray();
                                                                        cArray8 = cArray29;
                                                                        n10 = cArray29.length;
                                                                        n3 = 0;
                                                                        if (!true) break block164;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block165;
                                                                    }
                                                                    do {
                                                                        int n41;
                                                                        cArray8 = cArray8;
                                                                        int n42 = n3;
                                                                        char c12 = cArray8[n42];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n41 = 20;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n41 = 20;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n41 = 107;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n41 = 11;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n41 = 92;
                                                                            }
                                                                        }
                                                                        cArray8[n42] = (char)(c12 ^ n41);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[10] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray30 = "~u\u001djrgq\b~.}`\u0012%/dq\b%\u000eGU;y5bu\u001fn\u001ff` n%Gd\u000eh".toCharArray();
                                                                cArray7 = cArray30;
                                                                n9 = cArray30.length;
                                                                n3 = 0;
                                                                if (!true) break block166;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block167;
                                                            }
                                                            do {
                                                                int n43;
                                                                cArray7 = cArray7;
                                                                int n44 = n3;
                                                                char c13 = cArray7[n44];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n43 = 20;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n43 = 20;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n43 = 107;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n43 = 11;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n43 = 92;
                                                                    }
                                                                }
                                                                cArray7[n44] = (char)(c13 ^ n43);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[11] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray31 = "~u\u001djrgq\b~.}`\u0012%/dq\b%\u000eGU;y5bu\u001fn\u0017qm8{9w".toCharArray();
                                                        cArray6 = cArray31;
                                                        n8 = cArray31.length;
                                                        n3 = 0;
                                                        if (!true) break block168;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block169;
                                                    }
                                                    do {
                                                        int n45;
                                                        cArray6 = cArray6;
                                                        int n46 = n3;
                                                        char c14 = cArray6[n46];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n45 = 20;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n45 = 20;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n45 = 107;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n45 = 11;
                                                                break;
                                                            }
                                                            default: {
                                                                n45 = 92;
                                                            }
                                                        }
                                                        cArray6[n46] = (char)(c14 ^ n45);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[12] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray32 = "Az\u0018~,d{\u0019\u007f9p4\u0000n%4g\u001bn?}r\u0002h=`}\u0004ef4".toCharArray();
                                                cArray5 = cArray32;
                                                n7 = cArray32.length;
                                                n3 = 0;
                                                if (!true) break block170;
                                                n7 = n7;
                                                if (n7 <= n3) break block171;
                                            }
                                            do {
                                                int n47;
                                                cArray5 = cArray5;
                                                int n48 = n3;
                                                char c15 = cArray5[n48];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n47 = 20;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n47 = 20;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n47 = 107;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n47 = 11;
                                                        break;
                                                    }
                                                    default: {
                                                        n47 = 92;
                                                    }
                                                }
                                                cArray5[n48] = (char)(c15 ^ n47);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[13] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray33 = "~u\u001djrgq\b~.}`\u0012%/dq\b%\u0004!$RN2w{\u000fn8_q\u0012X,qw".toCharArray();
                                        cArray4 = cArray33;
                                        n6 = cArray33.length;
                                        n3 = 0;
                                        if (!true) break block172;
                                        n6 = n6;
                                        if (n6 <= n3) break block173;
                                    }
                                    do {
                                        int n49;
                                        cArray4 = cArray4;
                                        int n50 = n3;
                                        char c16 = cArray4[n50];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n49 = 20;
                                                break;
                                            }
                                            case 1: {
                                                n49 = 20;
                                                break;
                                            }
                                            case 2: {
                                                n49 = 107;
                                                break;
                                            }
                                            case 3: {
                                                n49 = 11;
                                                break;
                                            }
                                            default: {
                                                n49 = 92;
                                            }
                                        }
                                        cArray4[n50] = (char)(c16 ^ n49);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[14] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray34 = "~u\u001djrgq\b~.}`\u0012%/dq\b%\f_W83\u0019zw\u0004o9p_\u000er\u000fdq\b".toCharArray();
                                cArray3 = cArray34;
                                n5 = cArray34.length;
                                n3 = 0;
                                if (!true) break block174;
                                n5 = n5;
                                if (n5 <= n3) break block175;
                            }
                            do {
                                int n51;
                                cArray3 = cArray3;
                                int n52 = n3;
                                char c17 = cArray3[n52];
                                switch (n3 % 5) {
                                    case 0: {
                                        n51 = 20;
                                        break;
                                    }
                                    case 1: {
                                        n51 = 20;
                                        break;
                                    }
                                    case 2: {
                                        n51 = 107;
                                        break;
                                    }
                                    case 3: {
                                        n51 = 11;
                                        break;
                                    }
                                    default: {
                                        n51 = 92;
                                    }
                                }
                                cArray3[n52] = (char)(c17 ^ n51);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[15] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray35 = "`f\u001en".toCharArray();
                        cArray2 = cArray35;
                        n4 = cArray35.length;
                        n3 = 0;
                        if (!true) break block176;
                        n4 = n4;
                        if (n4 <= n3) break block177;
                    }
                    do {
                        int n53;
                        cArray2 = cArray2;
                        int n54 = n3;
                        char c18 = cArray2[n54];
                        switch (n3 % 5) {
                            case 0: {
                                n53 = 20;
                                break;
                            }
                            case 1: {
                                n53 = 20;
                                break;
                            }
                            case 2: {
                                n53 = 107;
                                break;
                            }
                            case 3: {
                                n53 = 11;
                                break;
                            }
                            default: {
                                n53 = 92;
                            }
                        }
                        cArray2[n54] = (char)(c18 ^ n53);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[16] = new String(cArray2).intern();
                var0 = null;
                char[] cArray36 = "w{\u0006%5vyEh.md\u001fdrdf\u0004}5pq\u0019%.qg\u001fy5w`9X\u001dQl\u001bd2qz\u001f".toCharArray();
                cArray = cArray36;
                n2 = cArray36.length;
                n3 = 0;
                if (!true) break block178;
                n2 = n2;
                if (n2 <= n3) break block179;
            }
            do {
                int n55;
                cArray = cArray;
                int n56 = n3;
                char c19 = cArray[n56];
                switch (n3 % 5) {
                    case 0: {
                        n55 = 20;
                        break;
                    }
                    case 1: {
                        n55 = 20;
                        break;
                    }
                    case 2: {
                        n55 = 107;
                        break;
                    }
                    case 3: {
                        n55 = 11;
                        break;
                    }
                    default: {
                        n55 = 92;
                    }
                }
                cArray[n56] = (char)(c19 ^ n55);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[17] = new String(cArray).intern();
        z = stringArray;
        a = z[16].equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[17], z[16])));
    }
}

