/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    private int b = 1024;
    SecureRandom c = null;
    private static String[] z;

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[5]);
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        int n2 = rSAKeyGenParameterSpec.getKeysize();
        this.a = rSAKeyGenParameterSpec.getPublicExponent();
        this.c = secureRandom;
        if (n2 % 8 != 0) {
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        try {
            RSAKeyFactory.checkKeyLengths(n2, this.a, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException(z[1], invalidKeyException);
        }
        this.b = n2;
        if (this.a == null) {
            this.a = RSAKeyGenParameterSpec.F4;
        } else {
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[4]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[3]);
            }
        }
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[2]);
        }
        try {
            RSAKeyFactory.checkKeyLengths(n2, RSAKeyGenParameterSpec.F4, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(invalidKeyException.getMessage());
        }
        this.b = n2;
        this.c = secureRandom;
        this.a = RSAKeyGenParameterSpec.F4;
    }

    public void initialize(int n2) {
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[2]);
        }
        this.b = n2;
        try {
            this.c = SecureRandom.getInstance(z[0]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.c = new SecureRandom();
        }
        this.a = RSAKeyGenParameterSpec.F4;
        try {
            RSAKeyFactory.checkKeyLengths(this.b, this.a, 512, 65536);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(z[1]);
        }
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        int n2;
        if (this.c == null) {
            this.c = null;
            try {
                this.c = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.c = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger6 = (bigInteger5 = new BigInteger(this.b / 2, 10, this.c)).multiply(bigInteger4 = new BigInteger(this.b / 2, 10, this.c))).bitLength()) != this.b || !bigInteger7.gcd(bigInteger3 = (bigInteger2 = bigInteger5.subtract(BigInteger.ONE)).multiply(bigInteger = bigInteger4.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger);
        BigInteger bigInteger11 = bigInteger4.modInverse(bigInteger5);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger6, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger6, bigInteger8, bigInteger7, bigInteger5, bigInteger4, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block59: {
            int n2;
            int n3;
            block58: {
                char[] cArray2;
                Object var0;
                block57: {
                    int n4;
                    block56: {
                        char[] cArray3;
                        block55: {
                            int n5;
                            block54: {
                                char[] cArray4;
                                block53: {
                                    int n6;
                                    block52: {
                                        char[] cArray5;
                                        block51: {
                                            int n7;
                                            block50: {
                                                char[] cArray6;
                                                block49: {
                                                    int n8;
                                                    block48: {
                                                        stringArray = new String[6];
                                                        var0 = null;
                                                        char[] cArray7 = "@@\r5>jw2\u0003\thl$\t6".toCharArray();
                                                        cArray6 = cArray7;
                                                        n8 = cArray7.length;
                                                        n3 = 0;
                                                        if (!true) break block48;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block49;
                                                    }
                                                    do {
                                                        int n9;
                                                        cArray6 = cArray6;
                                                        int n10 = n3;
                                                        char c2 = cArray6[n10];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n9 = 9;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n9 = 2;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n9 = 64;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n9 = 102;
                                                                break;
                                                            }
                                                            default: {
                                                                n9 = 91;
                                                            }
                                                        }
                                                        cArray6[n10] = (char)(c2 ^ n9);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[0] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray8 = "@l6\u00077`f`\r>p\"3\u000f!lq".toCharArray();
                                                cArray5 = cArray8;
                                                n7 = cArray8.length;
                                                n3 = 0;
                                                if (!true) break block50;
                                                n7 = n7;
                                                if (n7 <= n3) break block51;
                                            }
                                            do {
                                                int n11;
                                                cArray5 = cArray5;
                                                int n12 = n3;
                                                char c3 = cArray5[n12];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n11 = 9;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n11 = 2;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n11 = 64;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n11 = 102;
                                                        break;
                                                    }
                                                    default: {
                                                        n11 = 91;
                                                    }
                                                }
                                                cArray5[n12] = (char)(c3 ^ n11);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[1] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray9 = "Dm$\u00137|q`\u00152sg`\u000b.zv`\u0004>)o5\n/`r,\u0003{fd`^".toCharArray();
                                        cArray4 = cArray9;
                                        n6 = cArray9.length;
                                        n3 = 0;
                                        if (!true) break block52;
                                        n6 = n6;
                                        if (n6 <= n3) break block53;
                                    }
                                    do {
                                        int n13;
                                        cArray4 = cArray4;
                                        int n14 = n3;
                                        char c4 = cArray4[n14];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n13 = 9;
                                                break;
                                            }
                                            case 1: {
                                                n13 = 2;
                                                break;
                                            }
                                            case 2: {
                                                n13 = 64;
                                                break;
                                            }
                                            case 3: {
                                                n13 = 102;
                                                break;
                                            }
                                            default: {
                                                n13 = 91;
                                            }
                                        }
                                        cArray4[n14] = (char)(c4 ^ n13);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[2] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray10 = "Yw\"\n2j\"%\u001e+fl%\b/)o5\u0015/)`%F(dc,\n>{\"4\u000e:g\"+\u0003\")q)\u001c>".toCharArray();
                                cArray3 = cArray10;
                                n5 = cArray10.length;
                                n3 = 0;
                                if (!true) break block54;
                                n5 = n5;
                                if (n5 <= n3) break block55;
                            }
                            do {
                                int n15;
                                cArray3 = cArray3;
                                int n16 = n3;
                                char c5 = cArray3[n16];
                                switch (n3 % 5) {
                                    case 0: {
                                        n15 = 9;
                                        break;
                                    }
                                    case 1: {
                                        n15 = 2;
                                        break;
                                    }
                                    case 2: {
                                        n15 = 64;
                                        break;
                                    }
                                    case 3: {
                                        n15 = 102;
                                        break;
                                    }
                                    default: {
                                        n15 = 91;
                                    }
                                }
                                cArray3[n16] = (char)(c5 ^ n15);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[3] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray11 = "Yw\"\n2j\"%\u001e+fl%\b/)o5\u0015/)`%Fh)m2F7hp'\u0003)".toCharArray();
                        cArray2 = cArray11;
                        n4 = cArray11.length;
                        n3 = 0;
                        if (!true) break block56;
                        n4 = n4;
                        if (n4 <= n3) break block57;
                    }
                    do {
                        int n17;
                        cArray2 = cArray2;
                        int n18 = n3;
                        char c6 = cArray2[n18];
                        switch (n3 % 5) {
                            case 0: {
                                n17 = 9;
                                break;
                            }
                            case 1: {
                                n17 = 2;
                                break;
                            }
                            case 2: {
                                n17 = 64;
                                break;
                            }
                            case 3: {
                                n17 = 102;
                                break;
                            }
                            default: {
                                n17 = 91;
                            }
                        }
                        cArray2[n18] = (char)(c6 ^ n17);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[4] = new String(cArray2).intern();
                var0 = null;
                char[] cArray12 = "Yc2\u00076z\"-\u0013(}\"\"\u0003{`l3\u0012:ga%F4o\"\u00125\u001aBg9!>gR!\u0014:dg4\u0003)Zr%\u0005".toCharArray();
                cArray = cArray12;
                n2 = cArray12.length;
                n3 = 0;
                if (!true) break block58;
                n2 = n2;
                if (n2 <= n3) break block59;
            }
            do {
                int n19;
                cArray = cArray;
                int n20 = n3;
                char c7 = cArray[n20];
                switch (n3 % 5) {
                    case 0: {
                        n19 = 9;
                        break;
                    }
                    case 1: {
                        n19 = 2;
                        break;
                    }
                    case 2: {
                        n19 = 64;
                        break;
                    }
                    case 3: {
                        n19 = 102;
                        break;
                    }
                    default: {
                        n19 = 91;
                    }
                }
                cArray[n20] = (char)(c7 ^ n19);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[5] = new String(cArray).intern();
        z = stringArray;
    }
}

