/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ClassLoaderGateway
implements ExtClassLoader.Gateway {
    private static final ClassLoaderGateway instance;
    private Bundle gatewayBundle = null;
    private static TreeSet specialCaseResources;
    public static final String GATEWAY_BUNDLE_SYMBOLIC_NAME = "com.ibm.ws.runtime.gateway";
    private static final String SYSTEM_BUNDLE_SYMBOLIC_NAME = "system.bundle";

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = null;
        if (this.gatewayBundle != null) {
            try {
                Class clazz = this.gatewayBundle.loadClass("com.ibm.ws.gateway.GatewayBundleActivator");
                classLoader = clazz.getClassLoader();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classLoader;
    }

    private ClassLoaderGateway() {
        try {
            this.gatewayBundle = Platform.getBundle((String)GATEWAY_BUNDLE_SYMBOLIC_NAME);
            if (this.gatewayBundle != null && this.gatewayBundle.getState() != 32) {
                this.gatewayBundle.start();
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    public static final ClassLoaderGateway instance() {
        return instance;
    }

    private Bundle[] getBundles() {
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        if (bundleContext != null) {
            return bundleContext.getBundles();
        }
        return new Bundle[0];
    }

    public Class loadClass(final String string) {
        Class clazz = null;
        if (this.gatewayBundle != null) {
            clazz = (Class)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        return ClassLoaderGateway.this.gatewayBundle.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
        }
        return clazz;
    }

    private boolean checkSpecialCases(String string) {
        return specialCaseResources.contains(string);
    }

    public URL findResource(final String string) {
        URL uRL = null;
        boolean bl = this.checkSpecialCases(string);
        if (bl) {
            uRL = (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Bundle[] bundleArray = ClassLoaderGateway.this.getBundles();
                    for (int i = 0; i < bundleArray.length; ++i) {
                        URL uRL;
                        Bundle bundle = bundleArray[i];
                        if (bundle == ClassLoaderGateway.this.gatewayBundle || bundle.getSymbolicName().equals(ClassLoaderGateway.SYSTEM_BUNDLE_SYMBOLIC_NAME) || !(bundle.getState() == 32 ? (uRL = bundle.getResource(string)) != null : (uRL = bundle.getEntry(string)) != null)) continue;
                        return uRL;
                    }
                    return null;
                }
            });
        }
        return uRL;
    }

    public URL[] findResources(final String string) throws IOException {
        ArrayList arrayList = new ArrayList();
        boolean bl = this.checkSpecialCases(string);
        if (bl) {
            arrayList = (ArrayList)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    ArrayList arrayList = new ArrayList();
                    Bundle[] bundleArray = ClassLoaderGateway.this.getBundles();
                    for (int i = 0; i < bundleArray.length; ++i) {
                        Bundle bundle = bundleArray[i];
                        if (bundle == ClassLoaderGateway.this.gatewayBundle || bundle.getSymbolicName().equals(ClassLoaderGateway.SYSTEM_BUNDLE_SYMBOLIC_NAME)) continue;
                        Enumeration enumeration = null;
                        if (bundle.getState() == 32) {
                            try {
                                enumeration = bundle.getResources(string);
                            }
                            catch (Exception exception) {}
                        } else {
                            URL uRL = bundle.getEntry(string);
                            if (uRL != null) {
                                try {
                                    enumeration = bundle.getResources(string);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        if (enumeration == null) continue;
                        while (enumeration.hasMoreElements()) {
                            arrayList.add(enumeration.nextElement());
                        }
                    }
                    return arrayList;
                }
            });
        }
        URL[] uRLArray = new URL[arrayList.size()];
        return arrayList.toArray(uRLArray);
    }

    static {
        IExtension[] iExtensionArray;
        String string;
        IExtensionPoint iExtensionPoint;
        specialCaseResources = new TreeSet();
        instance = new ClassLoaderGateway();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry != null && (iExtensionPoint = iExtensionRegistry.getExtensionPoint(string = "com.ibm.ws.bootstrap.resource-file")) != null && (iExtensionArray = iExtensionPoint.getExtensions()) != null) {
            for (int i = 0; i < iExtensionArray.length; ++i) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                String string2 = iConfigurationElementArray[0].getAttribute("name");
                specialCaseResources.add(string2);
            }
        }
    }
}

