/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.ConfigurationElement;
import com.ibm.ws.extension.thinregistry.ConfigurationProperty;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionPoint;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler {
    private static final String srcClass = "PluginParser";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_REQUIRES_STATE = 3;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 4;
    private static final int PLUGIN_EXTENSION_STATE = 5;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 7;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private String _locationName;
    private Stack _stateStack;
    private Stack _objectStack;
    private static SAXParser _saxParser;
    private static XMLReader _xmlReader;
    private Locator _locator;
    private Vector[] _scratchVectors;
    private int _autoGenId;

    public PluginParser() {
        block4: {
            this._locationName = null;
            this._stateStack = new Stack();
            this._objectStack = new Stack();
            this._locator = null;
            this._scratchVectors = new Vector[2];
            this._autoGenId = 0;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(false);
                _saxParser = sAXParserFactory.newSAXParser();
                _xmlReader = _saxParser.getXMLReader();
                try {
                    _xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                _xmlReader.setEntityResolver(this);
                _xmlReader.setContentHandler(this);
                _xmlReader.setDTDHandler(this);
                _xmlReader.setErrorHandler(this);
            }
            catch (Exception exception) {
                if (!LoggingServices.debugEnabled) break block4;
                LoggingServices.trace((String)("Exception " + exception));
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = (Integer)this._stateStack.peek();
        if (n3 != 7) {
            return;
        }
        if (n3 == 7) {
            ConfigurationElement configurationElement = (ConfigurationElement)this._objectStack.peek();
            String string = new String(cArray, n, n2);
            String string2 = configurationElement.getValue();
            if (string2 == null) {
                if (string.trim().length() != 0) {
                    configurationElement.setValue(string);
                }
            } else {
                configurationElement.setValue(string2 + string);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String string, String string2, String string3) {
        String string4 = "endElement";
        switch ((Integer)this._stateStack.peek()) {
            case 0: {
                this._stateStack.pop();
                break;
            }
            case 1: {
                if (!LoggingServices.debugEnabled) break;
                LoggingServices.trace((String)"registry.error.internal_stack_error", (Object[])new Object[]{string, string3});
                break;
            }
            case 2: {
                Vector vector;
                if (!string3.equals("plugin")) break;
                this._stateStack.pop();
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
                Vector vector2 = this._scratchVectors[0];
                if (vector2.size() > 0) {
                    pluginDescriptor.setExtensionPoints(vector2);
                    this._scratchVectors[0].removeAllElements();
                }
                if ((vector = this._scratchVectors[1]).size() <= 0) break;
                pluginDescriptor.setExtensions(vector);
                this._scratchVectors[1].removeAllElements();
                break;
            }
            case 3: {
                if (!string3.equals("requires")) break;
                this._stateStack.pop();
                Vector vector = (Vector)this._objectStack.pop();
                if (vector.size() <= 0) break;
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
                break;
            }
            case 4: {
                if (!string3.equals("extension-point")) break;
                this._stateStack.pop();
                break;
            }
            case 5: {
                Object object;
                if (!string3.equals("extension")) break;
                this._stateStack.pop();
                Extension extension = (Extension)this._objectStack.pop();
                if (extension.getSimpleIdentifier() == null) {
                    object = new StringBuffer("ibmautogeneratedidentifier");
                    ((StringBuffer)object).append(Integer.toString(++this._autoGenId));
                    extension.setSimpleIdentifier(((StringBuffer)object).toString());
                }
                object = (PluginDescriptor)this._objectStack.peek();
                extension.setParentDescriptor((PluginDescriptor)object);
                this._scratchVectors[1].addElement(extension);
                break;
            }
            case 6: {
                if (!string3.equals("import")) break;
                this._stateStack.pop();
                break;
            }
            case 7: {
                this._stateStack.pop();
                ConfigurationElement configurationElement = (ConfigurationElement)this._objectStack.pop();
                String string5 = configurationElement.getValue();
                if (string5 != null) {
                    configurationElement.setValue(string5.trim());
                }
                Object e = this._objectStack.peek();
                configurationElement.setParent(e);
                if ((Integer)this._stateStack.peek() == 5) {
                    ConfigurationElement[] configurationElementArray = ((Extension)e).getElements();
                    int n = configurationElementArray == null ? 0 : configurationElementArray.length;
                    ConfigurationElement[] configurationElementArray2 = new ConfigurationElement[n + 1];
                    for (int i = 0; i < n; ++i) {
                        configurationElementArray2[i] = configurationElementArray[i];
                    }
                    configurationElementArray2[n] = configurationElement;
                    ((Extension)e).setElements(configurationElementArray2);
                    break;
                }
                ConfigurationElement[] configurationElementArray = ((ConfigurationElement)e).getSubElements();
                int n = configurationElementArray == null ? 0 : configurationElementArray.length;
                ConfigurationElement[] configurationElementArray3 = new ConfigurationElement[n + 1];
                for (int i = 0; i < n; ++i) {
                    configurationElementArray3[i] = configurationElementArray[i];
                }
                configurationElementArray3[n] = configurationElement;
                ((ConfigurationElement)e).setSubElements(configurationElementArray3);
            }
        }
    }

    public void error(SAXParseException sAXParseException) {
        if (!sAXParseException.getMessage().startsWith("Element type") && !sAXParseException.getMessage().endsWith("must be declared") && LoggingServices.debugEnabled) {
            LoggingServices.trace((String)"registry.error.parse_error", (Object[])new Object[]{sAXParseException.getSystemId(), new Integer(sAXParseException.getLineNumber())});
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace((String)"registry.error.parse_error", (Object[])new Object[]{sAXParseException.getSystemId(), new Integer(sAXParseException.getLineNumber())});
        }
    }

    public void handleExtensionPointState(String string, Attributes attributes) {
        this._stateStack.push(new Integer(0));
    }

    public void handleExtensionState(String string, Attributes attributes) {
        this._stateStack.push(new Integer(7));
        ConfigurationElement configurationElement = new ConfigurationElement();
        this._objectStack.push(configurationElement);
        configurationElement.setName(string);
        this.parseConfigurationElementAttributes(attributes);
    }

    public void handleInitialState(String string, Attributes attributes) {
        if (string.equals("plugin")) {
            this._stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else {
            this._stateStack.push(new Integer(0));
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace((String)("unknown root element: " + string));
            }
        }
    }

    protected static String[] getArrayFromList(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? null : vector.toArray(new String[0]);
    }

    public void handlePluginState(String string, Attributes attributes) {
        if (string.equals("requires")) {
            this._stateStack.push(new Integer(3));
            this._objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (string.equals("extension-point")) {
            this._stateStack.push(new Integer(4));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (string.equals("extension")) {
            this._stateStack.push(new Integer(5));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this._stateStack.push(new Integer(0));
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace((String)("unknown element: " + string));
        }
    }

    public void handleRequiresImportState(String string, Attributes attributes) {
        this._stateStack.push(new Integer(0));
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace((String)("ignored element: " + string));
        }
    }

    public void handleRequiresState(String string, Attributes attributes) {
        if (string.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this._stateStack.push(new Integer(0));
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace((String)("unknown element: " + string));
        }
    }

    public void ignoreableWhitespace(char[] cArray, int n, int n2) {
    }

    public synchronized PluginDescriptor parsePlugin(InputSource inputSource) {
        PluginDescriptor pluginDescriptor;
        block3: {
            pluginDescriptor = null;
            if (inputSource.getSystemId() != null) {
                this._locationName = inputSource.getSystemId();
            }
            try {
                _xmlReader.parse(inputSource);
                pluginDescriptor = (PluginDescriptor)this._objectStack.pop();
            }
            catch (Exception exception) {
                if (!LoggingServices.debugEnabled) break block3;
                LoggingServices.trace((String)"Exception parsing plugin", (Object)exception);
            }
        }
        return pluginDescriptor;
    }

    public void parseConfigurationElementAttributes(Attributes attributes) {
        int n;
        ConfigurationElement configurationElement = (ConfigurationElement)this._objectStack.peek();
        configurationElement.setStartLine(this._locator.getLineNumber());
        Vector<ConfigurationProperty> vector = null;
        int n2 = n = attributes != null ? attributes.getLength() : 0;
        if (n == 0) {
            return;
        }
        vector = new Vector<ConfigurationProperty>();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            ConfigurationProperty configurationProperty = new ConfigurationProperty();
            configurationProperty.setName(string);
            configurationProperty.setValue(string2);
            vector.addElement(configurationProperty);
        }
        configurationElement.setProperties(vector.toArray(new ConfigurationProperty[vector.size()]));
        vector = null;
    }

    public void parseExtensionAttributes(Attributes attributes) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
        Extension extension = new Extension();
        extension.setStartLine(this._locator.getLineNumber());
        this._objectStack.push(extension);
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("id")) {
                extension.setSimpleIdentifier(string2);
                continue;
            }
            if (string.equals("point")) {
                String string3;
                if (string2.lastIndexOf(46) == -1) {
                    String string4 = pluginDescriptor.getUniqueIdentifier();
                    string3 = string4 + "." + string2;
                } else {
                    string3 = string2;
                }
                extension.setExtensionPointUniqueId(string3);
                continue;
            }
            if (string.equals("name")) {
                extension.setName(string2);
                continue;
            }
            if (!LoggingServices.debugEnabled) continue;
            LoggingServices.trace((String)("unknown attribute: " + string));
        }
    }

    public void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint extensionPoint = new ExtensionPoint();
        extensionPoint.setStartLine(this._locator.getLineNumber());
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("id")) {
                extensionPoint.setSimpleId(string2);
                continue;
            }
            if (string.equals("schema")) {
                extensionPoint.setSchema(string2);
                continue;
            }
            if (string.equals("name")) {
                extensionPoint.setName(string2);
                continue;
            }
            if (!LoggingServices.debugEnabled) continue;
            LoggingServices.trace((String)("unknown attribute: " + string));
        }
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this._objectStack.peek();
        extensionPoint.setParentDescriptor(pluginDescriptor);
        this._scratchVectors[0].addElement(extensionPoint);
    }

    public void parsePluginAttributes(Attributes attributes) {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setStartLine(this._locator.getLineNumber());
        this._objectStack.push(pluginDescriptor);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i).trim();
            if (string.equals("id")) {
                pluginDescriptor.setUniqueIdentifier(string2);
                continue;
            }
            if (string.equals("version")) {
                pluginDescriptor.setVersion(string2);
                continue;
            }
            if (string.equals("provider-name")) {
                pluginDescriptor.setProviderName(string2);
                continue;
            }
            if (string.equals("name")) {
                pluginDescriptor.setName(string2);
                continue;
            }
            if (!LoggingServices.debugEnabled) continue;
            LoggingServices.trace((String)("unknown attribute: " + string));
        }
        if (pluginDescriptor.getUniqueIdentifier() == null && !this.setPluginAttrFromLocation(this._locationName, pluginDescriptor)) {
            StringBuffer stringBuffer = new StringBuffer("ibmautogeneratedidentifier");
            stringBuffer.append(Integer.toString(++this._autoGenId));
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace((String)("Setting plugin ID: " + stringBuffer.toString()));
            }
            pluginDescriptor.setUniqueIdentifier(stringBuffer.toString());
        }
    }

    private boolean setPluginAttrFromLocation(String string, PluginDescriptor pluginDescriptor) {
        boolean bl = false;
        try {
            String string2 = null;
            int n = string.lastIndexOf("/");
            if (n == -1) {
                return bl;
            }
            string2 = string.substring(0, n);
            if ((n = string2.lastIndexOf("/")) == -1) {
                return bl;
            }
            if ((n = (string2 = string2.substring(n + 1)).lastIndexOf("_")) == -1) {
                return bl;
            }
            String string3 = string2.substring(0, n);
            pluginDescriptor.setUniqueIdentifier(string3);
            bl = true;
            if (pluginDescriptor.getVersion() != null) {
                return bl;
            }
            if ((n = (string2 = string2.substring(n + 1)).lastIndexOf(".jar")) != -1) {
                string2 = string2.substring(0, n);
            }
            int n2 = 0;
            n = 0;
            while ((n = string2.indexOf(".", n)) != -1) {
                ++n2;
                ++n;
            }
            if (n2 >= 2) {
                pluginDescriptor.setVersion(string2);
            }
        }
        catch (Exception exception) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace((String)"Exception parsing Location: ", (Object)exception);
            }
            bl = false;
        }
        return bl;
    }

    public void parsePluginRequiresImport(Attributes attributes) {
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    static String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string2.length();
        int n2 = string3.length();
        int n3 = string4.indexOf(string2);
        while (n3 != -1) {
            string4 = string4.substring(0, n3) + string3 + string4.substring(n3 + n);
            n3 = string4.indexOf(string2, n3 + n2);
        }
        return string4;
    }

    public void startDocument() {
        this._stateStack.push(new Integer(1));
        for (int i = 0; i <= 1; ++i) {
            this._scratchVectors[i] = new Vector();
        }
        this._autoGenId = 0;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        switch ((Integer)this._stateStack.peek()) {
            case 1: {
                this.handleInitialState(string3, attributes);
                break;
            }
            case 2: {
                this.handlePluginState(string3, attributes);
                break;
            }
            case 3: {
                this.handleRequiresState(string3, attributes);
                break;
            }
            case 4: {
                this.handleExtensionPointState(string3, attributes);
                break;
            }
            case 5: 
            case 7: {
                this.handleExtensionState(string3, attributes);
                break;
            }
            case 6: {
                this.handleRequiresImportState(string3, attributes);
                break;
            }
            default: {
                this._stateStack.push(new Integer(0));
                if (!LoggingServices.debugEnabled) break;
                LoggingServices.trace((String)("unknown element: " + string3));
            }
        }
    }

    public void warning(SAXParseException sAXParseException) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace((String)"Parser warning: ", (Object)sAXParseException);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    public void releaseParser() {
        _saxParser = null;
    }
}

