/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.bootstrap;

import [Ljava.lang.String;;
import com.ibm.ws.bootstrap.ClassLoaderGateway;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.bootstrap.TimeBomb;
import com.ibm.wsspi.bootstrap.InvocationHandler;
import com.ibm.wsspi.bootstrap.WSPreLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class WSLauncher
implements IPlatformRunnable {
    private static final StopWatch stopwatch = StopWatch.instance();
    private static Object[] handlers = null;
    private static final boolean isZOS;
    private static final boolean overrideZOS;
    private static final boolean isIseries;
    public static final String MANUAL_START_EPID = "com.ibm.ws.bootstrap.manual-bundle-start";

    public Object run(Object object) throws Exception {
        WSLauncher.debug("#######################################################");
        WSLauncher.debug("  WebSphere Bootstrap Bundle V7");
        WSLauncher.debug("#######################################################");
        WSLauncher.main((String[])object);
        return null;
    }

    public static void main(String[] stringArray) {
        stringArray = WSPreLauncher.processArgsOut((String[])stringArray);
        WSLauncher.parseArgs(stringArray);
        WSLauncher.checkTimeBomb(stringArray);
        WSLauncher.createExtClassLoader();
        WSLauncher.launchMain(stringArray);
    }

    private static void createExtClassLoader() {
        ClassLoader classLoader = ClassLoaderGateway.instance().getClassLoader();
        ExtClassLoader extClassLoader = null;
        extClassLoader = classLoader != null ? new ExtClassLoader(System.getProperty("ws.ext.dirs"), classLoader) : new ExtClassLoader(System.getProperty("ws.ext.dirs"));
        extClassLoader.installGateway((ExtClassLoader.Gateway)ClassLoaderGateway.instance());
        Thread.currentThread().setContextClassLoader((ClassLoader)extClassLoader);
    }

    private static void parseArgs(String[] stringArray) {
        if (stringArray.length < 1) {
            LoggingServices.out.println("usage: WSLauncher <className>");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchMain(String[] stringArray) {
        Object object;
        IExtensionPoint iExtensionPoint;
        IConfigurationElement iConfigurationElement;
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        stringArray = stringArray2;
        Class<?> clazz = null;
        WSLauncher.debug("ws.ext.main.class=" + string);
        IExtension iExtension = WSLauncher.getExtension("com.ibm.ws.bootstrap.applications", string);
        IConfigurationElement iConfigurationElement2 = iExtension != null ? WSLauncher.getElement(iExtension.getConfigurationElements(), "application") : null;
        IConfigurationElement iConfigurationElement3 = iConfigurationElement = iConfigurationElement2 != null ? WSLauncher.getElement(iConfigurationElement2.getChildren("run"), "run") : null;
        if (iConfigurationElement != null) {
            try {
                clazz = iConfigurationElement.createExecutableExtension("class").getClass();
            }
            catch (Throwable throwable) {
                WSLauncher.debug("WARNING: Could not locate application: " + iConfigurationElement.getAttribute("class"));
                throwable.printStackTrace(LoggingServices.out);
            }
        }
        if (clazz == null) {
            LoggingServices.trace((String)"WSVR0703W", (Object)string);
            System.exit(-1);
        }
        if ((iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(MANUAL_START_EPID)) != null) {
            object = iExtensionPoint.getExtensions();
            for (int i = 0; i < ((IExtension[])object).length; ++i) {
                String string2 = object[i].getNamespace();
                Bundle bundle = Platform.getBundle((String)string2);
                if (bundle == null || bundle.getState() == 32) continue;
                try {
                    bundle.start();
                    continue;
                }
                catch (BundleException bundleException) {
                    bundleException.printStackTrace();
                }
            }
        }
        object = null;
        Object object2 = null;
        try {
            object = clazz.getMethod("main", String;.class);
            stringArray = WSLauncher.preInvoke(string, stringArray);
            stringArray = WSLauncher.removeProfileName(string, stringArray);
            object2 = ((Method)object).invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            exception.printStackTrace(LoggingServices.out);
        }
        finally {
            WSLauncher.postInvoke();
        }
    }

    private static IExtension getExtension(String string, String string2) {
        IExtension iExtension = null;
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(string);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length && iExtension == null; ++i) {
                if (iExtensionArray[i].getUniqueIdentifier().equals(string2)) {
                    iExtension = iExtensionArray[i];
                    continue;
                }
                WSLauncher.debug("  no match: " + iExtensionArray[i].getUniqueIdentifier());
            }
        }
        WSLauncher.debug("getExtension(epid=" + string + ", uid=" + string2 + ") -> " + iExtension);
        return iExtension;
    }

    private static IConfigurationElement getElement(IConfigurationElement[] iConfigurationElementArray, String string) {
        IConfigurationElement iConfigurationElement = null;
        if (iConfigurationElementArray != null) {
            for (int i = 0; i < iConfigurationElementArray.length && iConfigurationElement == null; ++i) {
                if (!iConfigurationElementArray[i].getName().equals(string)) continue;
                iConfigurationElement = iConfigurationElementArray[i];
            }
        }
        WSLauncher.debug("getElement(list=" + iConfigurationElementArray + ", name=" + string + ") --> " + iConfigurationElement);
        return iConfigurationElement;
    }

    private static void debug(String string) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("[WSLauncher]: " + string);
        }
    }

    private static String[] preInvoke(String string, String[] stringArray) throws Exception {
        Vector vector = new Vector();
        WSLauncher.processBootFile(string, vector);
        handlers = new Object[vector.size()];
        Class[] classArray = new Class[]{String.class, String;.class};
        for (int i = 0; i < handlers.length; ++i) {
            IConfigurationElement iConfigurationElement;
            IExtension iExtension = WSLauncher.getExtension("com.ibm.ws.bootstrap.invocationHandlers", (String)vector.get(i));
            IConfigurationElement iConfigurationElement2 = iConfigurationElement = iExtension != null ? WSLauncher.getElement(iExtension.getConfigurationElements(), "handler") : null;
            if (iConfigurationElement == null) continue;
            try {
                WSLauncher.handlers[i] = iConfigurationElement.createExecutableExtension("class");
                stringArray = ((InvocationHandler)handlers[i]).preInvoke(stringArray);
                continue;
            }
            catch (Throwable throwable) {
                WSLauncher.debug("Error processing handler " + vector.get(i));
                throwable.printStackTrace(LoggingServices.out);
            }
        }
        return stringArray;
    }

    private static void processBootFile(String string, Vector vector) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(System.getProperty("was.install.root"));
            stringBuffer.append(File.separator);
            stringBuffer.append("bin");
            stringBuffer.append(File.separator);
            stringBuffer.append("boot");
            stringBuffer.append(File.separator);
            stringBuffer.append(string);
            stringBuffer.append(".boot");
            File file = new File(stringBuffer.toString());
            if (!file.exists()) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("include ")) {
                    WSLauncher.processBootFile(string2.substring("include ".length()), vector);
                    continue;
                }
                vector.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void postInvoke() {
        if (handlers == null) {
            return;
        }
        for (int i = handlers.length - 1; i >= 0; --i) {
            if (handlers[i] == null) continue;
            Object var1_1 = null;
            try {
                ((InvocationHandler)handlers[i]).postInvoke();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(LoggingServices.out);
            }
        }
    }

    private static String[] removeProfileName(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length()).trim();
        if (!(string2.equals("WSProfileCLI") || string2.equals("WsProfile") || Boolean.getBoolean("KeepProfileName"))) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("-profileName")) continue;
                int n = 1;
                if (i < stringArray.length - 1 && !stringArray[i + 1].startsWith("-")) {
                    n = 2;
                }
                stringArray2 = new String[stringArray.length - n];
                System.arraycopy(stringArray, 0, stringArray2, 0, i);
                System.arraycopy(stringArray, i + n, stringArray2, i, stringArray2.length - i);
                break;
            }
        }
        return stringArray2;
    }

    private static void checkTimeBomb(String[] stringArray) {
        if (!(isIseries || isZOS || TimeBomb.checkLicense((boolean)true) || stringArray[0].indexOf("WsServerStop") >= 0)) {
            System.exit(-1);
        }
    }

    static {
        overrideZOS = Boolean.getBoolean("com.ibm.websphere.zos.forcedist");
        String string = System.getProperty("os.name").trim();
        isZOS = (string.equals("OS/390") || string.equals("z/OS")) && !overrideZOS;
        isIseries = string.equals("OS/400");
    }
}

