/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

public final class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    static final long serialVersionUID = 7885790631402109830L;
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(DHPrivateKey.a("\u0017*<dY k\"xY0>1o\u0016\u0015\u0018\u001c$\u0007t.<iY0\"<m"));
        }
    }

    DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(DHPrivateKey.a("\u001f.+*X;?rk\u0016\u0007\u000e\u0003_s\u001a\b\u0017"));
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException(DHPrivateKey.a("\". y_;%rg_'&3~U<qr\"E!;\"eD .60\u0016") + PKCS8_VERSION + DHPrivateKey.a("xk\"kD'.60\u0016") + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(DHPrivateKey.a("\u0015'5CRt\"!*X;?rk\u0016\u0007\u000e\u0003_s\u001a\b\u0017"));
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(DHPrivateKey.a("\u0004* k[1?7xEt&;yE=%5"));
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(DHPrivateKey.a("\u001a>>f\u0016$* k[1?7xE"));
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(DHPrivateKey.a("\u0004* k[1?7xEt%=~\u00165k\u0001Og\u0001\u000e\u001cIs"));
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(DHPrivateKey.a("\u00113&xWt;3xW9.&oDt/3~W"));
            }
            this.key = derValue.getData().getOctetString();
            this.a();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(DHPrivateKey.a("\u00049;|W .\u007f|W8>7*Z1%5~^t?=e\u00166\"5"));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return DHPrivateKey.a("\u0004\u0000\u0011Y\u0015l");
    }

    public String getAlgorithm() {
        return DHPrivateKey.a("\u0010\u0003");
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(this.p);
                derOutputStream3.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream3.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getX() {
        return this.x;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(DHPrivateKey.a("\u001d\t\u001f@u\u0011\r\u001bZet\u000f;lP=.\u007fBS8'?kXt\u001b c@5?7*}12h\u0000NnA") + this.x.toString() + "\n" + DHPrivateKey.a("$qX") + this.p.toString() + "\n" + DHPrivateKey.a("3qX") + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(DHPrivateKey.a("^'h\u0000\u0016tkr") + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        int n3 = 1;
        while (n3 < byArray.length) {
            n2 += byArray[n3] * n3;
            ++n3;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PrivateKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public void zeroize() {
        this.x = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.g = BigInteger.ZERO;
        this.l = 0;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 84;
                        break;
                    }
                    case 1: {
                        n5 = 75;
                        break;
                    }
                    case 2: {
                        n5 = 82;
                        break;
                    }
                    case 3: {
                        n5 = 10;
                        break;
                    }
                    default: {
                        n5 = 54;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

