/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.security;

import com.ibm.WebSphereSecurity.AuthenticationFailedException;
import com.ibm.WebSphereSecurity.AuthenticationNotSupportedException;
import com.ibm.WebSphereSecurity.BasicAuthData;
import com.ibm.WebSphereSecurity.Credential;
import com.ibm.WebSphereSecurity.InvalidTokenException;
import com.ibm.WebSphereSecurity.TokenExpiredException;
import com.ibm.WebSphereSecurity.UnsupportedRealmException;
import com.ibm.WebSphereSecurity.ValidationFailedException;
import com.ibm.WebSphereSecurity.ValidationNotSupportedException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.security.auth.CredentialMapFailedException;
import com.ibm.ejs.security.auth.CredentialMapNotSupportedException;
import com.ibm.ejs.security.ltpa.LTPAServer;
import com.ibm.ejs.security.ltpa.LTPAServerHome;
import com.ibm.ejs.security.ltpa.LTPAServerObject;
import com.ibm.ejs.security.registry.Registry;
import com.ibm.ejs.security.registry.RegistryBean;
import com.ibm.ejs.security.registry.RegistryHome;
import com.ibm.ejs.security.util.ByteArray;
import com.ibm.ejs.security.util.CacheException;
import com.ibm.ejs.security.util.Constants;
import com.ibm.ejs.security.util.LTPAAuthenticationCache;
import com.ibm.ejs.security.util.LTPATokenCache;
import com.ibm.ejs.security.util.StringUtil;
import com.ibm.ejs.sm.active.ActiveSecurityConfigConfig;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.exception.ActiveObjectException;
import com.ibm.ejs.sm.server.ManagedServer;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;

public class SecurityServerBean
implements SessionBean {
    private static final String nullString = new String();
    private static final String[] nullStringArray = new String[0];
    private static ActiveSecurityConfigConfig activeConfig;
    private SessionContext sessionCtx;
    protected static LTPAServer ltpaServerBean;
    protected static Registry registry;
    private static final TraceComponent tc;
    protected static LTPAAuthenticationCache ltpaAuthCache;
    public static final String LTPA_AUTH_CACHE_SIZE = "com.ibm.websphere.security.util.LTPAAuthCacheSize";
    protected static LTPATokenCache ltpaTokenCache;
    public static final String LTPA_TOKEN_CACHE_SIZE = "com.ibm.websphere.security.util.LTPATokenCacheSize";
    static /* synthetic */ Class class$com$ibm$ejs$security$SecurityServerBean;
    static /* synthetic */ Class class$com$ibm$ejs$security$registry$RegistryHome;
    static /* synthetic */ Class class$com$ibm$ejs$security$ltpa$LTPAServerHome;

    public static void configUpdated(ActiveSecurityConfigConfig activeSecurityConfigConfig) throws ActiveObjectException {
        Tr.entry((TraceComponent)tc, (String)"configUpdated");
        try {
            RegistryBean.configUpdated(activeSecurityConfigConfig);
            activeConfig = activeSecurityConfigConfig;
            Tr.exit((TraceComponent)tc, (String)"configUpdated");
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getString("security.active.update.error", "Error updating active configuration"), (Object)exception);
            throw new ActiveObjectException(exception.toString());
        }
    }

    public void ejbActivate() throws RemoteException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ejbCreate() throws CreateException {
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        try {
            try {
                Context context = RepositoryObjectImpl.getInitialNamingContext();
                ManagedServer managedServer = ManagedServer.getInstance();
                if (registry == null) {
                    Object object = context.lookup(managedServer.qualifyRepositoryHomeName("RegistryHome"));
                    RegistryHome registryHome = (RegistryHome)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ejs$security$registry$RegistryHome == null ? (class$com$ibm$ejs$security$registry$RegistryHome = SecurityServerBean.class$("com.ibm.ejs.security.registry.RegistryHome")) : class$com$ibm$ejs$security$registry$RegistryHome));
                    registry = registryHome.create();
                }
                Object var6_6 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Tr.warning((TraceComponent)tc, (String)"ejbCreate", (Object)exception);
                Object var6_7 = null;
                Tr.exit((TraceComponent)tc, (String)"ejbCreate");
                throw new CreateException();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Tr.exit((TraceComponent)tc, (String)"ejbCreate");
            throw throwable;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
    }

    public void ejbPassivate() throws RemoteException {
    }

    public void ejbRemove() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void setSessionContext(SessionContext sessionContext) throws RemoteException {
        this.sessionCtx = sessionContext;
    }

    public Credential authenticateBasicAuthData(String string, BasicAuthData basicAuthData) throws RemoteException, AuthenticationNotSupportedException, AuthenticationFailedException, UnsupportedRealmException {
        Credential credential;
        block4: {
            Tr.entry((TraceComponent)tc, (String)"authenticateBasicAuthData");
            ltpaAuthCache = this.getLTPAAuthenticationCache();
            credential = null;
            try {
                credential = ltpaAuthCache.getCredential(basicAuthData.userId, basicAuthData.password);
                if (credential != null) {
                    byte[] byArray = credential.credentialToken;
                    ByteArray byteArray = new ByteArray(byArray);
                    ltpaTokenCache = this.getLTPATokenCache();
                    ltpaTokenCache.insert((Object)byteArray, credential);
                }
            }
            catch (CacheException cacheException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception from LTPAAuthenticationCache", (Object)((Object)cacheException));
            }
        }
        if (credential == null) {
            throw new AuthenticationFailedException();
        }
        Tr.exit((TraceComponent)tc, (String)"authenticateBasicAuthData");
        return credential;
    }

    public Credential validate(String string, byte[] byArray) throws RemoteException, InvalidTokenException, TokenExpiredException, ValidationFailedException, ValidationNotSupportedException, UnsupportedRealmException {
        Credential credential;
        block3: {
            Tr.entry((TraceComponent)tc, (String)"validate");
            ltpaTokenCache = this.getLTPATokenCache();
            credential = null;
            try {
                credential = ltpaTokenCache.getCredential(byArray);
            }
            catch (CacheException cacheException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception from LTPATokenCache", (Object)((Object)cacheException));
            }
        }
        if (credential == null) {
            Tr.debug((TraceComponent)tc, (String)"Credential returned from LTPATokenCache is NULL");
            throw new ValidationFailedException();
        }
        Tr.exit((TraceComponent)tc, (String)"validate");
        return credential;
    }

    public Credential mapCredential(String string, Credential credential) throws CredentialMapNotSupportedException, CredentialMapFailedException, RemoteException {
        Tr.entry((TraceComponent)tc, (String)"mapCredential");
        LTPAServerObject lTPAServerObject = this.getLTPAServer();
        if (lTPAServerObject == null) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getString("security.ltpaserver.notexist", "LTPAServer does not exist"));
            throw new CredentialMapNotSupportedException("LTPAServer non existent");
        }
        Credential credential2 = lTPAServerObject.mapCredential(credential);
        if (credential2 != null) {
            Tr.debug((TraceComponent)tc, (String)"insert credentialToken");
            byte[] byArray = credential2.credentialToken;
            ByteArray byteArray = new ByteArray(byArray);
            ltpaTokenCache = this.getLTPATokenCache();
            ltpaTokenCache.insert((Object)byteArray, credential2);
        }
        Tr.exit((TraceComponent)tc, (String)"mapCredential");
        return credential2;
    }

    public Credential authenticateSSOToken(String string, byte[] byArray) throws RemoteException, AuthenticationNotSupportedException, AuthenticationFailedException, InvalidTokenException, UnsupportedRealmException {
        Tr.entry((TraceComponent)tc, (String)"authenticateSSOToken");
        Object var3_3 = null;
        LTPAServerObject lTPAServerObject = this.getLTPAServer();
        if (lTPAServerObject == null) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getString("security.ltpaserver.notexist", "LTPAServer does not exist"));
            throw new AuthenticationNotSupportedException();
        }
        Credential credential = lTPAServerObject.authenticateLoginToken(byArray);
        Tr.exit((TraceComponent)tc, (String)"authenticateSSOToken");
        return credential;
    }

    public byte[] issueSSOToken(BasicAuthData basicAuthData) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"issueSSOToken");
        LTPAServerObject lTPAServerObject = this.getLTPAServer();
        if (lTPAServerObject == null) {
            Tr.error((TraceComponent)tc, (String)Constants.nls.getString("security.ltpaserver.notexist", "LTPAServer does not exist"));
            throw new RemoteException(Constants.nls.getString("security.ltpaserver.notexist", "LTPAServer does not exist"));
        }
        Tr.exit((TraceComponent)tc, (String)"issueSSOToken");
        return lTPAServerObject.issueLoginToken(basicAuthData);
    }

    public Registry getRegistry(String string) throws RemoteException, UnsupportedRealmException {
        Tr.entry((TraceComponent)tc, (String)"getRegistry");
        Tr.exit((TraceComponent)tc, (String)"getRegistry");
        return registry;
    }

    protected LTPAAuthenticationCache getLTPAAuthenticationCache() {
        Tr.entry((TraceComponent)tc, (String)"getLTPAAuthenticationCache");
        if (ltpaAuthCache == null) {
            this.initLTPAServerBean();
            long l = activeConfig != null ? (long)activeConfig.getPluginCacheTimeout() : 600L;
            String string = System.getProperty(LTPA_AUTH_CACHE_SIZE);
            if (string == null) {
                string = "200";
            }
            ltpaAuthCache = new LTPAAuthenticationCache(ltpaServerBean, new Integer(string).intValue(), l * 1000L);
        }
        Tr.exit((TraceComponent)tc, (String)"getLTPAAuthenticationCache");
        return ltpaAuthCache;
    }

    protected LTPATokenCache getLTPATokenCache() {
        Tr.entry((TraceComponent)tc, (String)"getLTPATokenCache");
        if (ltpaTokenCache == null) {
            this.initLTPAServerBean();
            long l = activeConfig != null ? (long)activeConfig.getPluginCacheTimeout() : 600L;
            String string = System.getProperty(LTPA_TOKEN_CACHE_SIZE);
            if (string == null || string == "" || new Integer(string) < 0) {
                string = "200";
            }
            ltpaTokenCache = new LTPATokenCache(ltpaServerBean, new Integer(string).intValue(), l * 1000L);
        }
        Tr.exit((TraceComponent)tc, (String)"getLTPATokenCache");
        return ltpaTokenCache;
    }

    protected LTPAServerObject getLTPAServer() {
        Tr.entry((TraceComponent)tc, (String)"getLTPAServer");
        this.initLTPAServerBean();
        Tr.exit((TraceComponent)tc, (String)"getLTPAServer");
        return new LTPAServerObject();
    }

    protected void initLTPAServerBean() {
        if (activeConfig.getAuthenticationMechanism().equals("LTPA")) {
            if (ltpaServerBean == null) {
                try {
                    Context context = RepositoryObjectImpl.getInitialNamingContext();
                    Object object = context.lookup(ManagedServer.getInstance().qualifyRepositoryHomeName("LTPAServerHome"));
                    LTPAServerHome lTPAServerHome = (LTPAServerHome)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ejs$security$ltpa$LTPAServerHome == null ? (class$com$ibm$ejs$security$ltpa$LTPAServerHome = SecurityServerBean.class$("com.ibm.ejs.security.ltpa.LTPAServerHome")) : class$com$ibm$ejs$security$ltpa$LTPAServerHome));
                    byte[] byArray = SecurityServerBean.getLTPAPassword(activeConfig);
                    ltpaServerBean = lTPAServerHome.create(registry, byArray);
                }
                catch (Exception exception) {}
            }
        } else if (ltpaServerBean != null) {
            try {
                ltpaServerBean.remove();
            }
            catch (RemoveException removeException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            ltpaServerBean = null;
        }
    }

    protected static byte[] getLTPAPassword(ActiveSecurityConfigConfig activeSecurityConfigConfig) throws UnsupportedEncodingException {
        String string = activeSecurityConfigConfig.getAuthenticationMechanismProperties().getProperty("code");
        string = StringUtil.decrypt((String)string);
        return string.getBytes("UTF8");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        tc = Tr.register((Class)(class$com$ibm$ejs$security$SecurityServerBean == null ? (class$com$ibm$ejs$security$SecurityServerBean = SecurityServerBean.class$("com.ibm.ejs.security.SecurityServerBean")) : class$com$ibm$ejs$security$SecurityServerBean));
        ltpaAuthCache = null;
        ltpaTokenCache = null;
    }
}

