/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.security.ltpa;

import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.security.ltpa.KeyEncryptor;
import com.ibm.ejs.security.ltpa.LTPAConfig;
import com.ibm.ejs.security.ltpa.LTPAConfigAttributes;
import com.ibm.ejs.security.ltpa.LTPACrypto;
import com.ibm.ejs.security.ltpa.LTPADigSignature;
import com.ibm.ejs.security.ltpa.LTPAKeyPair;
import com.ibm.ejs.security.ltpa.LTPAServerActiveConfig;
import com.ibm.ejs.security.util.Base64Coder;
import com.ibm.ejs.security.util.Constants;
import com.ibm.ejs.sm.active.ActiveObjectConfig;
import com.ibm.ejs.sm.agent.AdminAgent;
import com.ibm.ejs.sm.agent.ContainmentPath;
import com.ibm.ejs.sm.agent.ContainmentPathElem;
import com.ibm.ejs.sm.agent.ParamList;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeHome;
import com.ibm.ejs.sm.beans.RepositoryObjectImpl;
import com.ibm.ejs.sm.beans.Type;
import com.ibm.ejs.sm.exception.AttributeDoesNotExistException;
import com.ibm.ejs.sm.exception.AttributeNotSetException;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.ObjectCollection;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.ejs.sm.util.act.Act;
import com.ibm.ejs.sm.util.act.ActServerImpl;
import com.ibm.ejs.sm.util.db.DBMgr;
import com.ibm.ejs.sm.util.db.DBQueryResult;
import com.ibm.ejs.sm.util.task.AsyncTask;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;

public class LTPAConfigBean
extends RepositoryObjectImpl
implements EntityBean {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$security$ltpa$LTPAConfigBean == null ? (class$com$ibm$ejs$security$ltpa$LTPAConfigBean = LTPAConfigBean.class$("com.ibm.ejs.security.ltpa.LTPAConfigBean")) : class$com$ibm$ejs$security$ltpa$LTPAConfigBean));
    private static Object classLock = new Object();
    private static Long myTypeId = null;
    private static Type myTypeObj = null;
    private static boolean tablesCreated = false;
    private long expirationTime;
    private boolean isPasswordInToken = false;
    private byte[] encryptedPrivateKey;
    private byte[] publicKey;
    private byte[] encryptedSharedKey;
    private byte[] privateKey;
    private byte[] sharedKey;
    private byte[] adminPassword = null;
    private boolean dirty;
    private boolean varsDirty;
    private boolean keysDirty;
    static final int ALL_DIRTY = 1;
    static final int KEYS_DIRTY = 2;
    static final int VARS_DIRTY = 3;
    private static boolean tableCreated = false;
    private static final String myInterfaceName = "com.ibm.ejs.security.ltpa.LTPAConfig";
    private static final String myClassName = "com.ibm.ejs.security.ltpa.LTPAConfigBean";
    private static final String tableName = DBMgr.qualifiedTableName((String)"LTPACONFIG_TABLE");
    private static final String expirationTimeColumnName = "EXPIRATION_TIME";
    private static final int expirationTimeColumnIndex = 3;
    private static final String isPasswordInTokenColumnName = "IS_PASSWD_IN_TOKEN";
    private static final int isPasswordInTokenColumnIndex = 4;
    private static final int numColumns = 4;
    private static String CURRENT_LTPA_VERSION = "1.0";
    public static final String SHARED_KEY_PROPERTY = "com.ibm.websphere.ltpa.3DESKey";
    public static final String PUBLIC_KEY_PROPERTY = "com.ibm.websphere.ltpa.PublicKey";
    public static final String PRIVATE_KEY_PROPERTY = "com.ibm.websphere.ltpa.PrivateKey";
    public static final String LTPA_VERSION_PROPERTY = "com.ibm.websphere.ltpa.version";
    public static final String CREATION_DATE_PROPERTY = "com.ibm.websphere.CreationDate";
    public static final String CREATION_HOST_PROPERTY = "com.ibm.websphere.CreationHost";
    public static final String LDAP_REALM_PROPERTY = "com.ibm.websphere.ltpa.Realm";
    private static final String encryptedPrivateKeyAttrName = "com.ibm.ejs.security.ltpa.LTPAConfig.privateKey";
    private static final String publicKeyAttrName = "com.ibm.ejs.security.ltpa.LTPAConfig.publicKey";
    private static final String encryptedSharedKeyAttrName = "com.ibm.ejs.security.ltpa.LTPAConfig.sharedKey";
    private static final int ltpaConfigBeanKeyBase = DBMgr.getPreparedStmtCacheKeyBase();
    private static final int loadStmtKey = ltpaConfigBeanKeyBase + 1;
    private static final int insertStmtKey = ltpaConfigBeanKeyBase + 2;
    private static final int deleteStmtKey = ltpaConfigBeanKeyBase + 3;
    private static final int findAllStmtKey = ltpaConfigBeanKeyBase + 4;
    private static final int updateStmtKey = ltpaConfigBeanKeyBase + 5;
    private static final int restrictedFindAllStmtKey = ltpaConfigBeanKeyBase + 6;
    private static final String updateStmtSql = "update " + tableName + " set " + "EXPIRATION_TIME" + " = ? ," + "IS_PASSWD_IN_TOKEN" + " = ? " + " where  " + "INSTANCE_ID" + " = ?";
    private static final String deleteStmtSql = "delete from " + tableName + " where " + "INSTANCE_ID" + " = ?";
    private static final String insertStmtSql = "insert into " + tableName + " values(?,?,?,?)";
    static /* synthetic */ Class class$com$ibm$ejs$security$ltpa$LTPAConfigBean;
    static /* synthetic */ Class class$com$ibm$ejs$sm$beans$Node;

    public LTPAConfigBean() throws RemoteException {
        LTPAConfigBean.initializePersistentStore();
        LTPAConfigBean.initializeTypeId();
    }

    private static void initializeTypeId() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"initializeTypeId");
        Object object = classLock;
        synchronized (object) {
            if (myTypeId != null) {
                return;
            }
        }
        Type type = RepositoryObjectImpl.getTypeObj(myInterfaceName, myClassName, new LTPAConfigAttributes(), true);
        Long l = (Long)type.getPrimaryKey();
        Object object2 = classLock;
        synchronized (object2) {
            myTypeObj = type;
            myTypeId = l;
        }
        Tr.exit((TraceComponent)tc, (String)"initializeTypeId", (Object)l);
    }

    private static void initializePersistentStore() throws RemoteException {
        Object object = classLock;
        synchronized (object) {
            if (tableCreated) {
                return;
            }
        }
        Tr.entry((TraceComponent)tc, (String)"initializePersistentStore");
        String string = " create table " + tableName + " ( " + "INSTANCE_ID" + DBMgr.idColumnSpec + " , " + "TYPE_ID" + DBMgr.idColumnSpec + " , " + expirationTimeColumnName + DBMgr.idColumnSpec + " ," + isPasswordInTokenColumnName + " integer not null" + " ," + " primary key(" + "INSTANCE_ID" + "))";
        try {
            DBMgr.createTableIfNonExistent((String)tableName, (String)string);
            Object object2 = classLock;
            synchronized (object2) {
                tableCreated = true;
            }
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(Constants.nls.getString("security.ltpaconfig.createexcp", "LTPAConfig creation exception"), sQLException);
            Tr.exit((TraceComponent)tc, (String)"initializePersistentStore", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"initializePersistentStore");
    }

    public Attributes getAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getAttributes");
        if (this.narrowRef != null) {
            return ((LTPAConfig)this.narrowRef).getAttributes(attributes);
        }
        Tr.exit((TraceComponent)tc, (String)"getAttributes");
        return this.readInstanceVariables(attributes);
    }

    public void setAttributes(Attributes attributes) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"setAttributes");
        if (this.narrowRef != null) {
            ((LTPAConfig)this.narrowRef).setAttributes(attributes);
            return;
        }
        LTPAConfigAttributes lTPAConfigAttributes = (LTPAConfigAttributes)attributes;
        this.updateInstanceVariables(lTPAConfigAttributes);
        Tr.exit((TraceComponent)tc, (String)"setAttributes");
    }

    private Long doCreate(LTPAConfigAttributes lTPAConfigAttributes) throws RemoteException, CreateException {
        Tr.entry((TraceComponent)tc, (String)"doCreate");
        Enumeration enumeration = this.ejbFindAll(false);
        if (enumeration.hasMoreElements()) {
            throw new CreateException();
        }
        if (this.typeId == null) {
            this.typeId = myTypeId;
        }
        this.id = this.create(this.typeId);
        this.initializeInstanceVariables();
        this.updateInstanceVariables(lTPAConfigAttributes);
        try {
            Vector<Object> vector = new Vector<Object>(4);
            vector.addElement(Utils.getIdString((Long)this.id));
            vector.addElement(Utils.getIdString((Long)this.typeId));
            vector.addElement(Utils.getIdString((Long)new Long(this.expirationTime)));
            vector.addElement(new Integer(Utils.booleanToInt((boolean)this.isPasswordInToken)));
            DBMgr.executePreparedUpdate((int)insertStmtKey, (String)insertStmtSql, vector);
        }
        catch (SQLException sQLException) {
            Tr.exit((TraceComponent)tc, (String)"doCreate", (Object)sQLException);
            RemoteException remoteException = new RemoteException(Constants.nls.getString("security.ltpaconfig.createexcp", "LTPAConfig creation exception"), sQLException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"doCreate", (Object)this.id);
        return this.id;
    }

    public Long ejbCreate(byte[] byArray, LTPAConfigAttributes lTPAConfigAttributes) throws CreateException, RemoteException {
        Long l;
        Tr.entry((TraceComponent)tc, (String)"ejbCreate");
        this.adminPassword = byArray;
        Enumeration enumeration = this.ejbFindAll(false);
        if (enumeration.hasMoreElements()) {
            throw new CreateException();
        }
        try {
            l = this.doCreate(lTPAConfigAttributes);
        }
        catch (CreateException createException) {
            String string = Constants.nls.getString("security.ltpaconfig.createexcp", "LTPAConfig creation exception");
            Tr.error((TraceComponent)tc, (String)string, (Object)((Object)createException));
            throw new RemoteException(string, createException);
        }
        Tr.exit((TraceComponent)tc, (String)"ejbCreate");
        return l;
    }

    private void initializeInstanceVariables() throws RemoteException {
        this.generateKeys(this.adminPassword);
        this.isPasswordInToken = false;
        this.expirationTime = 1800000L;
    }

    private LTPAConfigAttributes readInstanceVariables(Attributes attributes) throws RemoteException {
        LTPAConfigAttributes lTPAConfigAttributes = (LTPAConfigAttributes)attributes;
        lTPAConfigAttributes.setExpirationTime(this.expirationTime);
        lTPAConfigAttributes.setIsPasswordInToken(this.isPasswordInToken);
        lTPAConfigAttributes.setEncryptedPrivateKey(this.encryptedPrivateKey);
        lTPAConfigAttributes.setPublicKey(this.publicKey);
        lTPAConfigAttributes.setEncryptedSharedKey(this.encryptedSharedKey);
        return lTPAConfigAttributes;
    }

    private void updateInstanceVariables(LTPAConfigAttributes lTPAConfigAttributes) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"updateInstanceVariables");
        this.dirty = true;
        try {
            if (lTPAConfigAttributes.isSet(LTPAConfigAttributes.expirationTime)) {
                this.expirationTime = lTPAConfigAttributes.getExpirationTime();
                this.varsDirty = true;
            }
            if (lTPAConfigAttributes.isSet(LTPAConfigAttributes.passwordInToken)) {
                this.isPasswordInToken = lTPAConfigAttributes.getIsPasswordInToken();
                this.varsDirty = true;
            }
            if (lTPAConfigAttributes.isSet(LTPAConfigAttributes.encryptedPrivateKey)) {
                this.encryptedPrivateKey = lTPAConfigAttributes.getEncryptedPrivateKey();
                this.keysDirty = true;
            }
            if (lTPAConfigAttributes.isSet(LTPAConfigAttributes.encryptedSharedKey)) {
                this.encryptedSharedKey = lTPAConfigAttributes.getEncryptedSharedKey();
                this.keysDirty = true;
            }
            if (lTPAConfigAttributes.isSet(LTPAConfigAttributes.publicKey)) {
                this.publicKey = lTPAConfigAttributes.getPublicKey();
                this.keysDirty = true;
            }
        }
        catch (AttributeNotSetException attributeNotSetException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeNotSetException));
            throw new RemoteException(Constants.nls.getString("security.active.update.error", "Error updating active configuration"), attributeNotSetException);
        }
        catch (AttributeDoesNotExistException attributeDoesNotExistException) {
            Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables", (Object)((Object)attributeDoesNotExistException));
            throw new RemoteException(Constants.nls.getString("security.active.update.error", "Error updating active configuration"), attributeDoesNotExistException);
        }
        this.scheduleServerUpdate();
        Tr.exit((TraceComponent)tc, (String)"updateInstanceVariables");
    }

    private void getBinaryAttributes() throws RemoteException {
        this.encryptedPrivateKey = (byte[])this.getBinaryAttr(encryptedPrivateKeyAttrName);
        this.publicKey = (byte[])this.getBinaryAttr(publicKeyAttrName);
        this.encryptedSharedKey = (byte[])this.getBinaryAttr(encryptedSharedKeyAttrName);
    }

    private void setBinaryAttributes() throws RemoteException {
        this.setBinaryAttr(encryptedPrivateKeyAttrName, this.encryptedPrivateKey);
        this.setBinaryAttr(publicKeyAttrName, this.publicKey);
        this.setBinaryAttr(encryptedSharedKeyAttrName, this.encryptedSharedKey);
    }

    public void ejbLoad() throws RemoteException {
        Long l = (Long)this.ec.getPrimaryKey();
        Tr.entry((TraceComponent)tc, (String)"ejbLoad", (Object)l);
        DBQueryResult dBQueryResult = null;
        try {
            try {
                dBQueryResult = DBMgr.executePreparedReadByPrimaryKey((int)loadStmtKey, (String)tableName, (String)"INSTANCE_ID", (String)Utils.getIdString((Long)l));
                ResultSet resultSet = dBQueryResult.getResultSet();
                if (!resultSet.next()) {
                    RemoteException remoteException = new RemoteException(Constants.nls.getString("security.ltpaconfig.notexist", "LTPA configuration not found"), new ObjectNotFoundException());
                    Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                    throw remoteException;
                }
                if (this.setId(resultSet, myTypeId)) {
                    super.ejbLoad();
                    this.expirationTime = Utils.getId((String)resultSet.getString(3));
                    this.isPasswordInToken = Utils.intToBoolean((int)resultSet.getInt(4));
                    this.getBinaryAttributes();
                }
                this.dirty = false;
                this.varsDirty = false;
                this.keysDirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(Constants.nls.getString("security.sql.exception", "Exception while querying database"), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbLoad", (Object)remoteException);
                throw remoteException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DBMgr.doneWithQuery(dBQueryResult);
            throw throwable;
        }
        DBMgr.doneWithQuery((DBQueryResult)dBQueryResult);
        Tr.exit((TraceComponent)tc, (String)"ejbLoad");
    }

    public void ejbStore() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"ejbStore");
        if (this.narrowRef != null) {
            return;
        }
        if (this.dirty) {
            this.setBinaryAttributes();
        }
        super.ejbStore();
        if (this.dirty) {
            try {
                Vector<Object> vector = new Vector<Object>(4);
                vector.addElement(Utils.getIdString((Long)new Long(this.expirationTime)));
                vector.addElement(new Integer(Utils.booleanToInt((boolean)this.isPasswordInToken)));
                vector.addElement(Utils.getIdString((Long)this.id));
                DBMgr.executePreparedUpdate((int)updateStmtKey, (String)updateStmtSql, vector);
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                RemoteException remoteException = new RemoteException(Constants.nls.getString("security.sql.exception", "Exception while querying database"), sQLException);
                Tr.exit((TraceComponent)tc, (String)"ejbStore", (Object)remoteException);
                throw remoteException;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"ejbStore");
    }

    public void ejbRemove() throws RemoteException, RemoveException {
        Tr.entry((TraceComponent)tc, (String)"ejbRemove");
        if (this.id == null) {
            this.ejbLoad();
        }
        if (this.narrowRef != null) {
            this.narrowRef.remove();
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            return;
        }
        Long l = (Long)this.ec.getPrimaryKey();
        super.ejbRemove();
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(Utils.getIdString((Long)l));
            DBMgr.executePreparedUpdate((int)deleteStmtKey, (String)deleteStmtSql, vector);
        }
        catch (SQLException sQLException) {
            this.ec.setRollbackOnly();
            String string = Constants.nls.getString("security.ltpaconfig.removeexcp", "LTPAConfig remove exception");
            RemoteException remoteException = new RemoteException(string, sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbRemove");
            Tr.error((TraceComponent)tc, (String)string, (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbRemove");
    }

    public void ejbPostCreate(byte[] byArray, LTPAConfigAttributes lTPAConfigAttributes) throws CreateException, RemoteException {
    }

    public Enumeration ejbFindAll() throws RemoteException {
        return this.ejbFindAll(true);
    }

    public Long ejbFind() throws FinderException, RemoteException {
        Enumeration enumeration = this.ejbFindAll(false);
        if (enumeration.hasMoreElements()) {
            return (Long)enumeration.nextElement();
        }
        throw new FinderException();
    }

    public Enumeration ejbFindAll(boolean bl) throws RemoteException {
        Enumeration enumeration;
        Tr.entry((TraceComponent)tc, (String)"ejbFindAll");
        int n = bl ? findAllStmtKey : restrictedFindAllStmtKey;
        try {
            enumeration = DBMgr.executeFindAll((int)n, (String)tableName, (boolean)bl, (String)"TYPE_ID", (Long)myTypeId, (String)"INSTANCE_ID");
        }
        catch (SQLException sQLException) {
            RemoteException remoteException = new RemoteException(Constants.nls.getString("security.sql.exception", "Exception while querying database"), sQLException);
            Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)remoteException);
            throw remoteException;
        }
        Tr.exit((TraceComponent)tc, (String)"ejbFindAll", (Object)((ObjectCollection)enumeration).getArray());
        return enumeration;
    }

    public Long ejbFindByPrimaryKey(Long l) throws RemoteException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"ejbFindByPrimaryKey");
        Tr.exit((TraceComponent)tc, (String)"ejbFindByPrimaryKey");
        return super.ejbFindByPrimaryKey(l);
    }

    public void generateKeys(byte[] byArray) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"generateKeys");
        this.adminPassword = byArray;
        KeyEncryptor keyEncryptor = new KeyEncryptor(this.adminPassword);
        LTPAKeyPair lTPAKeyPair = LTPADigSignature.generateLTPAKeyPair();
        this.publicKey = lTPAKeyPair.getPublic().getEncoded();
        this.privateKey = lTPAKeyPair.getPrivate().getEncoded();
        this.encryptedPrivateKey = keyEncryptor.encrypt((byte[])this.privateKey.clone());
        new LTPACrypto();
        this.sharedKey = LTPACrypto.generate3DESKey();
        this.encryptedSharedKey = keyEncryptor.encrypt((byte[])this.sharedKey.clone());
        this.dirty = true;
        this.keysDirty = true;
        this.scheduleServerUpdate();
        this.privateKey = null;
        this.sharedKey = null;
        Tr.exit((TraceComponent)tc, (String)"generateKeys");
    }

    private byte[] getPrivateKey(byte[] byArray) throws RemoteException {
        if (this.privateKey == null) {
            KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
            return keyEncryptor.decrypt((byte[])this.encryptedPrivateKey.clone());
        }
        return this.privateKey;
    }

    private byte[] getSharedKey(byte[] byArray) throws RemoteException {
        if (this.sharedKey == null) {
            KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
            return keyEncryptor.decrypt((byte[])this.encryptedSharedKey.clone());
        }
        return this.sharedKey;
    }

    private byte[] getPublicKey() throws RemoteException {
        return this.publicKey;
    }

    public void updateStoredKeys(byte[] byArray, byte[] byArray2) {
        Tr.entry((TraceComponent)tc, (String)"updateStoredKeys");
        KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
        byte[] byArray3 = keyEncryptor.decrypt(this.encryptedSharedKey);
        byte[] byArray4 = keyEncryptor.decrypt(this.encryptedPrivateKey);
        KeyEncryptor keyEncryptor2 = new KeyEncryptor(byArray2);
        this.encryptedSharedKey = keyEncryptor2.encrypt(byArray3);
        this.encryptedPrivateKey = keyEncryptor2.encrypt(byArray4);
        this.adminPassword = byArray2;
        Tr.exit((TraceComponent)tc, (String)"updateStoredKeys");
    }

    public ContainmentPathElem getActiveObjectName() throws RemoteException, OpException {
        String string = "com.ibm.ejs.security.ltpa.LTPAServerBean";
        ContainmentPathElem containmentPathElem = new ContainmentPathElem(this.id, string, this.getRelativeName(), this.getEpoch());
        return containmentPathElem;
    }

    private int getEpoch() {
        return 1;
    }

    private String getRelativeName() {
        return "";
    }

    private ActiveObjectConfig getConfig() throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        LTPAServerActiveConfig lTPAServerActiveConfig = new LTPAServerActiveConfig();
        lTPAServerActiveConfig.setExpirationTimeLimit(this.expirationTime);
        lTPAServerActiveConfig.setPasswordInToken(this.isPasswordInToken);
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return lTPAServerActiveConfig;
    }

    public ActiveObjectConfig getConfig(byte[] byArray) throws RemoteException, OpException {
        Tr.entry((TraceComponent)tc, (String)"getConfig");
        LTPAServerActiveConfig lTPAServerActiveConfig = new LTPAServerActiveConfig();
        lTPAServerActiveConfig.setExpirationTimeLimit(this.expirationTime);
        lTPAServerActiveConfig.setPasswordInToken(this.isPasswordInToken);
        lTPAServerActiveConfig.setPublicKey(this.getPublicKey());
        lTPAServerActiveConfig.setPrivateKey(this.getPrivateKey(byArray));
        lTPAServerActiveConfig.setSharedKey(this.getSharedKey(byArray));
        Tr.exit((TraceComponent)tc, (String)"getConfig");
        return lTPAServerActiveConfig;
    }

    public ContainmentPath getActiveObjectContainmentPath() throws RemoteException, OpException {
        ContainmentPath containmentPath;
        Tr.entry((TraceComponent)tc, (String)"getActiveObjectContainmentPath");
        try {
            containmentPath = this.getNode().getActiveObjectContainmentPath();
            containmentPath.addElement(this.getActiveObjectName());
        }
        catch (FinderException finderException) {
            throw new RemoteException(Constants.nls.getString("security.finder.exception", "Finder exception"), finderException);
        }
        Tr.exit((TraceComponent)tc, (String)"getActiveObjectContainmentPath");
        return containmentPath;
    }

    public void updateActiveObjects(byte[] byArray) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"updateActiveObjects");
        this.adminPassword = byArray;
        this.keysDirty = true;
        this.varsDirty = true;
        this.scheduleServerUpdate();
        Tr.exit((TraceComponent)tc, (String)"updateActiveObjects");
    }

    private void scheduleServerUpdate() {
        try {
            Tr.entry((TraceComponent)tc, (String)"scheduleServerUpdate");
            LTPAServerActiveConfig lTPAServerActiveConfig = this.keysDirty ? (LTPAServerActiveConfig)this.getConfig(this.adminPassword) : (LTPAServerActiveConfig)this.getConfig();
            Vector vector = this.getNodeAgents();
            int n = 0;
            if (this.keysDirty && this.varsDirty) {
                n = 1;
            } else if (this.keysDirty) {
                n = 2;
            } else if (this.varsDirty) {
                n = 3;
            }
            this.keysDirty = false;
            this.varsDirty = false;
            ActServerImpl actServerImpl = ActServerImpl.getInstance();
            Act act = actServerImpl.scheduleWork((AsyncTask)new UpdateTask(vector, lTPAServerActiveConfig, n));
        }
        catch (RemoteException remoteException) {
        }
        catch (OpException opException) {
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        Tr.exit((TraceComponent)tc, (String)"scheduleServerUpdate");
    }

    private Vector getNodeAgents() throws RemoteException, OpException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"getNodeAgent");
        Enumeration enumeration = this.getNodes();
        Vector<AdminAgent> vector = new Vector<AdminAgent>(5);
        while (enumeration.hasMoreElements()) {
            Node node = (Node)PortableRemoteObject.narrow(enumeration.nextElement(), (Class)(class$com$ibm$ejs$sm$beans$Node == null ? LTPAConfigBean.class$("com.ibm.ejs.sm.beans.Node") : class$com$ibm$ejs$sm$beans$Node));
            vector.addElement(node.getAdminAgent());
        }
        Tr.exit((TraceComponent)tc, (String)"getNodeAgent");
        return vector;
    }

    private Enumeration getNodes() throws RemoteException, OpException, FinderException {
        NodeHome nodeHome = (NodeHome)RepositoryObjectImpl.getHome("NodeHome");
        Enumeration enumeration = nodeHome.findAll(true);
        return enumeration;
    }

    private AdminAgent getNodeAgent() throws RemoteException, OpException, FinderException {
        Tr.entry((TraceComponent)tc, (String)"getNodeAgent");
        Node node = this.getNode();
        AdminAgent adminAgent = node.getAdminAgent();
        Tr.exit((TraceComponent)tc, (String)"getNodeAgent");
        return adminAgent;
    }

    private Node getNode() throws RemoteException, OpException, FinderException {
        NodeHome nodeHome = (NodeHome)RepositoryObjectImpl.getHome("NodeHome");
        Node node = nodeHome.findByName(ManagedServer.getInstance().getNodeName(), true);
        return node;
    }

    private void debug(String string) {
        System.out.println("LTPAConfigBean: " + string);
    }

    public void importSSOProperties(Properties properties, byte[] byArray) throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"importSSOProperties");
        this.adminPassword = byArray;
        String string = properties.getProperty(SHARED_KEY_PROPERTY);
        String string2 = properties.getProperty(PRIVATE_KEY_PROPERTY);
        String string3 = properties.getProperty(PUBLIC_KEY_PROPERTY);
        try {
            this.encryptedSharedKey = Base64Coder.base64Decode((byte[])string.getBytes("UTF8"));
            this.encryptedPrivateKey = Base64Coder.base64Decode((byte[])string2.getBytes("UTF8"));
            this.publicKey = Base64Coder.base64Decode((byte[])string3.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)"Unsupported encoding: UTF8");
        }
        this.dirty = true;
        this.keysDirty = true;
        this.scheduleServerUpdate();
        Tr.exit((TraceComponent)tc, (String)"importSSOProperties");
    }

    public Properties exportSSOProperties() throws RemoteException {
        Tr.entry((TraceComponent)tc, (String)"exportSSOProperties");
        byte[] byArray = Base64Coder.base64Encode((byte[])this.encryptedSharedKey);
        byte[] byArray2 = Base64Coder.base64Encode((byte[])this.encryptedPrivateKey);
        byte[] byArray3 = Base64Coder.base64Encode((byte[])this.publicKey);
        Properties properties = new Properties();
        try {
            String string;
            String string2;
            ((Hashtable)properties).put(SHARED_KEY_PROPERTY, new String(byArray, "UTF8"));
            ((Hashtable)properties).put(PRIVATE_KEY_PROPERTY, new String(byArray2, "UTF8"));
            ((Hashtable)properties).put(PUBLIC_KEY_PROPERTY, new String(byArray3, "UTF8"));
            ((Hashtable)properties).put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
            ((Hashtable)properties).put(CREATION_DATE_PROPERTY, new Date().toString());
            try {
                string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getLocalHost().getHostName();
                    }
                });
                ((Hashtable)properties).put(CREATION_HOST_PROPERTY, string2);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnknownHostException)privilegedActionException.getException();
            }
            string2 = EJSORB.getORBInstance();
            if (string2 != null && (string = string2.getProperty("com.ibm.CORBA.principalName")) != null && string.length() > 0) {
                ((Hashtable)properties).put(LDAP_REALM_PROPERTY, string.substring(0, string.indexOf("/")));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)"Unsupported encoding: UTF8");
        }
        catch (UnknownHostException unknownHostException) {
            Tr.debug((TraceComponent)tc, (String)"Unknown host exception");
        }
        Tr.exit((TraceComponent)tc, (String)"exportSSOProperties");
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class UpdateTask
    implements AsyncTask {
        String varsMethod = "updateVariables";
        String keysMethod = "updateKeys";
        String allMethod = "updateAll";
        private Vector agents;
        private ContainmentPath activeLTPAServerObject;
        private LTPAServerActiveConfig lsConfig;
        private int flag;

        UpdateTask(Vector vector, LTPAServerActiveConfig lTPAServerActiveConfig, int n) {
            this.agents = vector;
            try {
                this.activeLTPAServerObject = LTPAConfigBean.this.getActiveObjectContainmentPath();
            }
            catch (OpException opException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.lsConfig = lTPAServerActiveConfig;
            this.flag = n;
        }

        public String getName() {
            return "updateTask";
        }

        public void execute() throws RemoteException, OpException {
            Tr.entry((TraceComponent)tc, (String)"updateTask - execute");
            ParamList paramList = new ParamList(1);
            paramList.addElement((ActiveObjectConfig)this.lsConfig);
            int n = 0;
            int n2 = this.agents.size();
            while (n < n2) {
                AdminAgent adminAgent = (AdminAgent)this.agents.elementAt(n);
                if (this.flag == 1) {
                    adminAgent.invokeActiveObject(this.activeLTPAServerObject, this.allMethod, paramList);
                } else if (this.flag == 2) {
                    adminAgent.invokeActiveObject(this.activeLTPAServerObject, this.keysMethod, paramList);
                } else if (this.flag == 3) {
                    adminAgent.invokeActiveObject(this.activeLTPAServerObject, this.varsMethod, paramList);
                }
                ++n;
            }
            Tr.exit((TraceComponent)tc, (String)"updateTask - execute");
        }
    }
}

